//
//  MyLRF05-MoreEventHandlers.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-06-11.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

//

/*
 
 Tutorial #5 - Using multiple custom event handlers.
 
 This sketch shows you how to create multiple custom event handlers, connect them to
 events, and perform expressions when those events are triggered.
 
 Goals:
 - make custom patterns & sounds
 - make a couple custom event handlers and attach to events
 - play around with the different event types to create a unique set of responses to a touch or light events
 
 */

#include "LRF.h"

// Create a light pattern for the eyes
LRFPattern myPattern = {
	LRFColor_Blue,			// starting color
	LRFColor_Green,			// target color
	LRFPatternMode_Fade		// pattern behaviour (see LRFUtils.h for more info)
};

// Create another light pattern for our second handler
LRFPattern myOtherPattern = {
	LRFColor_Pink,			// starting color
	LRFColor_Purple,			// target color
	LRFPatternMode_BoomerangToggle		// pattern behaviour (see LRFUtils.h for more info)
};

// Create an array of sounds
LRFSound mySounds[3] = {
	{ LRFNote_A, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None }	// <-- make sure the last entry has no comma!
};

// Create a custom event handler function
void myTapHandler(void)
{
	// let's blink and say our array of sounds
	lrf.blinkAndSay(myPattern, mySounds, 3);
}

void myTickleHandler(void)
{
	// let's blink our other pattern with our sounds
	lrf.blinkAndSay(myOtherPattern, mySounds, 3);
}

// ------------------ everything below this point runs the program --------------------

void setup(void) // Arduino setup routine that gets called ONCE when the robot turns on
{
	lrf.setup(); // lrf library should be set up before anything else
	
	// let's connect our event handlers
	lrf.setEventHandler(LRFEvent_Tap, &myTapHandler);
	lrf.setEventHandler(LRFEvent_Tickle, &myTickleHandler);
}

// Arduino loop routine that gets called OVER AND OVER while the robot runs
void loop(void)
{
	// run the lrf library
	lrf.loop();
	
	// any other functions put in here might cause the lrf to behave strange (no delays plz!)
}
