//
//  LRFUtils.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-01.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include "LRFUtils.h"
#include "LRFHardware.h"
#include "LRFMemory.h"

#define LRF_DURATION_BASE_UNIT		50

#define LRF_DURATIONS_COUNT			8
#define LRF_SCALE_COUNT				12
#define LRF_COLORS_COUNT			16

const unsigned int PROGMEM lrfDurations[LRF_DURATIONS_COUNT] = {
	0,
	LRF_DURATION_BASE_UNIT * 1,		// short
	LRF_DURATION_BASE_UNIT * 2,		// double short
	LRF_DURATION_BASE_UNIT * 4,		// medium
	LRF_DURATION_BASE_UNIT * 8,		// double medium
	LRF_DURATION_BASE_UNIT * 16,	// long
	LRF_DURATION_BASE_UNIT * 32,	// double long
	LRF_DURATION_BASE_UNIT * 64,	// very long
};

const unsigned int PROGMEM lrfScale[LRF_SCALE_COUNT] = {
	55, 58, 62, 65, 69, 73, 78, 82, 87, 92, 98, 104
};

const unsigned char PROGMEM lrfColors[LRF_COLORS_COUNT * 3] = {
	0,0,0,										// blank
	LRF_RGB_VALUE_HIGH,0,0,						// red
	0,LRF_RGB_VALUE_HIGH,0,						// green
	0,0,LRF_RGB_VALUE_HIGH,						// blue
	LRF_RGB_VALUE_HIGH,LRF_RGB_VALUE_MED,0,		// orange
	0,LRF_RGB_VALUE_HIGH,LRF_RGB_VALUE_HIGH,	// cyan
	LRF_RGB_VALUE_SOFT,0,LRF_RGB_VALUE_HIGH,	// purple
	
	LRF_RGB_VALUE_MED,LRF_RGB_VALUE_HIGH,0,		// yellow
	LRF_RGB_VALUE_HIGH,0,LRF_RGB_VALUE_MED,		// pink
	
	LRF_RGB_VALUE_SOFT,0,0,						// soft red
	0,LRF_RGB_VALUE_SOFT,0,						// soft green
	0,0,LRF_RGB_VALUE_SOFT,						// soft blue
	LRF_RGB_VALUE_SOFT,LRF_RGB_VALUE_SOFT,0,	// soft orange
	0,LRF_RGB_VALUE_SOFT,LRF_RGB_VALUE_SOFT,	// soft cyan
	LRF_RGB_VALUE_SOFT,0,LRF_RGB_VALUE_SOFT,	// soft pink
	LRF_RGB_VALUE_MED,LRF_RGB_VALUE_MED,LRF_RGB_VALUE_MED	// white
};

bool lrf_utils_is_holiday_hardware(void)
{
	if(lrf_memory_read(LRF_MEMORY_HARDWARE_VERSION_MAJOR_ADDR) == 0x01 &&
	   lrf_memory_read(LRF_MEMORY_HARDWARE_VERSION_MINOR_ADDR) == 0x00)
		return true;
	else
		return false;
}

void lrf_utils_color_lookup_random(LRFColorValue *value)
{
	unsigned char color = 1 + (rand()%8);
	lrf_utils_color_lookup((LRFColor)color, value);
}

void lrf_utils_color_lookup(LRFColor color, LRFColorValue *value)
{
	unsigned char idx = color * 3;
	value->red = pgm_read_byte(&lrfColors[idx]);
	value->green = pgm_read_byte(&lrfColors[idx+1]);
	value->blue = pgm_read_byte(&lrfColors[idx+2]);
}

unsigned int lrf_utils_duration_lookup(LRFDuration duration)
{
	return pgm_read_word(&lrfDurations[(unsigned char)duration]);
}

unsigned int lrf_utils_note_to_frequency(LRFNote note, LRFOctave octave=LRFOctave_1)
{
	unsigned int freq;
	
//#if LRF_SPEECH_DEBUG
//	Serial.print("n2f:");
//	Serial.print(note,DEC);
//	Serial.print(",");
//	Serial.print(octave,DEC);
//#endif
	
	if(note > LRFNote_GS) note = LRFNote_GS;
	freq = pgm_read_word(&lrfScale[note]);
	
//#if LRF_SPEECH_DEBUG
//	Serial.print("=");
//	Serial.print(freq,DEC);
//#endif
	
	freq *= pow(2,octave);
	
//#if LRF_SPEECH_DEBUG
//	Serial.print("=");
//	Serial.print(freq,DEC);
//#endif
	
	freq = F_CPU / freq / 2 - 1;
	
//#if LRF_SPEECH_DEBUG
//	Serial.print("=");
//	Serial.print(freq,DEC);
//#endif
	
	return freq;
}