//
//  LRFSignatureData.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-02.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFSignatureData_h
#define __LRFSignatureData_h

#include "LRFUtils.h"

#define LRF_SIGNATURE_MAX					11
#define LRF_SIGNATURE_SOUND_COUNT			4

typedef enum
{
	LRFSignature_Normal = 0,
	LRFSignature_Chatterbot,
	LRFSignature_Divabot,
	LRFSignature_Platobot,
	LRFSignature_Rascalbot,
	LRFSignature_Nannabot,
	LRFSignature_Officebot,
	LRFSignature_Partybot,
	LRFSignature_Scaredybot,
	LRFSignature_Jollybot,
	LRFSignature_Evilbot
} __attribute__ ((packed)) LRFSignature;

extern LRFPatternStruct PROGMEM lrfSignaturePatterns[LRF_SIGNATURE_MAX];
extern LRFSoundStruct	PROGMEM lrfSignatureSounds[LRF_SIGNATURE_MAX * LRF_SIGNATURE_SOUND_COUNT];


#endif