//
//  LRFMemory.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-20.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include "LRFMemory.h"
#include "LRFPersonality.h"
#include "LRFExpressions.h"
#include "LRFEvents.h"
#include "LRFDebug.h"

const char debug_title[] = "mem";


void lrf_memory_load(void)
{
#if LRF_MEMORY_DEBUG
	lrf_debug_tag(debug_title, "l", false);
#endif
	
	// read personality from eeprom
	eeprom_read_block(&lrfPersonality.neediness,(const void *)LRF_MEMORY_PERSONALITY_START_ADDR,LRF_MEMORY_PERSONALITY_LENGTH);
	
#if LRF_MEMORY_DEBUG
	// let's verify what we've read
	lrf_debug_list("p", &lrfPersonality.neediness, 6);
#endif
	
	// read event history
	eeprom_read_block(&lrfEvents.eventHistory[0],(const void *)LRF_MEMORY_EVENT_HISTORY_START_ADDR,LRF_EVENTS_HISTORY_SIZE);

	// read signature
	lrfExpressions.signatureIdx = eeprom_read_byte((const uint8_t *)LRF_MEMORY_SIGNATURE_ADDR);
}

void lrf_memory_save_personality(void)
{
#if LRF_MEMORY_DEBUG
	lrf_debug_tag(debug_title, "sp");
#endif

	// loop through settings to see if we need to update
	for(unsigned char i=0; i<LRF_MEMORY_PERSONALITY_LENGTH; i++)
	{
		unsigned char eval = eeprom_read_byte((uint8_t *)(LRF_MEMORY_PERSONALITY_START_ADDR+i));
		unsigned char dval = *(&lrfPersonality.neediness + i);
		if(eval != dval)
		{
#if LRF_MEMORY_DEBUG_VERBOSE
			Serial.print("#");
			Serial.print(i,DEC);
			Serial.print(" ");
			Serial.print(eval,DEC);
			Serial.print(":");
			Serial.print(dval,DEC);
			Serial.println();
#endif
			// overwrite the eeprom value with data
			eeprom_write_byte((uint8_t *)(LRF_MEMORY_PERSONALITY_START_ADDR+i),dval);
		}
	}

	// save the signature
	eeprom_write_byte((uint8_t *)LRF_MEMORY_SIGNATURE_ADDR,lrfExpressions.signatureIdx);
}

void lrf_memory_save_event_history(void)
{
#if LRF_MEMORY_DEBUG
	lrf_debug_tag(debug_title, "seh");
#endif

	// loop through event history
	for(unsigned char i=0; i<LRF_EVENTS_HISTORY_SIZE; i++)
	{
		unsigned char eval = eeprom_read_byte((uint8_t *)(LRF_MEMORY_EVENT_HISTORY_START_ADDR+i));
		unsigned char dval = *(&lrfEvents.eventHistory[0] + i);
		if(eval != dval)
		{
			// overwrite the eeprom value with data
			eeprom_write_byte((uint8_t *)(LRF_MEMORY_EVENT_HISTORY_START_ADDR+i),dval);
		}
	}
}

void lrf_memory_save(void)
{
#if LRF_MEMORY_DEBUG
	lrf_debug_tag(debug_title, "s");
#endif
	
	lrf_memory_save_personality();
	lrf_memory_save_event_history();
	
	delay(100);
}

