//
//  LRFInfrared.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-13.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFInfrared_h
#define __LRFInfrared_h

#include <Arduino.h>

#define LRF_IRDA_DEBUG			0

#define LRF_IRDA_DELAY_BYTE		20
#define LRF_IRDA_DELAY_BIT		5


//-------------------------------------------------------------
#pragma mark - Messages
//-------------------------------------------------------------

// Messages shouldn't exceed 15 (4-bit max)
typedef enum
{
	LRFIRMessage_Unknown = 0,
	LRFIRMessage_Hello = 1,
	LRFIRMessage_LetsChat = 2,
	LRFIRMessage_LetsSing = 3,
	LRFIRMessage_LeaveMeAlone = 4
} __attribute__ ((packed)) LRFIRMessage;

typedef struct
{
	bool hasMessage;
	bool dispatchedMessage;
	LRFIRMessage message;
	LRFIRMessage queued;
} LRFIR;

extern LRFIR lrfIrda;


//-------------------------------------------------------------
#pragma mark - Public Functions
//-------------------------------------------------------------

void lrf_irda_setup(void);
void lrf_irda_process(void);

void lrf_irda_reset_read(void);

void lrf_irda_queue_message(LRFIRMessage message);
void lrf_irda_write_queued_message(void);

void lrf_irda_write_message(LRFIRMessage message);
void lrf_irda_read_message(void);

#endif 
