//
//  MyLRF04-EventHandlers.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-06-11.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

//

/*
 
 Tutorial #4 - Creating a custom event handler.
 
 This sketch shows you how to create a custom event handler, connect it to an
 event, and perform an expression when that event is triggered.
 
 Goals:
 - make custom patterns & sounds
 - make a custom event handler and attach to event
 - play around with the different event types to trigger your handler during touch, light or mic events
 
 */

#include "LRF.h"

// Create a light pattern for the eyes
LRFPattern myPattern = {
	LRFColor_Blue,			// starting color
	LRFColor_Green,			// target color
	LRFPatternMode_Fade		// pattern behaviour (see LRFUtils.h for more info)
};

// Create an array of sounds
LRFSound mySounds[3] = {
	{ LRFNote_A, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None }	// <-- make sure the last entry has no comma!
};

// Create a custom event handler function
void myTapHandler(void)
{
	// let's blink and say our array of sounds
	lrf.blinkAndSay(myPattern, mySounds, 3);
}

// ------------------ everything below this point runs the program --------------------

void setup(void) // Arduino setup routine that gets called ONCE when the robot turns on
{
	lrf.setup(); // lrf library should be set up before anything else
	
	lrf.setEventHandler(LRFEvent_Tap, &myTapHandler); // let's connect our event handler to the tap event
}

void loop(void) // Arduino loop routine that gets called OVER AND OVER while the robot runs
{
	lrf.loop();	// run the lrf library
	
	// any other functions put in here might cause the lrf to behave strange (no delays plz!)
}
