//
//  MyLRF02-Say.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-06-11.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

//

/*
 
 Tutorial #2 - Custom Sound
 
 This sketch shows you how to create and run a custom sound on your robot.
 
 Goals:
	- Make a custom sound
	- Play around with the values to make a short and a long sound
	- Play around with the values to make a low and a high-pitched sound
 
 */

#include "LRF.h"

// Create a sound for the speaker
LRFSound mySound = {
	LRFNote_D,				// note
	LRFOctave_6,			// octave
	LRFIntonation_Falling,	// intonation (see LRFUtils.h for more info)
	LRFDuration_Long,		// note length
	LRFDuration_None		// pause length (after note has played)
};

// ------------------ everything below this point runs the program --------------------

void setup(void) // Arduino setup routine that gets called ONCE when the robot turns on
{
	lrf.setup(); // lrf library should be set up before anything else
	delay(1000);
	
	lrf.say(mySound); // let's try saying a sound
	delay(1000);
}

void loop(void) // Arduino loop routine that gets called OVER AND OVER while the robot runs
{
	lrf.loop(); // run the lrf library
	
	// any other functions put in here might cause the lrf to behave strange (no delays plz!)
}
