//
//  LRFSpeech.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 1/14/2014.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFSpeech_h
#define __LRFSpeech_h

#include <Arduino.h>
#include "LRFUtils.h"

//#define LRF_SPEECH_PITCH_OFFSET			22100
//#define LRF_SPEECH_PITCH_SCALER			720
//#define LRF_SPEECH_DURATION_SCALER		20
//#define LRF_SPEECH_PAUSE_SCALER			20

#define LRF_SPEECH_DEBUG					0

typedef void (*LRFSpeechDoneFunction)(void);

typedef enum
{
	LRFSpeechState_Idle = 0,
	LRFSpeechState_Ready,
	LRFSpeechState_Speaking,
	LRFSpeechState_Pausing,
	LRFSpeechState_Done = 255
} __attribute__ ((packed)) LRFSpeechState;

typedef struct
{
//	LRFSpeechState			state;				// state of the speaking operation
//	unsigned int			frequency;			// current speaker frequency
//	unsigned char			wordIdx;			// index of current word
//	unsigned long			wordStartTime;		// time we started speaking word
//	unsigned long			wordMidTime;		// middle time for the word
//	unsigned long			wordEndTime;		// time when the word should be done
//	LRFSoundExpressionName	expressionName;		// current expression
//	LRFSoundExpressionName	nextExpressionName;	// next expression
//	LRFSpeechDoneFunction	doneFunction;		// function to call when done
//	unsigned char			signatureIdx;		// signature sound index
//	LRFSound				sound;				// current sound.word
	

	LRFSpeechState			state;				// state of the speaking operation
	LRFSoundStruct			sound;				// currently loaded sound data

	unsigned int			frequency;			// current speaker frequency
	unsigned long			startTime;			// timestamp when current sound was loaded
	unsigned int			duration;			// duration of current sound
	
	
} LRFSpeech;


//-------------------------------------------------------------
#pragma mark - Public Functions
//-------------------------------------------------------------

void lrf_speech_play_sound(LRFSound sound, bool applyPersonality=true);
void lrf_speech_play_sound_and_block(LRFSound sound, bool applyPersonality=true);
void lrf_speech_process(void);
void lrf_speech_reset(void);

//-------------------------------------------------------------
#pragma mark - External Variables
//-------------------------------------------------------------

extern LRFSpeech	lrfSpeech;


#endif