//
//  LRFSensors.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 1/16/2014.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFSensors_h
#define __LRFSensors_h

#include <Arduino.h>

/*
	lrfSensors - Sensor Input Library
 
	lrfSensors.touchState
	lrfSensors.micState
	lrfSensors.lightState
	
	multiple reads of each sensor on a timer, followed by analysis
	to determine what has happened on that sensor
 
 */

// Sensor
#define LRF_SENSORS_DEBUG				0
#define LRF_SENSOR_SAMPLE_COUNT			8
#define LRF_SENSOR_HISTORY_COUNT		8
#define LRF_SMOOTHING_BUFFER_COUNT		8

// Touch
#define LRF_TOUCH_ENABLE				1
#define LRF_TOUCH_DEBUG					0
#define LRF_TOUCH_READ_FREQUENCY		20

// Microphone
#define LRF_MIC_ENABLE					1
#define LRF_MIC_DEBUG					0
#define LRF_MIC_DEBUG_VERBOSE			1
#define LRF_MIC_DEBUG_EVENT_BREAK		0
#define LRF_MIC_READ_FREQUENCY			20
#define LRF_MIC_DIFF_THRESHOLD			8
#define LRF_MIC_TIME_THRESHOLD			6

// Light
#define LRF_LIGHT_ENABLE				1
#define LRF_LIGHT_DEBUG					0
#define LRF_LIGHT_DEBUG_VERBOSE			1
#define LRF_LIGHT_READ_FREQUENCY		50
#define LRF_LIGHT_HISTERESYS_SIZE		10
#define LRF_LIGHT_BRIGHT_VALUE			240
#define LRF_LIGHT_DARK_VALUE			35

// States
#define LRF_LIGHT_STATE_NORMAL			1
#define LRF_LIGHT_STATE_DARK			2
#define LRF_LIGHT_STATE_BRIGHT			3
#define LRF_LIGHT_STATE_LONGDARK		4
#define LRF_LIGHT_STATE_UNKNOWN			0

#define LRF_MIC_STATE_NORMAL			0
#define LRF_MIC_STATE_RISING			1
#define LRF_MIC_STATE_FALLING			2




typedef enum
{
	LRFTouchState_Off = 0,
	LRFTouchState_SingleTouch = 1,
	LRFTouchState_DoubleTouch = 2,
	LRFTouchState_MultiTouch = 3,
	LRFTouchState_LongTouch = 4
} __attribute__ ((packed)) LRFTouchState;

typedef enum
{
	LRFMicState_Off = 0,
	LRFMicState_Sound = 1
} __attribute__ ((packed)) LRFMicState;

typedef enum
{
	LRFLightState_Normal = 0,
	LRFLightState_Dark = 1,
	LRFLightState_Bright = 2,
	LRFLightState_NormalToDark = 3,
	LRFLightState_NormalToBright = 4,
	LRFLightState_DarkToNormal = 5,
	LRFLightState_DarkToBright = 6,
	LRFLightState_BrightToNormal = 7,
	LRFLightState_BrightToDark = 8
} __attribute__ ((packed)) LRFLightState;


typedef struct
{
	unsigned char		value;
	unsigned int		timestamp;		// middle two bytes of millis()
} __attribute__ ((packed)) LRFSensorSample;

typedef struct
{
	unsigned char		ready:1;
	unsigned char		idx:7;
	unsigned char		buffer[LRF_SMOOTHING_BUFFER_COUNT];
} __attribute__ ((packed)) LRFSensorBuffer;

typedef struct
{
	unsigned char		idx;
	unsigned char		value;
	unsigned int		timestamp;
	LRFSensorSample		*last;
	LRFSensorSample		samples[LRF_SENSOR_SAMPLE_COUNT];
	bool				evaluate;
	bool				ready;
	bool				calibrated;
	unsigned long		nextReadTime;
} __attribute__ ((packed)) LRFSensorStruct;

typedef struct
{
	bool				enabled;
	unsigned int		enableTimer;
	LRFSensorStruct		touch;
	LRFSensorStruct		mic;
	LRFSensorStruct		light;
} LRFSensors;

extern LRFSensors lrfSensors;


void lrf_sensors_setup(void);
void lrf_sensors_process(void);
void lrf_sensors_enable(void);
void lrf_sensors_disable(void);
void lrf_sensors_recalibrate(void);

void lrf_touch_debug(void);
void lrf_light_debug(void);
void lrf_mic_debug(void);

#endif