//
//  LRFGames.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-19.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include <avr/pgmspace.h>
#include "LRFGames.h"
#include "LRFHardware.h"
#include "LRFExpressions.h"
#include "LRFSpeech.h"
#include "LRFEyes.h"
#include "LRFDebug.h"
#include "LRFSongData.h"




#if LRF_GAMES_DEBUG
const char debug_title[] = "game";
#endif

//======================================================================
void lrf_games_songtime(void)
//======================================================================
{
#if LRF_GAMES_DEBUG
	lrf_debug_tag(debug_title, "song");
#endif
	
	delay(500);
	
	// let's begin by playing our song!
	lrf_expressions_sing(0,8);
	
	// let's play!!
	unsigned char touch = 0;
	unsigned char i=8;
	unsigned int timer;
	unsigned char prompts = 0;

	while(true)
	{
		// reload timer
		timer = 3000;
		
		// wait for touch
		while(touch == 0 && timer > 0)
		{
			lrf_touch_read(&touch);
			delay(1);
			timer--;
		}

		// check our timer
		if(timer == 0)
		{
			if(prompts < 2)
			{
				if(prompts == 0) lrf_expressions_load_and_block(LRFExpression_Excited);
				else lrf_expressions_load_and_block(LRFExpression_Pout);
				prompts++;
				delay(300);
				continue;
			}
			else
			{
				// timed out, let's go
#if LRF_GAMES_DEBUG
				lrf_debug_tag(debug_title, "done");
#endif
				lrf_expressions_load_and_block(LRFExpression_Sob);
				break;
			}
		}
		
		// reload timer
		timer = 3000;
		
		// wait for touch off
		while(touch == 1 && timer > 0)
		{
			lrf_touch_read(&touch);
			delay(1);
			timer--;
		}
		
		// check our timer (again)
		if(timer == 0)
		{
#if LRF_GAMES_DEBUG
			lrf_debug_tag(debug_title, "err");
#endif
			lrf_expressions_load_and_block(LRFExpression_Annoyed);
			break;
		}
				
		// sing our note!
		lrf_expressions_sing(i,i+1);
		prompts = 0;
		i = (i+1) % LRF_SONG_SIZE;
	}

	lrf_events_update_interaction();
}


