//
//  LRFEyes.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 1/14/2014.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFEyes_h
#define __LRFEyes_h

#include <Arduino.h>
#include "LRFUtils.h"

//-------------------------------------------------------------
#pragma mark - Defines
//-------------------------------------------------------------

#define LRF_EYES_DEBUG					0
#define LRF_EYES_DEBUG_VERBOSE			0

#define LRF_EYES_COLOR_COUNT			16
#define LRF_EYES_DURATION_SCALER		10


//-------------------------------------------------------------
#pragma mark - Types
//-------------------------------------------------------------

typedef enum
{
	LRFEyesState_Idle = 0,
	LRFEyesState_Ready,
	LRFEyesState_Running,
	LRFEyesState_Toggling,
	LRFEyesState_Done = 255
} __attribute__ ((packed)) LRFEyesState;

typedef struct
{
	LRFEyesState			state;
	LRFPatternStruct		pattern;
	
	LRFColorValue			currentLeft;
	LRFColorValue			currentRight;
	LRFColorValue			startingLeft;
	LRFColorValue			startingRight;
	LRFColorValue			targetLeft;
	LRFColorValue			targetRight;
	
	unsigned long			startTime;
	unsigned int			duration;
} LRFEyes;


//-------------------------------------------------------------
#pragma mark - Public Functions
//-------------------------------------------------------------

void lrf_eyes_play_pattern(LRFPattern pattern, bool applyPersonality=true);
void lrf_eyes_play_pattern_and_block(LRFPattern pattern, bool applyPersonality=true);
void lrf_eyes_play_pattern_duration_and_block(LRFPattern pattern, unsigned int duration, bool applyPersonality=true);
void lrf_eyes_set_color(LRFColor color);
void lrf_eyes_set_colors(LRFColor left, LRFColor right);
void lrf_eyes_process(void);
void lrf_eyes_reset(void);
void lrf_eyes_reset_pattern(void);
void lrf_eyes_fadeout(void);
void lrf_eyes_update(void);

//-------------------------------------------------------------
#pragma mark - External Variables
//-------------------------------------------------------------

extern LRFEyes				lrfEyes;



#endif