//
//  LRFExpressionData.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-01.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFExpressionData_h
#define __LRFExpressionData_h

#include "LRFUtils.h"

#define LRF_EXPRESSIONS_MAX_EXPRESSIONS		26
#define LRF_EXPRESSIONS_SOUND_COUNT			4

typedef enum
{
	// Hellos (3)
	LRFExpression_Hello = 0,
	LRFExpression_HappyHello,
	LRFExpression_AngryHello,
	
	// Moods (8)
	LRFExpression_Happy,
	LRFExpression_VeryHappy,
	LRFExpression_Excited,
	LRFExpression_VeryExcited,
	LRFExpression_Annoyed,
	LRFExpression_VeryAnnoyed,
	LRFExpression_Angry,
	LRFExpression_VeryAngry,
	
	// Laughs (4)
	LRFExpression_Giggle,
	LRFExpression_Laugh,
	LRFExpression_Hysterical,
	LRFExpression_Cackle,

	// Cries (2)
	LRFExpression_Pout,
	LRFExpression_Sob,

	// Scared (3)
	LRFExpression_Scared,
	LRFExpression_Terrified,
	LRFExpression_Relieved,

	// Sleepy (3)
	LRFExpression_Bored,
	LRFExpression_Yawn,
	LRFExpression_Snoring,
	
	// System (3)
	LRFExpression_Hungry,
	LRFExpression_PowerUp,
	LRFExpression_Alarm,

	// Special (2 - don't count these)
	LRFExpression_Custom=0xfd,
	LRFExpression_Signature=0xfe,
	LRFExpression_None=0xff
	
} __attribute__ ((packed)) LRFExpression;

extern LRFPatternStruct PROGMEM lrfExpressionPatterns[LRF_EXPRESSIONS_MAX_EXPRESSIONS];
extern LRFSoundStruct	PROGMEM lrfExpressionSounds[LRF_EXPRESSIONS_MAX_EXPRESSIONS * LRF_EXPRESSIONS_SOUND_COUNT];

#endif