//
//  LRFExpressionData.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-01.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include "LRFExpressionData.h"

LRFPatternStruct PROGMEM lrfExpressionPatterns[LRF_EXPRESSIONS_MAX_EXPRESSIONS] =
{
	{ LRFColor_Green,		LRFColor_SoftGreen,		LRFPatternMode_Fade },				// Hello
	{ LRFColor_Green,		LRFColor_Yellow,		LRFPatternMode_Fade },				// HappyHello
	{ LRFColor_Red,			LRFColor_Green,			LRFPatternMode_Fade },				// AngryHello

	{ LRFColor_Green,		LRFColor_Yellow,		LRFPatternMode_Boomerang },			// Happy
	{ LRFColor_Green,		LRFColor_Pink,			LRFPatternMode_Boomerang },			// VeryHappy
	{ LRFColor_Yellow,		LRFColor_Orange,		LRFPatternMode_FadeToggle },		// Excited
	{ LRFColor_Yellow,		LRFColor_Pink,			LRFPatternMode_FadeToggle },		// VeryExcited
	{ LRFColor_Red,			LRFColor_SoftRed,		LRFPatternMode_FadeToggle },		// Annoyed
	{ LRFColor_Red,			LRFColor_SoftYellow,	LRFPatternMode_FadeToggle },		// VeryAnnoyed
	{ LRFColor_Red,			LRFColor_SoftRed,		LRFPatternMode_BoomerangToggle },	// Angry
	{ LRFColor_Red,			LRFColor_SoftYellow,	LRFPatternMode_BoomerangToggle },	// VeryAngry
	
	{ LRFColor_Orange,		LRFColor_SoftYellow,	LRFPatternMode_Fade },				// Giggle
	{ LRFColor_Orange,		LRFColor_Green,			LRFPatternMode_Boomerang },			// Laugh
	{ LRFColor_Orange,		LRFColor_SoftPink,		LRFPatternMode_BoomerangToggle },	// Hysterical
	{ LRFColor_Orange,		LRFColor_Red,			LRFPatternMode_Boomerang },			// Cackle
	
	{ LRFColor_Cyan,		LRFColor_SoftCyan,		LRFPatternMode_FadeFlip },			// Pout
	{ LRFColor_Cyan,		LRFColor_Blank,			LRFPatternMode_Fade },				// Sob
	
	{ LRFColor_Purple,		LRFColor_Red,			LRFPatternMode_Boomerang },			// Scared
	{ LRFColor_Purple,		LRFColor_Red,			LRFPatternMode_BoomerangToggle },	// Terrified
	{ LRFColor_Purple,		LRFColor_Green,			LRFPatternMode_Fade },				// Relieved
	
	{ LRFColor_Blue,		LRFColor_Cyan,			LRFPatternMode_FlatFlip },			// Bored
	{ LRFColor_Blue,		LRFColor_Blank,			LRFPatternMode_Fade },				// Yawn
	{ LRFColor_Blank,		LRFColor_Blue,			LRFPatternMode_Boomerang },			// Snoring
	
	{ LRFColor_Red,			LRFColor_Blank,			LRFPatternMode_FlatFlipToggle },	// Hungry
	{ LRFColor_Blank,		LRFColor_Blank,			LRFPatternMode_RandomFlat },		// PowerUp
	{ LRFColor_Green,		LRFColor_Blank,			LRFPatternMode_FlatFlipToggle }		// Alarm
};

LRFSoundStruct PROGMEM lrfExpressionSounds[LRF_EXPRESSIONS_MAX_EXPRESSIONS * LRF_EXPRESSIONS_SOUND_COUNT] =
{
	// Hello
	{ LRFNote_E, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_Short },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
	
	// HappyHello
	{ LRFNote_E, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_CS, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_None },
	
	// AngryHello
	{ LRFNote_E, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_None },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
	
	// Happy
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
		
	// VeryHappy (NEEDS REVISION!!!)
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
    LRFSoundStruct_Blank,
	
	// Excited
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_DoubleShort },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_DoubleShort },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_None },
    LRFSoundStruct_Blank,
	
	// Very Excited
	{ LRFNote_FS, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_FS, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_FS, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_DoubleShort },
    { LRFNote_FS, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_Long, LRFDuration_None },
	
	// Annoyed
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_DoubleMedium },
	{ LRFNote_G, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
	{ LRFNote_GS, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
    LRFSoundStruct_Blank,
	
	// VeryAnnoyed
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Long, LRFDuration_Short },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_DoubleMedium },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_None },
	
	// Angry
	{ LRFNote_A, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_None },
    { LRFNote_A, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_None },
    { LRFNote_A, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_None },
    LRFSoundStruct_Blank,
	
	// VeryAngry
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_DoubleLong, LRFDuration_None },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_DoubleLong, LRFDuration_None },
    { LRFNote_A, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_DoubleLong, LRFDuration_None },
    { LRFNote_A, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_None },
	
	// Giggle (NEEDS REVISION!!!)
	{ LRFNote_GS, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_G, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Laugh
	{ LRFNote_GS, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_G, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Hysterical
	{ LRFNote_E, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_DoubleMedium, LRFDuration_Short },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Cackle (NEEDS REVISION!!!)
	{ LRFNote_CS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_DoubleShort },
    { LRFNote_DS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_DoubleShort, LRFDuration_None },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_CS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	
	// Pout
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_None },

	// Sob
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Dipping, LRFDuration_Long, LRFDuration_Medium },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Scared!
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_DoubleMedium, LRFDuration_None },
    { LRFNote_F, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_DoubleMedium, LRFDuration_DoubleMedium },
    { LRFNote_G, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
    { LRFNote_G, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
	
	// Freakout!
	{ LRFNote_D, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Short },
    { LRFNote_B, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Short },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Long, LRFDuration_Short },
    { LRFNote_D, LRFOctave_4, LRFIntonation_Peaking, LRFDuration_DoubleLong, LRFDuration_None },
	
	// Relieved
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_None },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
	
	// Bored
	{ LRFNote_C, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
    { LRFNote_A, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
	
	// Yawn!
	{ LRFNote_B, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_DoubleMedium },
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
    LRFSoundStruct_Blank,
	
	// Snoring
	{ LRFNote_C, LRFOctave_1, LRFIntonation_Peaking, LRFDuration_VeryLong, LRFDuration_Long },
	{ LRFNote_C, LRFOctave_1, LRFIntonation_Peaking, LRFDuration_VeryLong, LRFDuration_Long },
	{ LRFNote_C, LRFOctave_1, LRFIntonation_Peaking, LRFDuration_VeryLong, LRFDuration_Long },
    LRFSoundStruct_Blank,
	
	// Hungry
	{ LRFNote_C, LRFOctave_7, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_7, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_7, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_7, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	
	// PowerUp
	{ LRFNote_C, LRFOctave_3, LRFIntonation_Falling, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_E, LRFOctave_3, LRFIntonation_Flat, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_G, LRFOctave_3, LRFIntonation_Rising, LRFDuration_DoubleShort, LRFDuration_Short },
    { LRFNote_C, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },

	// Alarm
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Medium }
	
};
