//
//  LRFEvents.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-14.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFEvents_h
#define __LRFEvents_h

#include <Arduino.h>
#include "LRFEventHandlers.h"

/*
 
 Event Types describe a moment of realization.
 It's not a state. It's a recognition that a state has changed.
 Time to react!
 
 */

#define LRF_EVENTS_DEBUG			0
#define LRF_EVENTS_DEBUG_VERBOSE	0

#define LRF_EVENTS_HISTORY_SIZE		4
#define LRF_EVENTS_QUEUE_SIZE		4

#define LRF_BORED_DISABLE					0
#define LRF_BORED_TIME_SECONDS				30
#define LRF_BORED_TIME						LRF_BORED_TIME_SECONDS * 1000
#define LRF_BORED_TO_SLEEP_COUNT			3

#define LRF_BORED_EVENT_ADD_FILTER			0

typedef struct
{
	bool				enabled;
	LRFEvent			eventHistory[LRF_EVENTS_HISTORY_SIZE];
	LRFEvent			eventQueue[LRF_EVENTS_QUEUE_SIZE];
	unsigned char		eventQueueCount;
	unsigned long		lastInteractionTime;
	unsigned long		boredTimeout;
	unsigned char		boredCount;
	unsigned long		boredTimeoutReload;
	unsigned char		boredCountReload;
} LRFEvents;

void lrf_events_setup(void);
void lrf_events_process(void);

void lrf_events_enable(void);
void lrf_events_disable(void);

void lrf_events_update_interaction(void);

void lrf_events_add(LRFEvent event);
void lrf_events_force(LRFEvent event);

unsigned char lrf_events_history_count(LRFEvent event);
unsigned char lrf_events_history_continuous(LRFEvent event);

extern LRFEvents lrfEvents;

#endif
