//
//  LRFMemory.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-20.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

/*
 
 EEPROM Memory Map
 -----------------
 
 0x00	Hardware Version - Major
 0x01	Hardware Version - Minor
 0x02	Firmware Version - Major
 0x03	Firmware Version - Minor
 0x04	Reserved (Serial No.)
 0x05	Reserved (Serial No.)
 0x06	Reserved (Serial No.)
 0x07	Reserved (Serial No.)
 0x08	Test - Has Passed HW Test
 0x09	Test - Has Read Shoelaces
 0x0A	Personality - Bravery
 0x0B	Personality - Happiness
 0x0C	Personality - Enthusiasm
 0x0D	Personality - Neediness
 0x0E	Personality - Chattiness
 0x0F	Personality - Humour
 0x10	Signature Sound

 0x11	Reserved
 ....	[ 47 bytes ]
 0x3F	Reserved
 
 0x40	Event History - Start of block
 ....	[ 64 bytes ]
 0x7f	Event History - End of block
 
 
 
 0x00-0x09	[10] - Reserved
 0x0a-0x0f	[06] - Original Personality Profile
 0x10-0x3f	[48] - Reserved
 0x40-0x7f	[64] - Event History (this will need to include timestamping)
 
 Needs Assignment:
 
 - firmware major/minor
 - hardware major/minor
 - test flag
 - first time launch flag
 - mood
 - mood history?
 - modified personality profile?
 -
 
 */

#ifndef __LRFMemory_h
#define __LRFMemory_h

#include <Arduino.h>
#include <avr/eeprom.h>

#define LRF_MEMORY_DEBUG							0
#define LRF_MEMORY_DEBUG_VERBOSE					0

#define LRF_MEMORY_HARDWARE_VERSION_MAJOR_ADDR		0x00
#define LRF_MEMORY_HARDWARE_VERSION_MINOR_ADDR		0x01

#define LRF_MEMORY_FIRMWARE_VERSION_MAJOR_ADDR		0x02
#define LRF_MEMORY_FIRMWARE_VERSION_MINOR_ADDR		0x03

#define LRF_MEMORY_SERIAL_START_ADDR				0x04
#define LRF_MEMORY_SERIAL_END_ADDR					0x07
#define LRF_MEMORY_SERIAL_LENGTH					4

#define LRF_MEMORY_HARDWARE_TEST_ADDR				0x08
#define LRF_MEMORY_HARDWARE_TEST_VALUE				0x99	// gretzky

#define LRF_MEMORY_HAS_READ_SHOELACES_ADDR			0x09
#define LRF_MEMORY_HAS_READ_SHOELACES_VALUE			0x17	// gruber

#define LRF_MEMORY_PERSONALITY_START_ADDR			0x0a
#define LRF_MEMORY_PERSONALITY_END_ADDR				0x0f
#define LRF_MEMORY_PERSONALITY_LENGTH				6

#define LRF_MEMORY_SIGNATURE_ADDR					0x10

#define LRF_MEMORY_EVENT_HISTORY_START_ADDR			0x40
#define LRF_MEMORY_EVENT_HISTORY_END_ADDR			0x4f
#define LRF_MEMORY_EVENT_HISTORY_LENGTH				16





void lrf_memory_load(void);
void lrf_memory_save(void);
void lrf_memory_save_personality(void);
void lrf_memory_save_event_history(void);

inline unsigned char lrf_memory_read(unsigned char address)
{
	return eeprom_read_byte((const uint8_t *)address);
}

inline void lrf_memory_write(unsigned char address, unsigned char data)
{
	eeprom_write_byte((uint8_t *)address,(uint8_t)data);
}


#endif
