//
//  LRFEventHandlers.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-14.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include "LRFEventHandlers.h"
#include "LRFExpressions.h"
#include "LRFEvents.h"
#include "LRFInfrared.h"
#include "LRFHardware.h"
#include "LRFPower.h"
#include "LRFPersonality.h"
#include "LRFGames.h"

#if LRF_EVENT_HANDLERS_DEBUG
#include "LRFDebug.h"
const char debug_title[] = "eh";
#endif

void lrf_event_tap(void);
void lrf_event_tickle(void);
void lrf_event_hug(void);

void lrf_event_lightsOff(void);
void lrf_event_lightsOn(void);
void lrf_event_lightsBright(void);
void lrf_event_lightsLongDark(void);

void lrf_event_heardLoudNoise(void);

void lrf_event_isHungry(void);
void lrf_event_isBored(void);

void lrf_event_messageReceived(void);
void lrf_event_messageFailed(void);

void lrf_event_moodChanged(void);

void lrf_event_sleep(void);
void lrf_event_wake(void);
void lrf_event_powerUp(void);


LRFEventHandler lrfEventHandlers[16] =
{
	&lrf_event_tap,
	&lrf_event_tickle,
	&lrf_event_hug,
	&lrf_event_lightsOff,
	&lrf_event_lightsOn,
	&lrf_event_lightsBright,
	&lrf_event_lightsLongDark,
	&lrf_event_heardLoudNoise,
	&lrf_event_messageReceived,
	&lrf_event_messageFailed,
	&lrf_event_isHungry,
	&lrf_event_isBored,
	&lrf_event_sleep,
	&lrf_event_wake,
	&lrf_event_powerUp,
	&lrf_event_moodChanged
};

#define LRF_EVENTS_FEW_IN_A_ROW				3
#define LRF_EVENTS_COUPLE_IN_A_ROW			2


//======================================================================
void lrf_event_tap(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "tap");
#endif
	
	// have we tapped in recent history?
	if(lrf_events_history_continuous(LRFEvent_Tap) > 0)
	{
		// say hello
		lrf_expressions_load(LRFExpression_Hello);
	}
	else
	{
		// say signature expression
		lrf_expressions_load(LRFExpression_Signature);
	}

	if(lrfPersonality.happiness > LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrfExpressions.next = LRFExpression_Excited;
	}
	else if(lrfPersonality.happiness < LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrfExpressions.next = LRFExpression_Angry;
	}
	
	// queue up IR message & set our callback to write it
	lrf_irda_queue_message(LRFIRMessage_Hello);
	lrfExpressions.callback = &lrf_irda_write_queued_message;
}

//======================================================================
void lrf_event_tickle(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "tickle");
#endif
	

	if(lrf_events_history_continuous(LRFEvent_Tickle) >= 2)
	{
		lrf_games_songtime();
	}
	else
	{
		if(lrfPersonality.humour > LRF_PERSONALITY_LEVEL_NORMAL)
		{
			lrf_expressions_load(LRFExpression_Hysterical);
		}
		else if(lrfPersonality.humour < LRF_PERSONALITY_LEVEL_NORMAL)
		{
			lrf_expressions_load(LRFExpression_Annoyed);
		}
		else
		{
			lrf_expressions_load(LRFExpression_Laugh);
		}
		
		// queue up IR message & connect callback
		lrf_irda_queue_message(LRFIRMessage_LetsSing);
		lrfExpressions.callback = &lrf_irda_write_queued_message;
	}
}

//======================================================================
void lrf_event_hug(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "hug");
#endif

	if(lrfPersonality.happiness > LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_VeryExcited);
	}
	else if(lrfPersonality.happiness < LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_VeryAnnoyed);
	}
	else
	{
		lrf_expressions_load(LRFExpression_HappyHello);
	}
	
	// queue up IR message & connect callback
	lrf_irda_queue_message(LRFIRMessage_LetsChat);
	lrfExpressions.callback = &lrf_irda_write_queued_message;
}

//======================================================================
void lrf_event_lightsOff(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "lightsOff");
#endif

	// if brave... make a brave sound? laugh? scoff?
	if(lrfPersonality.bravery == LRF_PERSONALITY_LEVEL_HIGH)
	{
		lrf_expressions_load(LRFExpression_Laugh);
	}
	else if(lrfPersonality.bravery == LRF_PERSONALITY_LEVEL_LOW)
	{
		lrf_expressions_load(LRFExpression_Terrified);
	}
	else if(lrfPersonality.bravery <= LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_Scared);
	}
	else
	{
		lrf_expressions_load(LRFExpression_Annoyed);
	}
}

//======================================================================
void lrf_event_lightsOn(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "lightsOn");
#endif

	// if brave... make a brave sound? laugh? scoff?
	if(lrfPersonality.bravery > LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_Pout);
	}
	else if(lrfPersonality.bravery <= LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_Relieved);
	}
}

//======================================================================
void lrf_event_lightsBright(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "lightsBright");
#endif

	// if brave... make a brave sound? laugh? scoff?
	if(lrfPersonality.bravery >= LRF_PERSONALITY_LEVEL_NORMAL)
	{
		lrf_expressions_load(LRFExpression_Annoyed);
	}
	else if(lrfPersonality.bravery == LRF_PERSONALITY_LEVEL_LOW)
	{
		lrf_expressions_load(LRFExpression_Terrified);
	}
	else
	{
		lrf_expressions_load(LRFExpression_Scared);
	}
}

//======================================================================
void lrf_event_lightsLongDark(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "lightsLongDark");
#endif
	
	lrf_expressions_load(LRFExpression_Snoring, &lrf_power_sleep);
}

//======================================================================
void lrf_event_heardLoudNoise(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "loudNoise");
#endif

	lrf_expressions_chatter();
}

//======================================================================
void lrf_event_isHungry(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "isHungry");
#endif

	// and we will also say we're hungry
	lrf_expressions_load(LRFExpression_Hungry);
}

//======================================================================
void lrf_event_isBored(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "isBored");
#endif

	if(lrfEvents.boredCount > 1)
	{
		lrf_expressions_load(LRFExpression_Yawn);
	}
	else
	{
		lrf_expressions_load(LRFExpression_Bored);
	}
}

//======================================================================
void lrf_event_messageReceived(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "msgRecv");
#endif

	// handle our messages
	if(lrfIrda.message == LRFIRMessage_Hello)
	{
		lrf_expressions_load(LRFExpression_Hello, &lrf_irda_write_queued_message);
		lrfExpressions.next = LRFExpression_Signature;
		lrf_irda_queue_message(LRFIRMessage_LetsChat);
	}
	else if(lrfIrda.message == LRFIRMessage_LetsChat)
	{
		lrf_irda_queue_message(LRFIRMessage_LetsChat);
		lrfExpressions.callback = &lrf_irda_write_queued_message;
		lrf_expressions_chatter();
	}
	else if(lrfIrda.message == LRFIRMessage_LetsSing)
	{
		lrf_irda_write_message(LRFIRMessage_LetsSing);
		delay(20);
		lrf_irda_write_message(LRFIRMessage_LetsSing);
		lrf_expressions_sing();
	}
	else if(lrfIrda.message == LRFIRMessage_LeaveMeAlone)
	{
		
	}

	// reset our ir reading
	lrf_irda_reset_read();
}

//======================================================================
void lrf_event_sleep(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "sleep");
#endif

	// load sleep callback
	lrf_expressions_load(LRFExpression_Snoring, &lrf_power_sleep);
}

//======================================================================
void lrf_event_wake(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "wake");
#endif

	// yawn to wake up
	lrf_expressions_load(LRFExpression_Yawn);
	lrfExpressions.next = LRFExpression_Signature;
}

//======================================================================
void lrf_event_powerUp(void)
//======================================================================
{
#if LRF_EVENT_HANDLERS_DEBUG
	lrf_debug_tag(debug_title, "powerUp");
#endif

	// power up sound (generic for all)
	lrf_expressions_load(LRFExpression_PowerUp);
}




//------------------------------------------------------------
#pragma mark - Depricated
//------------------------------------------------------------

//======================================================================
void lrf_event_messageFailed(void)
//======================================================================
{
	//#if LRF_EVENT_HANDLERS_DEBUG
	//	lrf_debug_tag(debug_title, "msgFail");
	//#endif
	//
	//	lrfIrda.hasMessage = false;	// clear flag since we've read the message
	//	lrf_irda_read_enable();		// re-enable irda interrupt
}


//======================================================================
void lrf_event_moodChanged(void)
//======================================================================
{
//#if LRF_EVENT_HANDLERS_DEBUG
//	lrf_debug_tag(debug_title, "moodCh");
//#endif
}
