//
//  LRFDebug.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-28.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFDebug_h
#define __LRFDebug_h

#include "LRF.h"

void lrf_debug_tag(const char *title, const char *tag, bool newline=true);
void lrf_debug_pair(unsigned char a, unsigned char b, bool newline=true);
void lrf_debug_list(const char *tag, unsigned char *list, unsigned char len, bool newline=true);
void lrf_debug_stall(void);

#if LRF_DEBUG_CONSOLE_ENABLED
void lrf_debug_console(void);
#endif

/*
 
 LittleRobotFriend lrf;
 
 LRFPatternStruct myPattern = { 1, 2, 3, 4};
 LRFSoundStruct mySound = { 1, 2, 3, 4 };
 LRFSoundStruct mySounds[3] = {
 { 1, 2, 3, 4 },
 { 1, 2, 3, 4 },
 { 1, 2, 3, 4 },
 };
 
 lrf.blink(myPattern);
 
 lrf.say(mySound);
 lrf.say(mySounds, 3);
 
 lrf.express(myPattern, mySound);
 lrf.express(myPattern, mySounds, 3);
 
 lrf.play();
 
 lrf.eyes.set(color, duration);
 lrf.speech.set(frequency, duration);
 
 lrf.sensors.touch;
 lrf.sensors.light;
 lrf.sensors.mic;
 
 lrf.sensors.touchState;
 lrf.sensors.lightState;
 lrf.sensors.micState;
 
 lrf.sleep();
 
 lrf.personality.bravery;
 lrf.personality.humour;
 
 
 */
#endif