//
//  LRFSignatureData.cpp
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-05-02.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#include "LRFSignatureData.h"

LRFPatternStruct PROGMEM lrfSignaturePatterns[LRF_SIGNATURE_MAX] =
{
	{ LRFColor_Green,		LRFColor_Blank,		LRFPatternMode_Fade },				// normal
	{ LRFColor_Yellow,		LRFColor_Orange,	LRFPatternMode_BoomerangToggle },	// chatter
	{ LRFColor_Pink,		LRFColor_SoftPink,	LRFPatternMode_Fade },				// diva
	{ LRFColor_Blue,		LRFColor_Green,		LRFPatternMode_Fade },				// plato
	{ LRFColor_Red,			LRFColor_Orange,	LRFPatternMode_FlatFlip },			// rascal
	{ LRFColor_Green,		LRFColor_Orange,	LRFPatternMode_FlatFlip },			// nanna
	{ LRFColor_Blank,		LRFColor_Blank,		LRFPatternMode_RandomToggle },		// office
	{ LRFColor_Blank,		LRFColor_Blank,		LRFPatternMode_RandomBoomerang },	// party
	{ LRFColor_Cyan,		LRFColor_Purple,	LRFPatternMode_Fade },				// scaredy
	{ LRFColor_Green,		LRFColor_Orange,	LRFPatternMode_FlatFlipToggle },	// jolly
	{ LRFColor_Red,			LRFColor_Orange,	LRFPatternMode_Boomerang }			// evil
};

LRFSoundStruct PROGMEM lrfSignatureSounds[LRF_SIGNATURE_MAX * LRF_SIGNATURE_SOUND_COUNT] =
{
	// Normal
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_Short },
	{ LRFNote_C, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	{ LRFNote_GS, LRFOctave_4, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_Short },
	{ LRFNote_F, LRFOctave_4, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Chatterbot .... more chatty
	{ LRFNote_C, LRFOctave_5, LRFIntonation_Peaking, LRFDuration_Medium, LRFDuration_DoubleShort },
	{ LRFNote_G, LRFOctave_5, LRFIntonation_Peaking, LRFDuration_Medium, LRFDuration_DoubleShort },
	{ LRFNote_E, LRFOctave_5, LRFIntonation_Peaking, LRFDuration_Medium, LRFDuration_DoubleShort },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Peaking, LRFDuration_DoubleMedium, LRFDuration_None },
	
	// Divabot .... mmmm hrrrmmmm
	{ LRFNote_C, LRFOctave_4, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_DoubleShort },
	{ LRFNote_E, LRFOctave_3, LRFIntonation_Rising, LRFDuration_Long, LRFDuration_DoubleShort },
	{ LRFNote_E, LRFOctave_6, LRFIntonation_Falling, LRFDuration_Long, LRFDuration_DoubleShort },
    LRFSoundStruct_Blank,
	
	// Platobot
	{ LRFNote_G, LRFOctave_3, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_Long },
	{ LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	{ LRFNote_G, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
    LRFSoundStruct_Blank,
	
	// Rascalbot
	{ LRFNote_G, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_None },
	{ LRFNote_D, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_DoubleMedium },
	{ LRFNote_C, LRFOctave_2, LRFIntonation_Flat, LRFDuration_Short, LRFDuration_Short },
	{ LRFNote_C, LRFOctave_2, LRFIntonation_Flat, LRFDuration_Short, LRFDuration_None },
	
	// Nannabot
	{ LRFNote_C, LRFOctave_5, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Short },
	{ LRFNote_D, LRFOctave_5, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Short },
	{ LRFNote_E, LRFOctave_5, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_Short },
	{ LRFNote_C, LRFOctave_5, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
	
	// Officebot (needs revision) gadgety tech sound
	{ LRFNote_F, LRFOctave_7, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	{ LRFNote_F, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	{ LRFNote_C, LRFOctave_1, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None },
	//	{ LRFNote_F, LRFOctave_7, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_None },
	//	{ LRFNote_C, LRFOctave_6, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_None },
	//	{ LRFNote_F, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
	//	{ LRFNote_C, LRFOctave_1, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_None },
	
	// Partybot
	{ LRFNote_F, LRFOctave_5, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_F, LRFOctave_5, LRFIntonation_Rising, LRFDuration_DoubleMedium, LRFDuration_Long },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_DoubleShort },
	{ LRFNote_C, LRFOctave_6, LRFIntonation_Rising, LRFDuration_Medium, LRFDuration_None },
	
	// Scaredybot (fritzing!!) high pitched squeal
	{ LRFNote_G, LRFOctave_6, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_G, LRFOctave_5, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_G, LRFOctave_4, LRFIntonation_Falling, LRFDuration_DoubleMedium, LRFDuration_Medium },
	{ LRFNote_G, LRFOctave_3, LRFIntonation_Falling, LRFDuration_Long, LRFDuration_None },
	//	{ LRFNote_G, LRFOctave_4, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Medium },
	//	{ LRFNote_C, LRFOctave_2, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_Short },
	//	{ LRFNote_C, LRFOctave_2, LRFIntonation_Falling, LRFDuration_Medium, LRFDuration_None },
	
	// Jollybot
	{ LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
	{ LRFNote_G, LRFOctave_2, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
	{ LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_Medium },
	{ LRFNote_G, LRFOctave_2, LRFIntonation_Flat, LRFDuration_Long, LRFDuration_None },
	
	// Evilbot
	{ LRFNote_CS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_DoubleMedium, LRFDuration_DoubleShort },
    { LRFNote_DS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_DoubleShort, LRFDuration_None },
    { LRFNote_E, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_Short },
    { LRFNote_CS, LRFOctave_4, LRFIntonation_Flat, LRFDuration_Medium, LRFDuration_None }
};