//
//  LRFPower.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-14.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

/*
 
 Alkaline Battery Voltage: 1.5V
 Rechargable Battery Voltage: 1.2V
 'Hungry' Trigger Voltage: 0.9V
 Starving Voltage: 0.8V (stops working)
 
 Power Consumption @ 1.5V:
 ------------------
 .005A - sleep
 .500A - max
 .015A - normal
 
 _-_-_-_-_-_ SLEEP MODE _-_-_-_-_-_
 
 normal rechargeable = 1150mAh
 x 2 = 2300mAh
 2300mAh / 5mA = 460h = 19d (~ 3 weeks)
 
 heavy rechargeable = 2300mAh
 x 2 = 4600mAh
 4600mAh / 5mA = 920h = 38d (~ 6 weeks)
 
 _-_-_-_-_-_ NORMAL MODE _-_-_-_-_-_
 
 normal rechargeable = 1150mAh
 x 2 = 2300mAh
 2300mAh / 15mA = 150h = 6d
 
 heavy rechargeable = 2300mAh
 x 2 = 4600mAh
 4600mAh / 15mA = 300h = 12d
 
 */

#ifndef __LRFPower_h
#define __LRFPower_h


#define LRF_POWER_DEBUG				0

void lrf_power_setup(void);
void lrf_power_process(void);

bool lrf_power_fuel_check(void);

void lrf_power_sleep(void);
void lrf_power_wake(void);

typedef struct
{
	bool isHungry;
	bool isSleeping;
	unsigned long nextFuelCheck;
} LRFPower;

volatile extern LRFPower lrfPower;

#endif