//
//  LRFPersonality.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-01.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/

#ifndef __LRFPersonality_h
#define __LRFPersonality_h

#include <Arduino.h>

#define LRF_PERSONALITY_DEBUG			0
#define LRF_PERSONALITY_DEBUG_VERBOSE	0

#define LRF_PERSONALITY_LEVEL_HIGH		5
#define LRF_PERSONALITY_LEVEL_NORMAL	3
#define LRF_PERSONALITY_LEVEL_LOW		1

#define LRF_PERSONALITY_SELECTOR_USE_TOUCH		1
//#define LRF_PERSONALITY_SELECTOR_USE_TOUCH		0
#define LRF_PERSONALITY_SHOELACE_CHECK_AUTO		1

#define LRF_PERSONALITY_SELECTION_STARTUP_TOUCH_TIME	8000
#define LRF_PERSONALITY_SELECTION_TOUCH_TIMEOUT			5000

#define LRF_PERSONALITY_PROFILE_COUNT	11

#define LRF_PERSONALITY_NEEDINESS_CHANNEL	0
#define LRF_PERSONALITY_HUMOUR_CHANNEL		1
#define LRF_PERSONALITY_HAPPINESS_CHANNEL	2
#define LRF_PERSONALITY_CHATTINESS_CHANNEL	3
#define LRF_PERSONALITY_ENTHUSIASM_CHANNEL	4
#define LRF_PERSONALITY_BRAVERY_CHANNEL		5


// LRFPersonalityProfile - Enumerated list of pre-set personality profiles
typedef enum
{
	LRFPersonalityProfile_Custom = 0,
	LRFPersonalityProfile_Chatterbot,
	LRFPersonalityProfile_Divabot,
	LRFPersonalityProfile_Platobot,
	LRFPersonalityProfile_Rascalbot,
	LRFPersonalityProfile_Nannabot,
	LRFPersonalityProfile_Officebot,
	LRFPersonalityProfile_Partybot,
	LRFPersonalityProfile_Scaredybot,
	LRFPersonalityProfile_Jollybot,
	LRFPersonalityProfile_Evilbot
} LRFPersonalityProfile;

// LRFPersonalityStruct - Structure data for the personality
typedef struct
{
	unsigned char bravery:4;
	unsigned char happiness:4;
	unsigned char enthusiasm:4;
	unsigned char neediness:4;
	unsigned char chattiness:4;
	unsigned char humour:4;
	
	//	unsigned char brave:4;	// bravery
	//	unsigned char happy:4;	// happiness
	//	unsigned char wild:4;	// enthusiasm
	//	unsigned char intro:4;	// neediness
	//	unsigned char quiet:4;	// chattiness
	//	unsigned char funny:4;	// humour
	
	unsigned char reserved:8;
	
} __attribute__ ((packed)) LRFPersonalityStruct;

// LRFPersonalityData - Unified object for easy access to personality data
typedef union
{
	unsigned long				raw;
	LRFPersonalityStruct		profile;
} LRFPersonalityData;

// LRFPersonality - Local personality object (needs to be ordered as ADCs)
typedef struct
{
	unsigned char neediness;	// affects how quickly robot gets bored
	unsigned char humour;		// affects reaction for tickles & games?
	unsigned char happiness;	// affects reaction for taps & hugs
	unsigned char chattiness;	// affects how talkative the robot is
	unsigned char enthusiasm;	// affects pitch of speech
	unsigned char bravery;		// affects reaction during lightsOff, lightsOn, lightsBright
} LRFPersonality;



extern LRFPersonality lrfPersonality;

void lrf_personality_setup(void);

void lrf_personality_has_read_shoelaces_check(void);
void lrf_personality_read_shoelaces(void);

void lrf_personality_selector(void);
void lrf_personality_select_on_startup(void);

#if LRF_PERSONALITY_DEBUG
void lrf_personality_print(void);
#endif

#endif