//
//  LRFExpressions.h
//  LittleRobotFriends
//
//  Created by Mark Argo on 2014-03-14.
//  Copyright (c) 2014 Aesthetec Studio Inc. All rights reserved.
//

/*
 THIS SOFTWARE IS PROVIDED “AS IS”, WITHOUT ANY REPRESENTATIONS, CONDITIONS, 
 AND/OR WARRANTIES OF ANY KIND.  WITHOUT LIMITATION, AESTHETEC STUDIO AND ITS 
 AFFILIATES, LICENSORS, SUPPLIERS, CONTRIBUTORS, SUBCONTRACTORS, DISTRIBUTORS 
 AND ALL CONTRIBUTORS DISCLAIM ANY EXPRESS OR IMPLIED REPRESENTATIONS, 
 CONDITIONS, OR WARRANTIES OF MERCHANTABILITY, MERCHANTABLE QUALITY, SATISFACTORY 
 QUALITY, NON-INFRINGEMENT, TITLE, DURABILITY, OR FITNESS FOR A PARTICULAR 
 PURPOSE, WHETHER ARISING BY STATUTE, COURSE OF DEALING, USAGE OF TRADE, OR 
 OTHERWISE.  EXCEPT AS OTHERWISE PROVIDED IN THIS AGREEMENT, YOU SHALL BEAR 
 THE ENTIRE RISK FOR ANY USE OR ANY OTHER EXPLOITATION MADE BY YOU OF ANY 
 RIGHTS IN THE COVERED SOFTWARE.
 
 Additional copyright information found at http://littlerobotfriends.com/legal/
*/


#ifndef __LRFExpressions_h
#define __LRFExpressions_h

#include "LRFExpressionData.h"
#include "LRFSignatureData.h"

#define LRF_EXPRESSIONS_DEBUG				0
#define LRF_EXPRESSIONS_CALLBACK_DEBUG		0

#define LRF_EYES_TIMER_RELOAD				15

typedef enum
{
	LRFExpressionState_Idle = 0,
	LRFExpressionState_Ready,
	LRFExpressionState_Running,
	LRFExpressionState_Finishing,
	LRFExpressionState_Done = 0xFF
} __attribute__ ((packed)) LRFExpressionState;

typedef struct
{
	LRFExpressionState			state;
	LRFExpression				current;
	LRFExpression				next;
	LRFFunctionPtr				callback;
	
	unsigned char				signatureIdx;
	
	unsigned char				soundIdx;
	unsigned char				soundCount;
	
	unsigned long				startTime;
	unsigned int				duration;
	
	unsigned char				eyesTimer;

} LRFExpressions;

extern LRFExpressions lrfExpressions;

void lrf_expressions_setup(void);

void lrf_expressions_chatter(void);
void lrf_expressions_sing(unsigned char startIdx=0xff, unsigned char endIdx=0xff);

void lrf_expressions_load(LRFExpression expression, LRFFunctionPtr callback=0);
void lrf_expressions_load_and_block(LRFExpression expression, LRFFunctionPtr callback=0);

void lrf_expressions_load_pattern_and_sounds(LRFPattern pattern, LRFSound *sounds, char soundCount);
void lrf_expressions_load_pattern_and_sounds_and_block(LRFPattern pattern, LRFSound *sounds, char soundCount);

void lrf_expressions_process(LRFSound *sounds=0);
void lrf_expressions_done(void);


#endif