/// <reference path="pxtlib.d.ts" />
/// <reference path="../localtypings/pxtarget.d.ts" />
/// <reference path="../localtypings/pxtpackage.d.ts" />
/// <reference path="typescriptServices.d.ts" />
/// <reference path="../typings/globals/fusejs/index.d.ts" />
declare namespace pxt {
    function simshim(prog: ts.Program): Map<string>;
}
declare namespace ts.pxtc.avr {
    class AVRProcessor extends assembler.AbstractProcessor {
        wordSize(): number;
        computeStackOffset(kind: string, offset: number): number;
        is32bit(i: assembler.Instruction): boolean;
        emit32(op: number, v: number, actual: string): pxtc.assembler.EmitResult;
        registerNo(actual: string): number;
        postProcessRelAddress(f: assembler.File, v: number): number;
        postProcessAbsAddress(f: assembler.File, v: number): number;
        getAddressFromLabel(f: assembler.File, i: assembler.Instruction, s: string, wordAligned?: boolean): number;
        peephole(ln: pxtc.assembler.Line, lnNext: pxtc.assembler.Line, lnNext2: pxtc.assembler.Line): void;
        constructor();
        testAssembler(): void;
    }
}
declare namespace ts.pxtc {
    var decodeBase64: (s: string) => string;
    interface BitSizeInfo {
        size: number;
        needsSignExt?: boolean;
        immLimit: number;
    }
    abstract class AssemblerSnippets {
        nop(): string;
        reg_gets_imm(reg: string, imm: number): string;
        proc_setup(main?: boolean): string;
        push_fixed(reg: string[]): string;
        push_local(reg: string): string;
        push_locals(n: number): string;
        proc_setup_end(): string;
        pop_fixed(reg: string[]): string;
        pop_locals(n: number): string;
        proc_return(): string;
        debugger_stmt(lbl: string): string;
        debugger_bkpt(lbl: string): string;
        debugger_proc(lbl: string): string;
        unconditional_branch(lbl: string): string;
        beq(lbl: string): string;
        bne(lbl: string): string;
        cmp(reg1: string, reg: string): string;
        cmp_zero(reg1: string): string;
        arithmetic(): string;
        load_reg_src_off(reg: string, src: string, off: string, word?: boolean, store?: boolean, inf?: BitSizeInfo): string;
        rt_call(name: string, r0: string, r1: string): string;
        call_lbl(lbl: string): string;
        call_reg(reg: string): string;
        vcall(mapMethod: string, isSet: boolean, vtableShift: number): string;
        prologue_vtable(arg_index: number, vtableShift: number): string;
        lambda_prologue(): string;
        lambda_epilogue(): string;
        load_ptr(lbl: string, reg: string): string;
        load_ptr_full(lbl: string, reg: string): string;
        emit_int(v: number, reg: string): string;
    }
    function numBytes(n: number): number;
    class ProctoAssembler {
        private t;
        private bin;
        private resText;
        private exprStack;
        private calls;
        private proc;
        private baseStackSize;
        constructor(t: AssemblerSnippets, bin: Binary, proc: ir.Procedure);
        private write;
        private stackSize();
        private stackAlignmentNeeded(offset?);
        private alignStack(offset?);
        getAssembly(): string;
        private work();
        private mkLbl(root);
        private terminate(expr);
        private emitJmp(jmp);
        private clearStack();
        private withRef(name, isRef);
        private emitExprInto(e, reg);
        private bitSizeInfo(b);
        private emitExpr(e);
        private emitSharedDef(e);
        private emitSharedTerminate(e);
        private emitRtCall(topExpr);
        private alignedCall(name, cmt?);
        private emitHelper(asm);
        private emitProcCall(topExpr);
        private emitStore(trg, src);
        private cellref(cell);
        private emitLambdaWrapper(isMain);
        private emitCallRaw(name);
    }
}
declare namespace ts.pxtc {
    class AVRSnippets extends AssemblerSnippets {
        nop(): string;
        reg_gets_imm(reg: string, imm: number): string;
        push_fixed(regs: string[]): string;
        pop_fixed(regs: string[]): string;
        proc_setup(main?: boolean): string;
        proc_return(): string;
        debugger_hook(lbl: string): string;
        debugger_bkpt(lbl: string): string;
        breakpoint(): string;
        push_local(reg: string): string;
        pop_locals(n: number): string;
        unconditional_branch(lbl: string): string;
        beq(lbl: string): string;
        bne(lbl: string): string;
        cmp(reg1: string, reg2: string): string;
        cmp_zero(reg: string): string;
        load_reg_src_off(reg: string, src: string, off: string, word?: boolean, store?: boolean, inf?: BitSizeInfo): string;
        rt_call(name: string, r0: string, r1: string): string;
        call_lbl(lbl: string): string;
        call_reg(reg: string): string;
        vcall(mapMethod: string, isSet: boolean, vtableShift: number): string;
        prologue_vtable(arg_index: number, vtableShift: number): string;
        lambda_prologue(): string;
        lambda_epilogue(): string;
        load_ptr(lbl: string, reg: string): string;
        emit_int(v: number, reg: string): string;
        rmap_lo: pxt.Map<string>;
        rmap_hi: pxt.Map<string>;
        inst_lo: pxt.Map<string>;
        inst_hi: pxt.Map<string>;
    }
}
declare namespace ts.pxtc {
    function isBuiltinSimOp(name: string): boolean;
    function shimToJs(shimName: string): string;
    function jsEmit(bin: Binary): void;
}
declare namespace ts.pxtc {
    class ThumbSnippets extends AssemblerSnippets {
        stackAligned(): boolean;
        pushLR(): string;
        popPC(): string;
        nop(): string;
        reg_gets_imm(reg: string, imm: number): string;
        push_fixed(regs: string[]): string;
        pop_fixed(regs: string[]): string;
        proc_setup(main?: boolean): string;
        proc_return(): string;
        debugger_stmt(lbl: string): string;
        debugger_bkpt(lbl: string): string;
        debugger_proc(lbl: string): string;
        push_local(reg: string): string;
        push_locals(n: number): string;
        pop_locals(n: number): string;
        unconditional_branch(lbl: string): string;
        beq(lbl: string): string;
        bne(lbl: string): string;
        cmp(reg1: string, reg2: string): string;
        cmp_zero(reg1: string): string;
        load_reg_src_off(reg: string, src: string, off: string, word?: boolean, store?: boolean, inf?: BitSizeInfo): string;
        rt_call(name: string, r0: string, r1: string): string;
        call_lbl(lbl: string): string;
        call_reg(reg: string): string;
        vcall(mapMethod: string, isSet: boolean, vtableShift: number): string;
        prologue_vtable(arg_top_index: number, vtableShift: number): string;
        lambda_prologue(): string;
        lambda_epilogue(): string;
        load_ptr_full(lbl: string, reg: string): string;
        load_ptr(lbl: string, reg: string): string;
        arithmetic(): string;
        emit_int(v: number, reg: string): string;
    }
}
declare namespace ts.pxtc.decompiler {
    interface RenameLocation {
        name: string;
        diff: number;
        span: ts.TextSpan;
    }
    class RenameMap {
        private renames;
        constructor(renames: RenameLocation[]);
        getRenamesInSpan(start: number, end: number): RenameLocation[];
        getRenameForPosition(position: number): RenameLocation;
    }
    /**
     * Uses the language service to ensure that there are no duplicate variable
     * names in the given file. All variables in Blockly are global, so this is
     * necessary to prevent local variables from colliding.
     */
    function buildRenameMap(p: Program, s: SourceFile): RenameMap;
    interface DecompileBlocksOptions {
        snippetMode?: boolean;
        alwaysEmitOnStart?: boolean;
    }
    function decompileToBlocks(blocksInfo: pxtc.BlocksInfo, file: ts.SourceFile, options: DecompileBlocksOptions, renameMap?: RenameMap): pxtc.CompileResult;
}
declare namespace ts.pxtc.thumb {
    class ThumbProcessor extends pxtc.assembler.AbstractProcessor {
        constructor();
        wordSize(): number;
        is32bit(i: assembler.Instruction): boolean;
        postProcessAbsAddress(f: assembler.File, v: number): number;
        emit32(v0: number, v: number, actual: string): pxtc.assembler.EmitResult;
        commonalize(file: assembler.File): void;
        expandLdlit(f: assembler.File): void;
        getAddressFromLabel(f: assembler.File, i: assembler.Instruction, s: string, wordAligned?: boolean): number;
        isPop(opcode: number): boolean;
        isPush(opcode: number): boolean;
        isAddSP(opcode: number): boolean;
        isSubSP(opcode: number): boolean;
        peephole(ln: pxtc.assembler.Line, lnNext: pxtc.assembler.Line, lnNext2: pxtc.assembler.Line): void;
        registerNo(actual: string): number;
        testAssembler(): void;
    }
}
declare namespace ts.pxtc.ir {
    enum EK {
        None = 0,
        NumberLiteral = 1,
        PointerLiteral = 2,
        RuntimeCall = 3,
        ProcCall = 4,
        SharedRef = 5,
        SharedDef = 6,
        FieldAccess = 7,
        Store = 8,
        CellRef = 9,
        Incr = 10,
        Decr = 11,
        Sequence = 12,
        JmpValue = 13,
        Nop = 14,
    }
    class Node {
        _id: number;
        isExpr(): this is Expr;
        isStmt(): this is Stmt;
    }
    class Expr extends Node {
        exprKind: EK;
        args: Expr[];
        data: any;
        jsInfo: string;
        totalUses: number;
        currUses: number;
        callingConvention: CallingConvention;
        constructor(exprKind: EK, args: Expr[], data: any);
        static clone(e: Expr): Expr;
        isExpr(): boolean;
        isPure(): boolean;
        isStateless(): boolean;
        sharingInfo(): string;
        toString(): string;
        canUpdateCells(): boolean;
    }
    enum SK {
        None = 0,
        Expr = 1,
        Label = 2,
        Jmp = 3,
        StackEmpty = 4,
        Breakpoint = 5,
    }
    enum JmpMode {
        Always = 1,
        IfZero = 2,
        IfNotZero = 3,
        IfJmpValEq = 4,
    }
    class Stmt extends Node {
        stmtKind: SK;
        expr: Expr;
        lblName: string;
        lbl: Stmt;
        lblNumUses: number;
        jmpMode: JmpMode;
        lblId: number;
        breakpointInfo: Breakpoint;
        stmtNo: number;
        findIdx: number;
        terminateExpr: Expr;
        constructor(stmtKind: SK, expr: Expr);
        isStmt(): boolean;
        toString(): string;
    }
    class Cell {
        index: number;
        def: Declaration;
        info: VariableAddInfo;
        isarg: boolean;
        iscap: boolean;
        _isRef: boolean;
        _isLocal: boolean;
        _isGlobal: boolean;
        _debugType: string;
        bitSize: BitSize;
        constructor(index: number, def: Declaration, info: VariableAddInfo);
        getName(): string;
        getDebugInfo(): CellInfo;
        toString(): string;
        uniqueName(): string;
        refSuffix(): string;
        isRef(): boolean;
        isLocal(): boolean;
        isGlobal(): boolean;
        loadCore(): Expr;
        load(): Expr;
        refCountingHandledHere(): boolean;
        isByRefLocal(): boolean;
        storeDirect(src: Expr): Expr;
        storeByRef(src: Expr): Expr;
        isTemporary: boolean;
    }
    class UnnamedCell extends Cell {
        index: number;
        owningProc: Procedure;
        private static unnamedCellCounter;
        private uid;
        constructor(index: number, owningProc: Procedure);
        getName(): string;
        uniqueName(): string;
        isByRefLocal(): boolean;
        isTemporary: boolean;
    }
    interface ProcId {
        proc: Procedure;
        virtualIndex: number;
        ifaceIndex: number;
        mapMethod?: string;
        mapIdx?: number;
    }
    interface ProcQuery {
        action: ts.FunctionLikeDeclaration;
        bindings: TypeBinding[];
    }
    class Procedure extends Node {
        numArgs: number;
        info: FunctionAddInfo;
        seqNo: number;
        isRoot: boolean;
        locals: Cell[];
        captured: Cell[];
        args: Cell[];
        parent: Procedure;
        debugInfo: ProcDebugInfo;
        bindings: TypeBinding[];
        fillDebugInfo: (th: assembler.File) => void;
        classInfo: ClassInfo;
        body: Stmt[];
        lblNo: number;
        action: ts.FunctionLikeDeclaration;
        reset(): void;
        label(): string;
        matches(id: ProcQuery): boolean;
        toString(): string;
        emit(stmt: Stmt): void;
        emitExpr(expr: Expr): void;
        mkLabel(name: string): Stmt;
        emitLbl(lbl: Stmt): void;
        emitLblDirect(lblName: string): void;
        getName(): string;
        mkLocal(def: Declaration, info: VariableAddInfo): Cell;
        mkLocalUnnamed(isRef?: boolean): UnnamedCell;
        localIndex(l: Declaration, noargs?: boolean): Cell;
        stackEmpty(): void;
        emitClrIfRef(p: Cell): void;
        emitClrs(): void;
        emitJmpZ(trg: string | Stmt, expr: Expr): void;
        emitJmp(trg: string | Stmt, expr?: Expr, mode?: JmpMode, terminate?: Expr): void;
        resolve(): void;
    }
    function iterExpr(e: Expr, f: (v: Expr) => void): void;
    function stmt(kind: SK, expr: Expr): Stmt;
    function op(kind: EK, args: Expr[], data?: any): Expr;
    function numlit(v: number | boolean): Expr;
    function shared(expr: Expr): Expr;
    function ptrlit(lbl: string, jsInfo: string, full?: boolean): Expr;
    function rtcall(name: string, args: Expr[]): Expr;
    function rtcallMask(name: string, mask: number, callingConv: CallingConvention, args: Expr[]): Expr;
    function flattenArgs(topExpr: ir.Expr): {
        precomp: Expr[];
        flattened: Expr[];
    };
}
declare namespace ts.pxtc {
    const taggedUndefined: number;
    const taggedNull: number;
    const taggedFalse: number;
    const taggedTrue: number;
    const thumbArithmeticInstr: Map<boolean>;
    const numberArithmeticInstr: Map<boolean>;
    const SK: typeof SyntaxKind;
    const numReservedGlobals: number;
    interface FieldWithAddInfo extends PropertyDeclaration {
        irGetter?: MethodDeclaration;
        irSetter?: MethodDeclaration;
    }
    function getNodeId(n: Node): number;
    function stringKind(n: Node): any;
    function sizeOfBitSize(b: BitSize): number;
    function isBitSizeSigned(b: BitSize): boolean;
    function setCellProps(l: ir.Cell): void;
    interface CallInfo {
        decl: Declaration;
        qName: string;
        attrs: CommentAttrs;
        args: Expression[];
        isExpression: boolean;
        isAutoCreate?: boolean;
    }
    interface ClassInfo {
        id: string;
        baseClassInfo: ClassInfo;
        decl: ClassDeclaration;
        numRefFields: number;
        allfields: FieldWithAddInfo[];
        methods: FunctionLikeDeclaration[];
        refmask: boolean[];
        attrs: CommentAttrs;
        isUsed?: boolean;
        vtable?: ir.Procedure[];
        itable?: ir.Procedure[];
        itableInfo?: string[];
        bindings: TypeBinding[];
        ctor?: ir.Procedure;
    }
    interface BinaryExpressionInfo {
        leftType: string;
        rightType: string;
    }
    let target: CompileTarget;
    interface TypeBinding {
        tp: Type;
        isRef: boolean;
    }
    function getComments(node: Node): string;
    function parseCommentsOnSymbol(symbol: Symbol): CommentAttrs;
    function parseComments(node0: Node): CommentAttrs;
    function getName(node: Node & {
        name?: any;
    }): string;
    function getDeclName(node: Declaration): string;
    function getFunctionLabel(node: FunctionLikeDeclaration, bindings: TypeBinding[]): string;
    interface FieldAccessInfo {
        idx: number;
        name: string;
        isRef: boolean;
        shimName: string;
    }
    type VarOrParam = VariableDeclaration | ParameterDeclaration | PropertyDeclaration;
    type TypedDecl = Declaration & {
        type?: TypeNode;
    };
    interface VariableAddInfo {
        captured?: boolean;
        written?: boolean;
    }
    interface FunctionAddInfo {
        capturedVars: VarOrParam[];
        decl: FunctionLikeDeclaration;
        location?: ir.Cell;
        thisParameter?: ParameterDeclaration;
        usages?: TypeBinding[][];
        prePassUsagesEmitted?: number;
        virtualParent?: FunctionAddInfo;
        virtualInstances?: FunctionAddInfo[];
        virtualIndex?: number;
        isUsed?: boolean;
        parentClassInfo?: ClassInfo;
    }
    function compileBinary(program: Program, host: CompilerHost, opts: CompileOptions, res: CompileResult): EmitResult;
    class Binary {
        procs: ir.Procedure[];
        globals: ir.Cell[];
        globalsWords: number;
        finalPass: boolean;
        target: CompileTarget;
        writeFile: (fn: string, cont: string) => void;
        res: CompileResult;
        options: CompileOptions;
        usedClassInfos: ClassInfo[];
        sourceHash: string;
        checksumBlock: number[];
        numStmts: number;
        strings: Map<string>;
        hexlits: Map<string>;
        doubles: Map<string>;
        otherLiterals: string[];
        codeHelpers: Map<string>;
        lblNo: number;
        reset(): void;
        addProc(proc: ir.Procedure): void;
        private emitLabelled(v, hash, lblpref);
        emitDouble(v: number): string;
        emitString(s: string): string;
        emitHexLiteral(s: string): string;
    }
}
declare namespace ts.pxtc {
    interface CompileResult {
        ast?: Program;
    }
    function getTsCompilerOptions(opts: CompileOptions): CompilerOptions;
    function nodeLocationInfo(node: ts.Node): LocationInfo;
    function patchUpDiagnostics(diags: Diagnostic[]): KsDiagnostic[];
    function compile(opts: CompileOptions): CompileResult;
    function decompile(opts: CompileOptions, fileName: string): CompileResult;
}
declare namespace pxt.elf {
    interface Info {
        template: Uint8Array;
        imageMemStart: number;
        imageFileStart: number;
        phOffset: number;
    }
    function parse(buf: Uint8Array): Info;
    function patch(info: Info, program: Uint8Array): Uint8Array;
}
declare namespace ts.pxtc {
    function toStr(v: any): string;
    function format(input: string, pos: number): {
        formatted: string;
        pos: number;
    };
}
declare namespace ts.pxtc {
    const vtableShift: number;
    namespace hex {
        let bytecodeStartAddrPadded: number;
        let asmTotalSource: string;
        const defaultPageSize: number;
        function hexDump(bytes: ArrayLike<number>, startOffset?: number): string;
        function setupInlineAssembly(opts: CompileOptions): void;
        function flashCodeAlign(opts: CompileTarget): number;
        function encodeVTPtr(ptr: number): number;
        function setupFor(opts: CompileTarget, extInfo: ExtensionInfo, hexinfo: pxtc.HexInfo): void;
        function validateShim(funname: string, shimName: string, attrs: CommentAttrs, hasRet: boolean, argIsNumber: boolean[]): void;
        function lookupFunc(name: string): FuncInfo;
        function lookupFunctionAddr(name: string): number;
        function hexTemplateHash(): string;
        function hexPrelude(): string;
        function patchHex(bin: Binary, buf: number[], shortForm: boolean, useuf2: boolean): string[];
    }
    function asmline(s: string): string;
    function processorInlineAssemble(nativeType: string, src: string): number[];
    function processorEmit(bin: Binary, opts: CompileOptions, cres: CompileResult): void;
    let validateShim: typeof hex.validateShim;
}
declare namespace ts.pxtc {
    function plainTsc(dir: string): Program;
}
declare namespace ts.pxtc {
    const placeholderChar: string;
    const defaultImgLit: string;
    function renderCall(apiInfo: pxtc.ApisInfo, si: SymbolInfo): string;
    function renderParameters(apis: pxtc.ApisInfo, si: SymbolInfo, cursorMarker?: string): string;
    interface GenMarkdownOptions {
        package?: boolean;
        locs?: boolean;
        docs?: boolean;
    }
    function genMarkdown(pkg: string, apiInfo: ApisInfo, options?: GenMarkdownOptions): pxt.Map<string>;
    function getApiInfo(program: Program, legacyOnly?: boolean): ApisInfo;
    function getFullName(typechecker: TypeChecker, symbol: Symbol): string;
    function fillCompletionEntries(program: Program, symbols: Symbol[], r: CompletionInfo, apiInfo: ApisInfo): void;
}
declare namespace ts.pxtc.service {
    function performOperation(op: string, arg: OpArg): any;
    function getSnippet(n: ts.SignatureDeclaration, attrs?: CommentAttrs): string;
}
