var pxtTargetBundle = {
  "id": "pxt-lrf",
  "name": "LRF Blocks",
  "title": "Little Robot Code Editor",
  "corepkg": "core",
  "bundleddirs": [
    "libs/core"
  ],
  "runtime": {
    "mathBlocks": true,
    "textBlocks": false,
    "listsBlocks": true,
    "variablesBlocks": true,
    "functionBlocks": true,
    "logicBlocks": true,
    "loopsBlocks": true,
    "onStartUnDeletable": false
  },
  "simulator": {
    "autoRun": true,
    "hideFullscreen": true,
    "headless": true
  },
  "appTheme": {
    "accentColor": "#FFFFFF",
    "boardName": "Little Robot Friend",
    "logoUrl": "https://littlerobotfriends.com/",
    "homeUrl": "https://littlerobotfriends.com/",
    "privacyUrl": "https://littlerobotfriends.com/",
    "termsOfUseUrl": "https://littlerobotfriends.com/",
    "coloredToolbox": true,
    "invertedMenu": true,
    "blocklyOptions": {
      "grid": {
        "spacing": 45,
        "length": 7,
        "colour": "rgba(189, 195, 199, 0.30)",
        "snap": true
      },
      "trashcan": true
    },
    "disableBlockIcons": false,
    "blocksOnly": true,
    "blockHats": true,
    "logo": "data:image/png;base64,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",
    "organization": "Little Robot Friends",
    "organizationLogo": "data:image/png;base64,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",
    "TOC": [
      {
        "name": "Blocks",
        "subitems": [
          {
            "name": "On Start",
            "subitems": [],
            "path": "/blocks/on-start",
            "prevName": "Blocks",
            "prevPath": "/blocks",
            "nextName": "Loops",
            "nextPath": "/blocks/loops"
          },
          {
            "name": "Loops",
            "subitems": [
              {
                "name": "repeat",
                "subitems": [],
                "path": "/blocks/loops/repeat",
                "prevName": "Loops",
                "prevPath": "/blocks/loops",
                "nextName": "for",
                "nextPath": "/blocks/loops/for"
              },
              {
                "name": "for",
                "subitems": [],
                "path": "/blocks/loops/for",
                "prevName": "repeat",
                "prevPath": "/blocks/loops/repeat",
                "nextName": "while",
                "nextPath": "/blocks/loops/while"
              },
              {
                "name": "while",
                "subitems": [],
                "path": "/blocks/loops/while",
                "prevName": "for",
                "prevPath": "/blocks/loops/for",
                "nextName": "Logic",
                "nextPath": "/blocks/logic"
              }
            ],
            "path": "/blocks/loops",
            "prevName": "On Start",
            "prevPath": "/blocks/on-start",
            "nextName": "repeat",
            "nextPath": "/blocks/loops/repeat"
          },
          {
            "name": "Logic",
            "subitems": [
              {
                "name": "if",
                "subitems": [],
                "path": "/blocks/logic/if",
                "prevName": "Logic",
                "prevPath": "/blocks/logic",
                "nextName": "Boolean",
                "nextPath": "/blocks/logic/boolean"
              },
              {
                "name": "Boolean",
                "subitems": [],
                "path": "/blocks/logic/boolean",
                "prevName": "if",
                "prevPath": "/blocks/logic/if",
                "nextName": "Variables",
                "nextPath": "/blocks/variables"
              }
            ],
            "path": "/blocks/logic",
            "prevName": "while",
            "prevPath": "/blocks/loops/while",
            "nextName": "if",
            "nextPath": "/blocks/logic/if"
          },
          {
            "name": "Variables",
            "subitems": [
              {
                "name": "assign",
                "subitems": [],
                "path": "/blocks/variables/assign",
                "prevName": "Variables",
                "prevPath": "/blocks/variables",
                "nextName": "change var",
                "nextPath": "/blocks/variables/change"
              },
              {
                "name": "change var",
                "subitems": [],
                "path": "/blocks/variables/change",
                "prevName": "assign",
                "prevPath": "/blocks/variables/assign",
                "nextName": "var",
                "nextPath": "/blocks/variables/var"
              },
              {
                "name": "var",
                "subitems": [],
                "path": "/blocks/variables/var",
                "prevName": "change var",
                "prevPath": "/blocks/variables/change",
                "nextName": "Math",
                "nextPath": "/blocks/math"
              }
            ],
            "path": "/blocks/variables",
            "prevName": "Boolean",
            "prevPath": "/blocks/logic/boolean",
            "nextName": "assign",
            "nextPath": "/blocks/variables/assign"
          },
          {
            "name": "Math",
            "subitems": [],
            "path": "/blocks/math",
            "prevName": "var",
            "prevPath": "/blocks/variables/var",
            "nextName": "JavaScript blocks",
            "nextPath": "/blocks/javascript-blocks"
          },
          {
            "name": "JavaScript blocks",
            "subitems": [],
            "path": "/blocks/javascript-blocks",
            "prevName": "Math",
            "prevPath": "/blocks/math",
            "nextName": "Custom blocks",
            "nextPath": "/blocks/custom"
          },
          {
            "name": "Custom blocks",
            "subitems": [],
            "path": "/blocks/custom",
            "prevName": "JavaScript blocks",
            "prevPath": "/blocks/javascript-blocks",
            "nextName": "JavaScript",
            "nextPath": "/javascript"
          }
        ],
        "path": "/blocks",
        "nextName": "On Start",
        "nextPath": "/blocks/on-start"
      },
      {
        "name": "JavaScript",
        "subitems": [
          {
            "name": "Calling",
            "subitems": [],
            "path": "/javascript/call",
            "prevName": "JavaScript",
            "prevPath": "/javascript",
            "nextName": "Sequencing",
            "nextPath": "/javascript/sequence"
          },
          {
            "name": "Sequencing",
            "subitems": [],
            "path": "/javascript/sequence",
            "prevName": "Calling",
            "prevPath": "/javascript/call",
            "nextName": "Variables",
            "nextPath": "/javascript/variables"
          },
          {
            "name": "Variables",
            "subitems": [],
            "path": "/javascript/variables",
            "prevName": "Sequencing",
            "prevPath": "/javascript/sequence",
            "nextName": "Operators",
            "nextPath": "/javascript/operators"
          },
          {
            "name": "Operators",
            "subitems": [],
            "path": "/javascript/operators",
            "prevName": "Variables",
            "prevPath": "/javascript/variables",
            "nextName": "Statements",
            "nextPath": "/javascript/statements"
          },
          {
            "name": "Statements",
            "subitems": [],
            "path": "/javascript/statements",
            "prevName": "Operators",
            "prevPath": "/javascript/operators",
            "nextName": "Functions",
            "nextPath": "/javascript/functions"
          },
          {
            "name": "Functions",
            "subitems": [],
            "path": "/javascript/functions",
            "prevName": "Statements",
            "prevPath": "/javascript/statements",
            "nextName": "Types",
            "nextPath": "/javascript/types"
          },
          {
            "name": "Types",
            "subitems": [],
            "path": "/javascript/types",
            "prevName": "Functions",
            "prevPath": "/javascript/functions",
            "nextName": "Classes",
            "nextPath": "/javascript/classes"
          },
          {
            "name": "Classes",
            "subitems": [],
            "path": "/javascript/classes",
            "prevName": "Types",
            "prevPath": "/javascript/types",
            "nextName": "Interfaces",
            "nextPath": "/javascript/interfaces"
          },
          {
            "name": "Interfaces",
            "subitems": [],
            "path": "/javascript/interfaces",
            "prevName": "Classes",
            "prevPath": "/javascript/classes",
            "nextName": "Generics",
            "nextPath": "/javascript/generics"
          },
          {
            "name": "Generics",
            "subitems": [],
            "path": "/javascript/generics",
            "prevName": "Interfaces",
            "prevPath": "/javascript/interfaces",
            "nextName": "Types",
            "nextPath": "/types"
          }
        ],
        "path": "/javascript",
        "prevName": "Custom blocks",
        "prevPath": "/blocks/custom",
        "nextName": "Calling",
        "nextPath": "/javascript/call"
      },
      {
        "name": "Types",
        "subitems": [
          {
            "name": "Number",
            "subitems": [],
            "path": "/types/number",
            "prevName": "Types",
            "prevPath": "/types",
            "nextName": "String",
            "nextPath": "/types/string"
          },
          {
            "name": "String",
            "subitems": [],
            "path": "/types/string",
            "prevName": "Number",
            "prevPath": "/types/number",
            "nextName": "Boolean",
            "nextPath": "/types/boolean"
          },
          {
            "name": "Boolean",
            "subitems": [],
            "path": "/types/boolean",
            "prevName": "String",
            "prevPath": "/types/string",
            "nextName": "Array",
            "nextPath": "/types/array"
          },
          {
            "name": "Array",
            "subitems": [],
            "path": "/types/array",
            "prevName": "Boolean",
            "prevPath": "/types/boolean",
            "nextName": "Function",
            "nextPath": "/types/function"
          },
          {
            "name": "Function",
            "subitems": [],
            "path": "/types/function",
            "prevName": "Array",
            "prevPath": "/types/array",
            "nextName": "Support",
            "nextPath": "/support"
          }
        ],
        "path": "/types",
        "prevName": "Generics",
        "prevPath": "/javascript/generics",
        "nextName": "Number",
        "nextPath": "/types/number"
      },
      {
        "name": "",
        "subitems": [
          {
            "name": "Support",
            "subitems": [],
            "path": "/support",
            "prevName": "Function",
            "prevPath": "/types/function",
            "nextName": "FAQ",
            "nextPath": "/faq"
          },
          {
            "name": "FAQ",
            "subitems": [],
            "path": "/faq",
            "prevName": "Support",
            "prevPath": "/support",
            "nextName": "Translate",
            "nextPath": "/translate"
          },
          {
            "name": "Translate",
            "subitems": [],
            "path": "/translate",
            "prevName": "FAQ",
            "prevPath": "/faq",
            "nextName": "Sharing projects",
            "nextPath": "/share"
          },
          {
            "name": "Sharing projects",
            "subitems": [],
            "path": "/share",
            "prevName": "Translate",
            "prevPath": "/translate",
            "nextName": "Offline support",
            "nextPath": "/offline"
          },
          {
            "name": "Offline support",
            "subitems": [],
            "path": "/offline",
            "prevName": "Sharing projects",
            "prevPath": "/share",
            "nextName": "Streaming",
            "nextPath": "/streaming"
          },
          {
            "name": "Streaming",
            "subitems": [],
            "path": "/streaming",
            "prevName": "Offline support",
            "prevPath": "/offline"
          }
        ],
        "prevName": "Function",
        "prevPath": "/types/function"
      }
    ],
    "embedUrl": "https://littlerobotfriends.com/",
    "id": "pxt-lrf",
    "title": "Little Robot Code Editor",
    "name": "LRF Blocks",
    "logoCDN": "@cdnUrl@/blob/b6b5ed6113fd0e3fc9b5e19640c8d78c4c34fcb1/lrf-128.png",
    "organizationLogoCDN": "@cdnUrl@/blob/f7933159bf11db88863be6747cb444a3fb82ef67/lrf-logo.png",
    "htmlDocIncludes": {}
  },
  "blocksprj": {
    "id": "blocksprj",
    "config": {
      "name": "{0}",
      "dependencies": {
        "core": "*"
      },
      "description": "",
      "files": [
        "main.blocks",
        "main.ts",
        "README.md"
      ]
    },
    "files": {
      "README.md": " ",
      "main.blocks": "<xml xmlns=\"http://www.w3.org/1999/xhtml\">\n  <variables>\n    <variable type=\"\" id=\"`7v|j,;HLu7qOl:[H:{9\">flag</variable>\n    <variable type=\"\" id=\"$7Z*cLt4dTj@TA(fS,[b\">item</variable>\n  </variables>\n  <block type=\"pxt-on-start\" id=\"K};|Tv3xxqoh;GE/$Km1\" deletable=\"true\" x=\"0\" y=\"0\">\n    <statement name=\"HANDLER\">\n      <block type=\"LRFEyeMessages_setEyeColors\" id=\"{FDch!vqFLL+o8p6v)GS\">\n        <field name=\"left\">LRFColour.red</field>\n        <field name=\"right\">LRFColour.red</field>\n      </block>\n    </statement>\n  </block>\n  <block type=\"on_hair_touched\" id=\"=5Mad=zYsYXwlH=8Oyt,\" x=\"0\" y=\"90\">\n    <field name=\"type\">LRFTouchEventType.tapped</field>\n    <statement name=\"HANDLER\">\n      <block type=\"LRFEyeMessages_setEyeColors\" id=\"xtLq:3MIanS@pe`}WV@F\">\n        <field name=\"left\">LRFColour.blue</field>\n        <field name=\"right\">LRFColour.blue</field>\n      </block>\n    </statement>\n  </block>\n</xml>\n",
      "main.ts": "LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {\n    LRFEyeMessages.setEyeColors(LRFColour.blue, LRFColour.blue)\n})\nLRFEyeMessages.setEyeColors(LRFColour.red, LRFColour.red)\n"
    }
  },
  "tsprj": {
    "id": "tsprj",
    "config": {
      "name": "{0}",
      "dependencies": {
        "core": "*"
      },
      "description": "",
      "files": [
        "main.ts",
        "README.md"
      ]
    },
    "files": {
      "README.md": " ",
      "main.ts": "LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {\n    LRFEyeMessages.setEyeColors(LRFColour.blue, LRFColour.blue)\n})\nLRFEyeMessages.setEyeColors(LRFColour.red, LRFColour.red)\n"
    }
  },
  "bundledpkgs": {
    "core": {
      "README.md": "# basic\n\nAdd your docs here...",
      "enums.d.ts": "declare const enum Direction {\n    //% block=left\n    Left,\n    //% block=right\n    Right\n}\n\n//% block\ndeclare const enum LRFOctave {\n    lowest,\n    low,\n    midLow,\n    mid,\n    midhigh,\n    high,\n    higher,\n    highest\n}\n\ndeclare const enum LRFNote {\n    a,\n    as,\n    b,\n    c,\n    cs,\n    d,\n    ds,\n    e,\n    f,\n    fs,\n    g,\n    gs,\n    mute,\n    null = 15\n}\n\ndeclare const enum LRFIntonation {\n    flat,\n    rising,\n    falling,\n    peaking,\n    dipping\n}\n\ndeclare const enum LRFDuration {\n    short = 1, //1 block\n    doubleShort = 2, //2 blocks\n    medium = 3, //4 blocks\n    doubleMedium = 4, //8 blocks\n    long = 5, //16 blocks\n    doubleLong = 6,\n    veryLong = 7,\n    none = 0\n}\n\ndeclare const enum LRFColour {\n    red = 1,\n    green = 2,\n    blue = 3,\n    orange = 4,\n    cyan = 5,\n    purple = 6,\n    yellow = 7,\n    pink = 8,\n    white = 15,\n    none = 0\n}\n\ndeclare const enum LRFHelloExpression {\n    // Hellos (3)\n    //% blockId='hello' block='hello'\n    hello = 0,\n    //% blockId='happy-hello' block='happy-hello'\n    happyHello = 1,\n    //% blockId='angry-hello' block='angry-hello'\n    angryHello = 2\n}\n\ndeclare const enum LRFMoodExpression {\n    // Moods (8)\n    // % blockId='happy' block='happy'\n    happy = 3,\n    // % blockId='very-happy' block='very-happy'\n    veryHappy = 4,\n    // % blockId='excited' block='excited'\n    excited = 5,\n    // % blockId='very-excited' block='very-excited'\n    veryExcited = 6,\n    // % blockId='annoyed' block='annoyed'\n    annoyed = 7,\n    // % blockId='very-annoyed' block='very-annoyed'\n    veryAnnoyed = 8,\n    // % blockId='angry' block='angry'\n    angry = 9,\n    // % blockId='very-angry' block='very-angry'\n    veryAngry = 10,\n}\n\ndeclare const enum LRFLaughExpression {\n    // Laughs (4)\n    // % blockId='giggle' block='giggle'\n    giggle = 11,\n    // % blockId='laugh' block='laugh'\n    laugh = 12,\n    // % blockId='hysterical' block='hysterical'\n    hysterical = 13,\n    // % blockId='evil-cackle' block='evil-cackle'\n    evilCackle = 14\n}\n\ndeclare const enum LRFCryExpression {\n    // Cries (2)\n    // % blockId='pout' block='pout'\n    pout = 15,\n    // % blockId='sob' block='sob'\n    sob = 16\n}\n\ndeclare const enum LRFScaredExpression {\n    // Scared (3)\n    // % blockId='scared' block='scared'\n    scared = 17,\n    // % blockId='terrified' block='terrified'\n    terrified = 18,\n    // % blockId='relieved' block='relieved'\n    relieved = 19\n}\n\ndeclare const enum LRFSleepyExpression {\n\n    // Sleepy (3)\n    // % blockId='bored' block='bored'\n    bored = 20,\n    // % blockId='yawn' block='yawn'\n    yawn = 21,\n    // % blockId='snoring' block='snoring'\n    snoring = 22\n}\n\ndeclare const enum LRFSystemExpression {\n    // System (3)\n    // % blockId='hungry block='hungry\n    hungry = 23,\n    // % blockId='power-up' block='power-up'\n    powerUp = 24,\n    // % blockId='alarm' block='alarm'\n    alarm = 25\n}\n\ndeclare const enum LRFMiscExpression {\n    // % blockId='awww' block='awww'\n    awww = 26,\n    // % blockId='yikes' block='yikes'\n    yikes = 27,\n    // % blockId='whoa-up' block='whoa-up'\n    whoaUp = 28,\n    // % blockId='whoa-down' block='whoa-down'\n    whoaDown = 29,\n    // % blockId='whoa-whoa-whoa' block='whoa-whoa-whoa'\n    whoaWhoaWhoa = 30,\n\n    // Special\n    custom = 0xa0,\n    temp = 0xfd,\n    signature = 0xfe,\n    null = 0xff\n}\n\ndeclare const enum LRFTouchEventType {\n    tapped,\n    tickled,\n    //% block=\"held/hugged\"\n    holdHug\n}\n\ndeclare const enum LRFSoundSensorEventType {\n    normal,\n    loud\n}\n\ndeclare const enum LRFLightSensorEventType {\n    //% block=\"dark for too long\"\n    tooDarkLong,\n    dark,\n    normal,\n    bright,\n    //% block=\"bright for too long\"\n    tooBrightLong\n}\n\ndeclare const enum LRFMotionSensorEventType {\n    //% block=\"tilt left\"\n    tiltLeft,\n    //% block=\"tilt right\"\n    tiltRight,\n    //% block=\"lay left\"\n    layLeft,\n    //% block=\"lay right\"\n    layRight,\n    shake\n}\n\ndeclare const enum LRFBrainSensorEventType {\n    hungry,\n    bored\n}\n\ndeclare const enum LRFTouchSensorChannel {\n  hair,\n  left,\n  right\n}\n\ndeclare const enum LRFMotionSensorChannel {\n  x,\n  y,\n  z\n}\n\ndeclare const enum LRFInputs {\n    hair,\n    leftHand,\n    rightHand,\n    soundSensor,\n    lightSensor,\n    motionSensor,\n    brainSensor\n}\n",
      "ns.ts": "//% color=#DD0078 block=\"Speech & Sounds\" icon=\"\\uf0a1\" weight=130\nnamespace LRFSoundMessages {\n\n}\n\n//% color=#0098BB block=\"Eyes & Patterns\" icon=\"\\uf06e\" weight=120\nnamespace LRFEyeMessages {\n\n}\n\n//% color=#EA8225 block=\"Sensor Events\" icon=\"\\uf14c\" weight=110\nnamespace LRFInputEvents {\n\n}\n\n//% color=#53AD40 block=\"Expressions\" icon=\"\\uf0e5\" weight=100\nnamespace LRFExpressions {\n\n}\n\n\n\n\n\n\n",
      "pxt-core.d.ts": "/// <reference no-default-lib=\"true\"/>\n\ninterface Array<T> {\n    /**\n      * Gets or sets the length of the array. This is a number one higher than the highest element defined in an array.\n      */\n    //% shim=Array_::length weight=84\n    //% blockId=\"lists_length\" block=\"length of %VALUE\" blockBuiltin=true blockNamespace=\"arrays\"\n    length: number;\n\n    /**\n      * Appends new elements to an array.\n      * @param items New elements of the Array.\n      */\n    //% help=arrays/push\n    //% shim=Array_::push weight=49\n    //% blockId=\"array_push\" block=\"%list| add value %value| to end\" blockNamespace=\"arrays\"\n    push(item: T): void;\n\n    /**\n      * Removes the last element from an array and returns it.\n      */\n    //% help=arrays/pop\n    //% shim=Array_::pop weight=48\n    //% blockId=\"array_pop\" block=\"get and remove last value from %list\" blockNamespace=\"arrays\"\n    pop(): T;\n\n    /**\n      * Reverses the elements in an Array. The first array element becomes the last, and the last array element becomes the first.\n      */\n    //% help=arrays/reverse\n    //% helper=arrayReverse weight=10 advanced=true\n    //% blockId=\"array_reverse\" block=\"reverse %list\" blockNamespace=\"arrays\"\n    reverse(): void;\n\n    /**\n      * Removes the first element from an array and returns that element. This method changes the length of the array.\n      */\n    //% help=arrays/shift\n    //% helper=arrayShift weight=70 advanced=true\n    //% blockId=\"array_shift\" block=\"get and remove first value from %list\" blockNamespace=\"arrays\"\n    shift(): T;\n\n    /**\n      * Adds one element to the beginning of an array and returns the new length of the array.\n      * @param element to insert at the start of the Array.\n      */\n    //% help=arrays/unshift\n    //% helper=arrayUnshift weight=69 advanced=true\n    //% blockId=\"array_unshift\" block=\"%list| insert %value| at beginning\" blockNamespace=\"arrays\"\n    //unshift(...values:T[]): number; //rest is not supported in our compiler yet.\n    unshift(value: T): number;\n\n    /**\n      * Returns a section of an array.\n      * @param start The beginning of the specified portion of the array. eg: 0\n      * @param end The end of the specified portion of the array. eg: 0\n      */\n    //% help=arrays/slice\n    //% helper=arraySlice weight=41 advanced=true blockNamespace=\"arrays\"\n    slice(start: number, end: number): T[];\n\n    /**\n      * Removes elements from an array.\n      * @param start The zero-based location in the array from which to start removing elements. eg: 0\n      * @param deleteCount The number of elements to remove. eg: 0\n      */\n    //% helper=arraySplice weight=40\n    splice(start: number, deleteCount: number): void;\n\n    /**\n      * Sorts the elements of an array in place and returns the array. The sort is not necessarily stable.\n      * @param specifies a function that defines the sort order. If omitted, the array is sorted according to the prmitive type\n      */\n    //% helper=arraySort weight=40\n    sort(callbackfn?: (value1: T, value2: T) => number): T[];\n\n    /**\n      * Calls a defined callback function on each element of an array, and returns an array that contains the results.\n      * @param callbackfn A function that accepts up to two arguments. The map method calls the callbackfn function one time for each element in the array.\n      */\n    //% helper=arrayMap weight=40\n    map<U>(callbackfn: (value: T, index: number) => U): U[];\n\n    /**\n      * Returns the elements of an array that meet the condition specified in a callback function.\n      * @param callbackfn A function that accepts up to two arguments. The filter method calls the callbackfn function one time for each element in the array.\n      */\n    //% helper=arrayFilter weight=40\n    filter(callbackfn: (value: T, index: number) => boolean): T[];\n\n    /**\n      * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.\n      * @param callbackfn A function that accepts up to three arguments. The reduce method calls the callbackfn function one time for each element in the array.\n      * @param initialValue Initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.\n      */\n    //% helper=arrayReduce weight=40\n    reduce<U>(callbackfn: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): U;\n\n\n    /** Removes the first occurence of an object. Returns true if removed. */\n    //% shim=Array_::removeElement weight=48\n    removeElement(element: T): boolean;\n\n    /** Removes the object at position index. */\n    //% help=arrays/removeat\n    //% shim=Array_::removeAt weight=49 advanced=true\n    //% blockId=\"array_removeat\" block=\"%list| remove value at %index\" blockNamespace=\"arrays\"\n    removeAt(index: number): T;\n\n    /**\n     * Insert the value at a particular index, increases length by 1\n     * @param index the zero-based position in the list to insert the value, eg: 0\n     * @param the value to insert, eg: 0\n     */\n    //% help=arrays/insertat\n    //% shim=Array_::insertAt weight=84 advanced=true\n    //% blockId=\"array_insertAt\" block=\"%list| insert at %index| value %value\" blockNamespace=\"arrays\"\n    insertAt(index: number, value: T): void;\n\n    /**\n      * Returns the index of the first occurrence of a value in an array.\n      * @param item The value to locate in the array.\n      * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.\n      */\n    //% help=arrays/indexof\n    //% shim=Array_::indexOf weight=50 advanced=true\n    //% blockId=\"array_indexof\" block=\"%list| find index of %value\" blockNamespace=\"arrays\"\n    indexOf(item: T, fromIndex?: number): number;\n\n    /**\n     * Gets the value at a particular index\n     * @param index the zero-based position in the list of the item, eg: 0\n     */\n    //% help=arrays/get\n    //% shim=Array_::getAt weight=85\n    get(index: number): T;\n\n    /**\n     * Stores the value at a particular index\n     * @param index the zero-based position in the list to store the value, eg: 0\n     * @param the value to insert, eg: 0\n     */\n    //% help=arrays/set\n    //% shim=Array_::setAt weight=84\n    set(index: number, value: T): void;\n\n    [n: number]: T;\n}\n\ndeclare interface String {\n    // This block is currently disabled in favor of the built-in Blockly \"Create text with\" block, which compiles to \"\" + \"\"\n    // Add % sign back to the block annotation to re-enable\n    /**\n     * Returns a string that contains the concatenation of two or more strings.\n     * @param other The string to append to the end of the string.\n     */\n    //% shim=String_::concat weight=49\n    //% blockId=\"string_concat\" blockNamespace=\"text\"\n    // block=\"join %list=text|%other\"\n    concat(other: string): string;\n\n    /**\n     * Returns the character at the specified index.\n     * @param index The zero-based index of the desired character.\n     */\n    //% shim=String_::charAt weight=48\n    //% help=text/char-at\n    //% blockId=\"string_get\" block=\"char from %this=text|at %pos\" blockNamespace=\"text\"\n    charAt(index: number): string;\n\n    /** Returns the length of a String object. */\n    //% property shim=String_::length weight=47\n    //% blockId=\"text_length\" block=\"length of %VALUE\" blockBuiltin=true blockNamespace=\"text\"\n    length: number;\n\n    /**\n     * Returns the Unicode value of the character at the specified location.\n     * @param index The zero-based index of the desired character. If there is no character at the specified index, NaN is returned.\n     */\n    //% shim=String_::charCodeAt\n    charCodeAt(index: number): number;\n\n    /**\n     * Determines whether relative order of two strings (in ASCII encoding).\n     * @param that String to compare to target string\n     */\n    //% shim=String_::compare\n    //% help=text/compare\n    //% blockId=\"string_compare\" block=\"compare %this=text| to %that\" blockNamespace=\"text\"\n    compare(that: string): number;\n\n    /**\n     * Return substring of the current string.\n     * @param start first character index; can be negative from counting from the end, eg:0\n     * @param length number of characters to extract\n     */\n    //% shim=String_::substr length.defl=1000000\n    //% help=text/substr\n    //% blockId=\"string_substr\" block=\"substring of %this=text|from %start|of length %length\" blockNamespace=\"text\"\n    substr(start: number, length?: number): string;\n\n    // This block is currently disabled, as it does not compile in some targets\n    // Add % sign back to the block annotation to re-enable\n    /** Returns a value indicating if the string is empty */\n    //% shim=String_::isEmpty\n    //% blockId=\"string_isempty\" blockNamespace=\"text\"\n    // block=\"%this=text| is empty\"\n    isEmpty(): boolean;\n\n    [index: number]: string;\n}\n\n/**\n  * Convert a string to an integer.\n  * @param s A string to convert into a number.\n  */\n//% shim=String_::toNumber\n//% help=text/parse-int\n//% blockId=\"string_parseint\" block=\"parse to integer %text\" blockNamespace=\"text\"\ndeclare function parseInt(text: string): number;\n\ninterface Object { }\ninterface Function { }\ninterface IArguments { }\ninterface RegExp { }\n\ntype uint8 = number;\ntype uint16 = number;\ntype uint32 = number;\ntype int8 = number;\ntype int16 = number;\ntype int32 = number;\n\n\ndeclare interface Boolean {\n    /**\n     * Returns a string representation of an object.\n     */\n    //% shim=Boolean_::toString\n    toString(): string;\n}\n\n/**\n * Combine, split, and search text strings.\n*/\n//% blockNamespace=\"Text\"\ndeclare namespace String {\n\n    /**\n     * Make a string from the given ASCII character code.\n     */\n    //% help=math/string-from-char-code\n    //% shim=String_::fromCharCode\n    //% advanced=true\n    //% blockNamespace=\"Math\" blockId=\"stringFromCharCode\" block=\"text from char code %code\" weight=1\n    function fromCharCode(code: number): string;\n}\n\ndeclare interface Number {\n    /**\n     * Returns a string representation of a number.\n     */\n    //% shim=Number_::toString\n    toString(): string;\n}\n\n/**\n * Add, remove, and replace items in lists.\n*/\n//% blockNamespace=\"Arrays\"\ndeclare namespace Array {\n}\n\n/**\n * More complex operations with numbers.\n*/\ndeclare namespace Math {\n    /**\n     * Returns the value of a base expression taken to a specified power.\n     * @param x The base value of the expression.\n     * @param y The exponent value of the expression.\n     */\n    //% shim=Math_::pow\n    function pow(x: number, y: number): number;\n\n    /**\n     * Returns a pseudorandom number between 0 and 1.\n     */\n    //% shim=Math_::random\n    //% helpUrl=\"/reference/math/random\"\n    function random(): number;\n\n    /**\n     * Returns a pseudorandom number between min and max included. \n     * If both numbers are integral, the result is integral.\n     * @param min the lower inclusive bound, eg: 0\n     * @param max the upper inclusive bound, eg: 10\n     */\n    //% blockId=\"device_random\" block=\"pick random %min|to %limit\"\n    //% helpUrl=\"/reference/math/random-range\"\n    //% shim=Math_::randomRange\n    function randomRange(min: number, max: number): number;\n\n    /**\n     * Returns the natural logarithm (base e) of a number.\n     * @param x A number\n     */\n    //% shim=Math_::log\n    function log(x: number): number;\n\n    /**\n     * Returns returns ``e^x``.\n     * @param x A number\n     */\n    //% shim=Math_::exp\n    function exp(x: number): number;\n\n    /**\n     * Returns the sine of a number.\n     * @param x An angle in radians\n     */\n    //% shim=Math_::sin\n    function sin(x: number): number;\n\n    /**\n     * Returns the cosine of a number.\n     * @param x An angle in radians\n     */\n    //% shim=Math_::cos\n    function cos(x: number): number;\n\n    /**\n     * Returns the tangent of a number.\n     * @param x An angle in radians\n     */\n    //% shim=Math_::tan\n    function tan(x: number): number;\n\n    /**\n     * Returns the arcsine (in radians) of a number\n     * @param x A number\n     */\n    //% shim=Math_::asin\n    function asin(x: number): number;\n\n    /**\n     * Returns the arccosine (in radians) of a number\n     * @param x A number\n     */\n    //% shim=Math_::acos\n    function acos(x: number): number;\n\n    /**\n     * Returns the arctangent (in radians) of a number\n     * @param x A number\n     */\n    //% shim=Math_::atan\n    function atan(x: number): number;\n\n    /**\n     * Returns the arctangent of the quotient of its arguments.\n     * @param y A number\n     * @param x A number\n     */\n    //% shim=Math_::atan2\n    function atan2(y: number, x: number): number;\n\n    /**\n     * Returns the square root of a number.\n     * @param x A numeric expression.\n     */\n    //% shim=Math_::sqrt\n    function sqrt(x: number): number;\n\n    /**\n     * Returns the smallest number greater than or equal to its numeric argument.\n     * @param x A numeric expression.\n     */\n    //% shim=Math_::ceil\n    function ceil(x: number): number;\n\n    /**\n      * Returns the greatest number less than or equal to its numeric argument.\n      * @param x A numeric expression.\n      */\n    //% shim=Math_::floor\n    function floor(x: number): number;\n\n    /**\n      * Returns the number with the decimal part truncated.\n      * @param x A numeric expression.\n      */\n    //% shim=Math_::trunc\n    function trunc(x: number): number;\n\n    /**\n      * Returns a supplied numeric expression rounded to the nearest number.\n      * @param x The value to be rounded to the nearest number.\n      */\n    //% shim=Math_::round\n    function round(x: number): number;\n\n    /**\n     * Returns the value of integer signed 32 bit multiplication of two numbers.\n     * @param x The first number\n     * @param y The second number\n     */\n    //% shim=Math_::imul\n    function imul(x: number, y: number): number;\n\n    /**\n     * Returns the value of integer signed 32 bit division of two numbers.\n     * @param x The first number\n     * @param y The second number\n     */\n    //% shim=Math_::idiv\n    function idiv(x: number, y: number): number;\n}\n",
      "pxt-helpers.ts": "type Action = () => void;\n\nnamespace helpers {\n    export function arraySplice<T>(arr: T[], start: number, len: number) {\n        if (start < 0) {\n            return;\n        }\n        for (let i = 0; i < len; ++i) {\n            arr.removeAt(start)\n        }\n    }\n\n    export function arrayReverse<T>(arr: T[]): void {\n        let len = arr.length;\n        for (let i = 0; i < len / 2; i++) {\n            swap(arr, i, len - i - 1);\n        }\n    }\n\n    export function arrayShift<T>(arr: T[]): T {\n        return arr.removeAt(0);\n    }\n\n    /*TODO: Enable this multiple value unshift, after rest is enabled in our compiler.\n        export function arrayUnshift<T>(arr: T[], ...values: T[]) : number {\n            for(let i = values.length; i > 0; --i) {\n                arr.insertAt(0, values[i - 1]);\n            }\n            return arr.length;\n        }\n    */\n    export function arrayUnshift<T>(arr: T[], value: T): number {\n        arr.insertAt(0, value);\n        return arr.length;\n    }\n\n    function swap<T>(arr: T[], i: number, j: number): void {\n        let temp: T = arr[i];\n        arr[i] = arr[j];\n        arr[j] = temp;\n    }\n\n    function sortHelper<T>(arr: T[], callbackfn?: (value1: T, value2: T) => number): T[] {\n        if (arr.length <= 0 || !callbackfn) {\n            return arr;\n        }\n        let len = arr.length;\n        // simple selection sort.\n        for (let i = 0; i < len - 1; ++i) {\n            for (let j = i + 1; j < len; ++j) {\n                if (callbackfn(arr[i], arr[j]) > 0) {\n                    swap(arr, i, j);\n                }\n            }\n        }\n        return arr;\n    }\n\n    export function arraySort<T>(arr: T[], callbackfn?: (value1: T, value2: T) => number): T[] {\n        if (!callbackfn) {\n            //TODO: support native strings and number sorting\n            /* callbackfn = function (value1: string, value2: string) : number {\n                return value1.compare(value2);\n                }*/\n        }\n        return sortHelper(arr, callbackfn);\n    }\n\n    export function arrayMap<T, U>(arr: T[], callbackfn: (value: T, index: number) => U): U[] {\n        let res: U[] = []\n        let len = arr.length // caching this seems to match V8\n        for (let i = 0; i < len; ++i) {\n            res.push(callbackfn(arr[i], i))\n        }\n        return res\n    }\n\n    export function arrayFilter<T>(arr: T[], callbackfn: (value: T, index: number) => boolean): T[] {\n        let res: T[] = []\n        let len = arr.length\n        for (let i = 0; i < len; ++i) {\n            let v = arr[i] // need to cache\n            if (callbackfn(v, i)) res.push(v)\n        }\n        return res\n    }\n\n    export function arrayReduce<T, U>(arr: T[], callbackfn: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): U {\n        let len = arr.length\n        for (let i = 0; i < len; ++i) {\n            initialValue = callbackfn(initialValue, arr[i], i)\n        }\n        return initialValue\n    }\n\n    export function arraySlice<T>(arr: T[], start: number, end: number): T[] {\n        const res: T[] = [];\n        const len = arr.length;\n\n        if (start < 0) {\n            start = Math.max(len + start, 0);\n        }\n\n        if (end < 0) {\n            end = len + end;\n        }\n\n        const sliceLength = end - start;\n\n        for (let i = 0; i < sliceLength; ++i) {\n            const index = i + start;\n            if (index >= len) {\n                break;\n            }\n            res.push(arr[index]);\n        }\n        return res;\n    }\n}\n\nnamespace Math {\n    export function clamp(min: number, max: number, value: number): number {\n        return Math.min(max, Math.max(min, value));\n    }\n\n    /**\n      * Returns the absolute value of a number (the value without regard to whether it is positive or negative).\n      * For example, the absolute value of -5 is the same as the absolute value of 5.\n      * @param x A numeric expression for which the absolute value is needed.\n      */\n    export function abs(x: number): number {\n        return x < 0 ? -x : x;\n    }\n\n    /**\n      * Returns the sign of the x, indicating whether x is positive, negative or zero.\n      * @param x The numeric expression to test\n      */\n    export function sign(x: number): number {\n        if (x == 0) return 0;\n        if (x > 0) return 1;\n        return -1;\n    }\n\n    /**\n      * Returns the larger of two supplied numeric expressions.\n      */\n    export function max(a: number, b: number): number {\n        if (a >= b) return a;\n        return b;\n    }\n\n    /**\n      * Returns the smaller of two supplied numeric expressions.\n      */\n    export function min(a: number, b: number): number {\n        if (a <= b) return a;\n        return b;\n    }\n}\n",
      "pxt.json": "{\n    \"name\": \"core\",\n    \"description\": \"A target sample for PXT\",\n    \"files\": [\n        \"README.md\",\n        \"pxt-core.d.ts\",\n        \"pxt-helpers.ts\",\n        \"enums.d.ts\",\n        \"sims.d.ts\",\n        \"ns.ts\"\n    ],\n    \"testFiles\": [\n        \"test.ts\"\n    ],\n    \"public\": true,\n    \"dependencies\": {}\n}",
      "sims.d.ts": "// Auto-generated from simulator. Do not edit.\ndeclare namespace loops {\n    // /**\n    //  * Repeats the code forever in the background. On each iteration, allows other code to run.\n    //  * @param body the code to repeat\n    //  */\n    // //% help=functions/forever weight=55 blockGap=8\n    // //% blockId=device_forever block=\"forever\"\n    // export function forever(body: RefAction): void {\n    //     thread.forever(body)\n    // }\n    /**\n     * Pause for the specified time in milliseconds\n     * @param ms how long to pause for, eg: 100, 200, 500, 1000, 2000\n     */\n    //% help=functions/pause weight=54\n    //% block=\"pause (ms) %pause\" blockId=device_pause\n    //% shim=loops::pauseAsync promise\n    function pause(ms: number): void;\n\n}\ndeclare namespace LRFEyeMessages {\n    /** Blinks the plugged in pattern on the robot's eyes. */\n    //% blockId=blink_pattern block=\"blink pattern: %pattern\"\n    //% weight=160\n    //% shim=LRFEyeMessages::blinkPattern\n    function blinkPattern(pattern: LRFPattern): void;\n\n    /** Blinks the plugged in array of patterns on the robot's eyes. */\n    //% blockId=blink_patterns block=\"blink patterns: %patterns\"\n    //% weight=150\n    //% shim=LRFEyeMessages::blinkPatterns\n    function blinkPatterns(patterns: LRFPattern[]): void;\n\n    /** Changes the color of the eyes using a boomerang, zigzag, flat, flip, or random pattern. */\n    //% block\n    //% weight=140\n    //% shim=LRFEyeMessages::pattern\n    function pattern(startColor: LRFColour, endColor: LRFColour, boomerang: boolean, zigzag: boolean, flat: boolean, flip: boolean, random: boolean, duration: LRFDuration): LRFPattern;\n\n    /** Changes the eyes color from start to end using a fade pattern. */\n    //% blockId=basic_pattern block=\"pattern with start: %startColor | end: %endColor | duration: %duration\"\n    //% weight=140\n    //% shim=LRFEyeMessages::basicPattern\n    function basicPattern(startColor: LRFColour, endColor: LRFColour, duration: LRFDuration): LRFPattern;\n\n    /**\n     * Sets the color of both your LRF's eyes.\n     */\n    //% blockId=set_eye_color_both block=\"set eyes to color: %color\" weight=130\n    //% shim=LRFEyeMessages::setEyeColorBoth\n    function setEyeColorBoth(color: LRFColour): void;\n\n    /**\n     * Sets the colors for your LRF's eyes\n     * @param left\n     * @param right\n     */\n    //% block\n    //% weight=120\n    //% shim=LRFEyeMessages::setEyeColors\n    function setEyeColors(left: LRFColour, right: LRFColour): void;\n\n    /**\n     */\n    //% blockId=color_block\n    //% block=\"%color=LRFColour\"\n    //% weight=120\n    //% shim=LRFEyeMessages::color\n    function color(color: LRFColour): LRFColour;\n\n    /**\n     * Sets the color of both eyes using an 'rgb color' value\n     * @param rgb\n     */\n    //% blockId=set_eye_rgb_left\n    //% block=\"set eyes to rgb: %rgb\" weight=110\n    //% shim=LRFEyeMessages::setEyesRbg\n    function setEyesRbg(rgb: LRFRgbColour): void;\n\n    /**\n     * Sets the color of your LRF's eyes using 'rgb color' values\n     * @param left\n     * @param right\n     */\n    //% blockId=set_eyes_rgb\n    //% block=\"set 'rgb color' for left eye: %left | and right eye: %right\" weight=104\n    //% blockExternalInputs=true\n    //% weight=100\n    //% shim=LRFEyeMessages::setEyeRGB\n    function setEyeRGB(left: LRFRgbColour, right: LRFRgbColour): void;\n\n    /**\n     * Defines an RGB color. Use \"red\", \"green\", and \"blue\" to define how much of each color you want to mix. Each color can be between 0 and 255\n     * @param red [0-255]; eg: 255, 100, 0\n     * @param green [0-255]; eg: 255, 100, 0\n     * @param blue [0-255]; eg: 255, 100, 0\n     */\n    //% blockId=rgb_color\n    //% block=\"rgb color | red: %red | green: %green | blue: %blue\"\n    //% blockExternalInputs=true\n    //% weight=90\n    //% shim=LRFEyeMessages::rgbColor\n    function rgbColor(red: number, green: number, blue: number): LRFRgbColour;\n\n    /**\n     * Sets both eye colors to none.\n     */\n    //% block weight=80\n    //% shim=LRFEyeMessages::turnEyesOff\n    function turnEyesOff(): void;\n\n}\ndeclare namespace LRFSoundMessages {\n    /**\n     * Say a sound\n     * @param sound\n     */\n    //%blockId=\"say_single_sound\" block=\"say a sound: %sound\" weight=102\n    //% shim=LRFSoundMessages::saySound\n    function saySound(sound: LRFSound): void;\n\n    /**\n     * Say a set of sounds in order. Create a variable and set it to an array of sounds.\n     * @param sounds\n     */\n    //% blockId=\"say_multi_sounds\" block=\"say some sounds: %sounds\"  weight=101\n    //% shim=LRFSoundMessages::saySounds\n    function saySounds(sounds: LRFSound[]): void;\n\n    /**\n     * Describes a sound object. Define the note, its octave, intonation, duration, and the pause after it.\n     * @param note\n     * @param octave\n     * @param intonation\n     * @param duration\n     * @param pause\n     */\n    //% blockId=\"sound\" block=\"sound | note:%note|octave:%octave|intonation:%intonation|duration:%duration|pause:%pause\" weight=100\n    //% shim=LRFSoundMessages::sound\n    function sound(note: LRFNote, octave: LRFOctave, intonation: LRFIntonation, duration: LRFDuration, pause: LRFDuration): LRFSound;\n\n    /**\n     * Sounds a frequency on the speaker in Hertz (Hz).\n     * @param freq the frequency to play; eg: 440\n     */\n    //% blockId=\"sound_freq\" block=\"set speaker to frequency:%freq\" weight=90\n    //% shim=LRFSoundMessages::setSpeakerToFrequency\n    function setSpeakerToFrequency(freq: number): void;\n\n    /**\n     * Sets the speaker frequency to 0.\n     */\n    //% block weight=80\n    //% shim=LRFSoundMessages::turnOffSpeaker\n    function turnOffSpeaker(): void;\n\n}\ndeclare namespace LRFExpressions {\n    /** Play one of the built-in hello expressions */\n    //% block\n    //% shim=LRFExpressions::doHello\n    function doHello(expression: LRFHelloExpression): void;\n\n    /** Play one of the built-in mood expressions */\n    //% block\n    //% shim=LRFExpressions::doMood\n    function doMood(expression: LRFMoodExpression): void;\n\n    /** Play one of the built-in test expressions */\n    //% block\n    //% shim=LRFExpressions::doTest\n    function doTest(expression: LRFMoodExpression): void;\n\n    /** Play one of the built-in laugh expressions */\n    //% block\n    //% shim=LRFExpressions::doLaugh\n    function doLaugh(expression: LRFLaughExpression): void;\n\n    /** Play one of the built-in cry expressions */\n    //% block\n    //% shim=LRFExpressions::doCry\n    function doCry(expression: LRFCryExpression): void;\n\n    /** Play one of the built-in scared expressions */\n    //% block\n    //% shim=LRFExpressions::doScared\n    function doScared(expression: LRFScaredExpression): void;\n\n    /** Play one of the built-in sleepy expressions */\n    //% block\n    //% shim=LRFExpressions::doSleepy\n    function doSleepy(expression: LRFSleepyExpression): void;\n\n    /** Play one of the built-in system expressions */\n    //% block\n    //% shim=LRFExpressions::doSystem\n    function doSystem(expression: LRFSystemExpression): void;\n\n    /** Play one of the built-in whoa expressions */\n    //% block\n    //% shim=LRFExpressions::doWhoa\n    function doWhoa(expression: LRFMiscExpression): void;\n\n    /** Plays the plugged in custom expression on the robot */\n    //% block\n    //% weight=150\n    //% shim=LRFExpressions::blinkAndSayExpression\n    function blinkAndSayExpression(expression: SoundCollection): void;\n\n    /** A custom expression made of up to 4 sounds and a pattern. */\n    //% block\n    //% weight=140\n    //% shim=LRFExpressions::expression\n    function expression(pattern: LRFPattern, sound1: LRFSound, sound2: LRFSound, sound3: LRFSound, sound4: LRFSound): SoundCollection;\n\n}\ndeclare namespace LRFInputEvents {\n    /** Code inside this block will run when the robot's hair is tapped, touched, or tickled. Choose which one in the dropdown */\n    //% blockId=on_hair_touched block=\"on hair %type\" weight=205\n    //% shim=LRFInputEvents::onHairTouchedEvent\n    function onHairTouchedEvent(type: LRFTouchEventType, body: () => void): void;\n\n    /** Code inside this block will run when the robot's left hand is tapped, touched, or tickled. Choose which one in the dropdown */\n    //% blockId=on_hand_touched_left block=\"on left hand %type\" weight=204\n    //% shim=LRFInputEvents::onHandTouchedLeft\n    function onHandTouchedLeft(type: LRFTouchEventType, body: () => void): void;\n\n    /** Code inside this block will run when the robot's right hand is tapped, touched, or tickled. Choose which one in the dropdown */\n    //% blockId=on_hand_touched_right block=\"on right hand %type\" weight=203\n    //% shim=LRFInputEvents::onHandTouchedRight\n    function onHandTouchedRight(type: LRFTouchEventType, body: () => void): void;\n\n    /** Code inside this block will run when the robot hears a normal or loud sound. Choose the type in the dropdown. */\n    //% blockId=on_sound_detected block=\"on sound %type\" weight=202\n    //% shim=LRFInputEvents::onSoundDetected\n    function onSoundDetected(type: LRFSoundSensorEventType, body: () => void): void;\n\n    /** Code inside this block will run when the robot detects a level of light. Choose which kind of light to detect in the dropdown */\n    //% blockId=on_light_detected block=\"on light %type\" weight=201\n    //% shim=LRFInputEvents::onLightType\n    function onLightType(type: LRFLightSensorEventType, body: () => void): void;\n\n    /** Code inside this block will run when the robot detects some motion. Choose which type of motion in the dropdown */\n    //% blockId=on_motion block=\"on motion %type\" weight=200\n    //% shim=LRFInputEvents::onMotion\n    function onMotion(type: LRFMotionSensorEventType, body: () => void): void;\n\n    // //% blockId=on_hungry block=\"on hungry\" weight=101\n    // export function onHungry(body: RefAction) {\n    //     pxtcore.registerWithBoard(LRFInputs.brainSensor, LRFBrainSensorEventType.hungry, body);\n    // }\n    // //% blockId=on_bored block=\"on bored\" weight=100\n    // export function onBored(body: RefAction) {\n    //     pxtcore.registerWithBoard(LRFInputs.brainSensor, LRFBrainSensorEventType.bored, body);\n    // }\n    /**\n     * ADD DESCRIPTION PLZ\n     */\n    //% blockId=touch_read\n    //% block=\"read touch sensor %channel\" weight=104\n    //% shim=LRFInputEvents::touchRead\n    function touchRead(channel: LRFTouchSensorChannel): number;\n\n    /**\n     * ADD DESCRIPTION PLZ\n     */\n    //% blockId=hearing_read\n    //% block=\"read microphone\"\n    //% weight=90\n    //% shim=LRFInputEvents::hearingRead\n    function hearingRead(): number;\n\n    /**\n     * ADD DESCRIPTION PLZ\n     */\n    //% blockId=sight_read\n    //% block=\"read photocell\"\n    //% weight=90\n    //% shim=LRFInputEvents::sightRead\n    function sightRead(): number;\n\n    /**\n     * ADD DESCRIPTION PLZ\n     */\n    //% blockId=motion_read\n    //% block=\"read accelerometer %channel\"\n    //% weight=90\n    //% shim=LRFInputEvents::motionRead\n    function motionRead(channel: LRFMotionSensorChannel): number;\n\n}\ndeclare namespace console {\n    /**\n     * Print out message\n     */\n    //%\n    //% shim=console::log\n    function log(msg: string): void;\n\n}\n    //%\n    declare class LRFRgbColour {\n    }\n    //%\n    declare class LRFSound {\n    }\n    //%\n    declare class LRFPattern {\n    }\n    //%\n    declare class SoundCollection {\n    }\n\n// Auto-generated. Do not edit. Really.\n",
      "test.ts": ""
    }
  },
  "compile": {
    "isNative": false,
    "hasHex": false,
    "floatingPoint": true
  },
  "versions": {
    "target": "0.9.0-beta",
    "pxt": "1.8.15"
  }
}