webpackJsonpLRFWebcore([1],{

/***/ 13:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _LRFWebCoreEvents = __webpack_require__(1);

var _LRFWebCoreEvents2 = _interopRequireDefault(_LRFWebCoreEvents);

var _LRFSerial = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ChromeSerialAdapter = function () {
  function ChromeSerialAdapter(chromeSerial, options) {
    _classCallCheck(this, ChromeSerialAdapter);

    this.serial = chromeSerial;
    if (options.onReceiveCB !== undefined) this.setOnReceive(options.onReceiveCB);
    if (options.onDisconnectCB !== undefined) this.setOnDisconnect(options.onDisconnectCB);
  }

  /* Chrome Devices
  {
    path: ,
    vendorId,
    productId,
    displayName: human readable display name (probably Little Robot Friends), probably same as manufacturer
  }
  */

  _createClass(ChromeSerialAdapter, [{
    key: "setOnReceive",
    value: function setOnReceive(callback) {
      if (callback) this.onReceiveCB = callback;
    }
  }, {
    key: "setOnDisconnect",
    value: function setOnDisconnect(callback) {
      if (callback) this.onDisconnectCB = callback;
    }
  }, {
    key: "isConnectionChildOfStore",
    value: function isConnectionChildOfStore(connectionId, connectionStore) {
      return connectionId === connectionStore.connectionId;
    }
  }, {
    key: "getDevices",
    value: function getDevices() {
      var _this = this;

      console.log("getting serial devices");

      return new Promise(function (resolve, reject) {
        _this.serial.getDevices(function (devices) {
          if (devices.length) {
            devices.forEach(function (device) {
              device.comName = device.path;
            });
            resolve(devices);
          } else {
            reject(new Error("No devices were found"));
          }
        });
      });
    }

    //chrome only

  }, {
    key: "onReceiveError",
    value: function onReceiveError(info) {
      var rawConnection = info.connectionId;
      var error = info.error;

      var onDisconnect = this.onDisconnect;

      var errorHandlers = {
        "disconnected": onDisconnect,
        "device_lost": onDisconnect,
        "default": function _default(err) {
          console.error(err);
        }
      };

      (errorHandlers[info.error] || errorHandlers["default"]).call(this, error, rawConnection);
    }
  }, {
    key: "onReceive",
    value: function onReceive(info) {
      var buffer = info.data;
      var connectionId = info.connectionId;
      if (this.onReceiveCB) this.onReceiveCB(buffer, connectionId);
    }
  }, {
    key: "onDisconnect",
    value: function onDisconnect(err, rawConnection) {
      if (this.onDisconnectCB) this.onDisconnectCB(err, rawConnection);

      //Remove listeners
      if (this.serial.onReceive.hasListeners()) {
        this.serial.onReceive.removeListener(this.boundOnReceive);
        this.serial.onReceiveError.removeListener(this.boundOnReceiveError);
      }
    }
  }, {
    key: "connect",
    value: function connect(device, connectionStore) {
      var _this2 = this;

      delete connectionStore.connectionOptions.baudRate;

      return new Promise(function (resolve, reject) {
        _this2.serial.connect(device.path, connectionStore.connectionOptions, function (connectionInfo) {
          if (connectionInfo) {
            console.log("Connected on " + device.path);
            console.log("Connection ID: " + connectionInfo.connectionId);
            connectionStore.connectionId = connectionInfo.connectionId;
            connectionStore.devicePath = device.path;
            connectionStore.device = device;
            console.log("Chrome\'s connection device object: ", device);
            if (_this2.serial.onReceive.hasListeners() === false) {
              _this2.boundOnReceive = _this2.onReceive.bind(_this2);
              _this2.serial.onReceive.addListener(_this2.boundOnReceive);
            }
            if (_this2.serial.onReceiveError.hasListeners() === false) {
              _this2.boundOnReceiveError = _this2.onReceiveError.bind(_this2);
              _this2.serial.onReceiveError.addListener(_this2.boundOnReceiveError);
            }
            resolve(connectionStore);
          } else {
            reject(new Error("Serial connection on" + device.path + "failed."));
          }
        });
      });
    }

    //GOOD

  }, {
    key: "send",
    value: function send(arrayBuffer, connection) {
      this.serial.send(connection.connectionId, arrayBuffer, function () {});
    }

    //GOOD
    //[cb optional]

  }, {
    key: "disconnect",
    value: function disconnect(connection) {
      this.serial.disconnect(connection.connectionId, function () {
        connection.connectionId = 0;
        connection.devicePath = "";
        // LRFRootScope.emit(EVENT.DISCONNECTED);
      });
    }

    //TODO: needs testing

  }, {
    key: "enterBootLoader",
    value: function enterBootLoader(connection, cb) {
      var _this3 = this;

      console.log("enterBootLoader - _connection: ", JSON.parse(JSON.stringify(connection)));
      this.serial.update(connection.connectionId, {
        bitrate: 1200
      }, function (wasUpdated) {
        if (wasUpdated) {
          _this3.disconnect(connection);
          if (cb) cb();
        }
      });
    }
  }]);

  return ChromeSerialAdapter;
}();

exports.default = ChromeSerialAdapter;
module.exports = exports["default"];

/***/ })

});