# Next steps

### Intro

For fun, let's make our robot blink two different colors! Let's start by giving our bot one green eye and one red eye. We'll then switch between the two when we tap its hair. Add a ``||LRFEyeMessages:set eye colors||`` block in ``||basic:on start||`` and set the left eye to green and the right eye to red.

```blocks
LRFEyeMessages.setEyeColors(LRFColour.green, LRFColour.red)
```

### Set the trigger

The next thing we need to do is add a trigger, so let's put a ``||LRFInputEvents:on hair||`` block from ``||LRFInputEvents:Sensor Actions||`` and set it to ``||LRFInputEvents:tapped||``. This will trigger our code when we tap the bot's hair!

```blocks
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {

})
```

### Loops

That's great! Let's add a ``||loops:loop||``. Blocks inside a ``||loops:loop||`` will run as many times as the loop says! Add a ``||loops:repeat||`` block into ``||LRFInputEvents:on hair||`` and change the ``||loops:times||`` value to 10.

```blocks
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {

    }
})
```

### Variable

In order to switch the colours our code needs to keep track using a ``||Variables:variable||``. Open ``||Variables:variables||`` and click ``||Make a Variable||``. Call your new variable "switch".

### Set the variable

Open ``||Variables||`` and add a ``||set item to||`` block to ``||on start||`` and select ``||switch||`` from the dropdown. Then, open ``||Logic:Logic||`` and plug in a ``||Logic:false||`` block.

```blocks
let _switch = false
```

### The if statement

Our trigger needs to know if ``||switch||`` is ``||true||`` or ``||false||``. We do this using an ``||if-then-else||`` block. Add an ``||if-then-else||`` block from ``||Logic||`` into the ``||repeat||`` block.

 ```blocks
 LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    if (true) {

    } else {

    }
})
```

### The conditional

The ``||if-then-else||`` will check if our ``||switch||`` variable is true or not. Everything in the ``||then||`` part of the block executes when true, and everything in the ``||else||`` part executes when false. We need to add a ``||conditional||`` for the block to check. (Click Next)

### Add the conditional

Plug in a ``||0 = 0||`` block from ``||Logic||`` into our ``||if-then-else||`` block. From ``||Variables||`` plug ``||switch||`` in the first spot, and from ``||Logic||`` plug a ``||false||`` block into the second.

```blocks
let _switch = false;
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {
        if (_switch == false) {

        } else {

        }
    }
})
```

### Change the eye colour

We're ready to change the eyes! In the ``||then||`` part of our ``||if-then-else||`` block, add a ``||LRFEyeMessages:set eye colours||`` block and set the left eye to red and the right eye to green. Do the same for the ``||else||`` part and switch the eye colours. If we tap the hair not much happens, but we can fix that next!

```blocks
let _switch = false;
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {
        if (_switch == false) {
            LRFEyeMessages.setEyeColours(LRFColour.red, LRFColour.green)
        } else {
            LRFEyeMessages.setEyeColours(LRFColour.green, LRFColour.red)
        }
    }
})
```

### Switch the switch

We need to change our ``||switch||`` variable so the ``||if-then-else||`` block will run the ``||then||`` when true and ``||else||`` when false. In the ``||then||`` part add blocks to change ``||switch||`` to true. In the ``||else||`` part add blocks to change ``||switch||`` to false. Still not working? Let's fix that next!

```blocks
let _switch = false;
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {
        if (_switch == false) {
            LRFEyeMessages.setEyeColours(LRFColour.red, LRFColour.green)
            _switch = true
        } else {
            LRFEyeMessages.setEyeColours(LRFColour.green, LRFColour.red)
            _switch = false
        }
    }
})
```

### The pause

Computers think very quickly so it might look like nothings happening but our code is just running really fast! We can add a ``||pause||`` block from ``||Loops||`` to make our bot take a break. Add a ``||pause||`` block at the bottom of our loop. Now the eyes will switch colours! Tap the hair to see!


```blocks
let _switch = false;
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {
        if (_switch == false) {
            LRFEyeMessages.setEyeColours(LRFColour.red, LRFColour.green)
            _switch = true
        } else {
            LRFEyeMessages.setEyeColours(LRFColour.green, LRFColour.red)
            _switch = false
        }
        loops.pause(100);
    }
})
```

### End

Congrats! You made the bot's eyes blink two different colours! (Click the hint if you want a little bit more).

If you want, we can clean up our code a bit. Programmers like us like to make things short and easy. In our ``||if-then-else||`` block we don't need a fancy ``||0 = 0||`` conditional. Since a conditional is true or false, just like our ``||switch||`` variable we can simply use that! We can also cheat a little using something called the ``||not operator||``. We can delete the two blocks where we change ``||switch||`` to true/false and, after the pause, add a ``||set switch to||`` block. Instead of adding ``||true||`` or ``||false||`` we can use a ``||not||`` block from ``||Logic||`` and plug in ``||switch||`` to set it to its opposite.

```blocks
let _switch = false;
LRFInputEvents.onHairTouchedEvent(LRFTouchEventType.tapped, function () {
    for (let i = 0; i < 10; i++) {
        if (_switch) {
            LRFEyeMessages.setEyeColours(LRFColour.red, LRFColour.green)
        } else {
            LRFEyeMessages.setEyeColours(LRFColour.green, LRFColour.red)
        }
        _switch = !_switch
        loops.pause(100);
    }
})
```

This does the same thing, but with fewer blocks, or "lines of code"!
