/// <reference path="../typings/globals/bluebird/index.d.ts" />
/// <reference path="../localtypings/monaco.d.ts" />
/// <reference path="pxtlib.d.ts" />
declare namespace pxt.editor {
    interface IEditor {
        undo(): void;
        redo(): void;
        hasUndo(): boolean;
        hasRedo(): boolean;
        zoomIn(): void;
        zoomOut(): void;
        resize(): void;
    }
    interface IFile {
        name: string;
    }
    interface FileHistoryEntry {
        id: string;
        name: string;
        pos: any;
    }
    interface EditorSettings {
        editorFontSize: number;
        fileHistory: FileHistoryEntry[];
    }
    interface IAppProps {
    }
    interface IAppState {
        active?: boolean;
        header?: pxt.workspace.Header;
        filters?: pxt.editor.ProjectFilters;
        currFile?: IFile;
        fileState?: string;
        showFiles?: boolean;
        sideDocsLoadUrl?: string;
        sideDocsCollapsed?: boolean;
        projectName?: string;
        tutorialOptions?: TutorialOptions;
        hintShown?: boolean;
        running?: boolean;
        compiling?: boolean;
        isSaving?: boolean;
        publishing?: boolean;
        hideEditorFloats?: boolean;
        collapseEditorTools?: boolean;
        showBlocks?: boolean;
        showParts?: boolean;
        fullscreen?: boolean;
        mute?: boolean;
        embedSimView?: boolean;
        tracing?: boolean;
        highContrast?: boolean;
    }
    interface ProjectCreationOptions {
        prj?: pxt.ProjectTemplate;
        name?: string;
        documentation?: string;
        filesOverride?: pxt.Map<string>;
        filters?: ProjectFilters;
        temporary?: boolean;
    }
    interface ProjectFilters {
        namespaces?: {
            [index: string]: FilterState;
        };
        blocks?: {
            [index: string]: FilterState;
        };
        fns?: {
            [index: string]: FilterState;
        };
        defaultState?: FilterState;
    }
    enum FilterState {
        Hidden = 0,
        Visible = 1,
        Disabled = 2,
    }
    interface TutorialStepInfo {
        fullscreen?: boolean;
        hasHint?: boolean;
        content?: string;
        headerContent?: string;
    }
    interface TutorialOptions {
        tutorial?: string;
        tutorialName?: string;
        tutorialSteps?: string[];
        tutorialStepInfo?: TutorialStepInfo[];
        tutorialStep?: number;
        tutorialReady?: boolean;
    }
    interface IProjectView {
        state: IAppState;
        setState(st: IAppState): void;
        forceUpdate(): void;
        openBlocks(): void;
        openJavaScript(): void;
        openPreviousEditor(): void;
        switchTypeScript(): void;
        openTypeScriptAsync(): Promise<void>;
        saveBlocksToTypeScriptAsync(): Promise<string>;
        saveFileAsync(): Promise<void>;
        loadHeaderAsync(h: pxt.workspace.Header): Promise<void>;
        reloadHeaderAsync(): Promise<void>;
        importProjectAsync(prj: pxt.workspace.Project, filters?: pxt.editor.ProjectFilters): Promise<void>;
        overrideTypescriptFile(text: string): void;
        exportAsync(): Promise<string>;
        newEmptyProject(name?: string, documentation?: string): void;
        newProject(options?: ProjectCreationOptions): void;
        createProjectAsync(options: ProjectCreationOptions): Promise<void>;
        importFileDialog(): void;
        importUrlDialog(): void;
        removeProject(): void;
        editText(): void;
        getPreferredEditor(): string;
        saveAndCompile(): void;
        updateHeaderName(name: string): void;
        compile(): void;
        setFile(fn: IFile): void;
        setSideFile(fn: IFile): void;
        setSideDoc(path: string, blocksEditor?: boolean): void;
        setSideMarkdown(md: string): void;
        removeFile(fn: IFile, skipConfirm?: boolean): void;
        updateFileAsync(name: string, content: string, open?: boolean): Promise<void>;
        openTutorials(): void;
        setTutorialStep(step: number): void;
        exitTutorial(keep?: boolean): void;
        completeTutorial(): void;
        showTutorialHint(): void;
        gettingStarted(): void;
        anonymousPublishAsync(): Promise<string>;
        startStopSimulator(): void;
        stopSimulator(unload?: boolean): void;
        restartSimulator(): void;
        startSimulator(): void;
        runSimulator(): void;
        expandSimulator(): void;
        collapseSimulator(): void;
        toggleSimulatorCollapse(): void;
        proxySimulatorMessage(content: string): void;
        toggleTrace(intervalSpeed?: number): void;
        startTutorial(tutorialId: string): void;
        addPackage(): void;
        typecheckNow(): void;
        fireResize(): void;
        isBlocksEditor(): boolean;
        isTextEditor(): boolean;
        renderBlocksAsync(req: EditorMessageRenderBlocksRequest): Promise<string>;
        convertTouchDevelopToTypeScriptAsync(td: string): Promise<string>;
        settings: EditorSettings;
        editor: IEditor;
    }
    interface IHexFileImporter {
        id: string;
        canImport(data: pxt.cpp.HexFile): boolean;
        importAsync(project: IProjectView, data: pxt.cpp.HexFile): Promise<void>;
    }
    interface IResourceImporter {
        id: string;
        canImport(data: File): boolean;
        importAsync(project: IProjectView, data: File): Promise<void>;
    }
    interface ISettingsProps {
        parent: IProjectView;
        visible?: boolean;
    }
    interface IFieldCustomOptions {
        selector: string;
        editor: Blockly.FieldCustomConstructor;
        text?: string;
        validator?: any;
    }
    interface ExtensionOptions {
    }
    interface IToolboxOptions {
        blocklyXml?: string;
        monacoToolbox?: MonacoToolboxDefinition;
    }
    interface ExtensionResult {
        hexFileImporters?: IHexFileImporter[];
        resourceImporters?: IResourceImporter[];
        beforeCompile?: () => void;
        deployCoreAsync?: (resp: pxtc.CompileResult) => Promise<void>;
        fieldEditors?: IFieldCustomOptions[];
        toolboxOptions?: IToolboxOptions;
    }
    interface MonacoToolboxDefinition {
        loops?: MonacoToolboxCategoryDefinition;
        logic?: MonacoToolboxCategoryDefinition;
        variables?: MonacoToolboxCategoryDefinition;
        maths?: MonacoToolboxCategoryDefinition;
        text?: MonacoToolboxCategoryDefinition;
        arrays?: MonacoToolboxCategoryDefinition;
        functions?: MonacoToolboxCategoryDefinition;
    }
    interface MonacoToolboxCategoryDefinition {
        /**
         * The display name for the category
         */
        name?: string;
        /**
         * The weight of the category relative to other categories in the toolbox
         */
        weight?: number;
        /**
         * Whether or not the category should be placed in the advanced category
         */
        advanced?: boolean;
        /**
         * Whether or not the category should be removed
         */
        removed?: boolean;
        /**
         * Blocks to appear in the category. Specifying this field will override
         * all existing blocks in the category. The ordering of the blocks is
         * determined by the ordering of this array.
         */
        blocks?: MonacoToolboxBlockDefinition[];
        /**
         * Whether or not to replace or append blocks
         */
        appendBlocks?: boolean;
    }
    interface MonacoToolboxBlockDefinition {
        /**
         * Name of the API or construct, used in highlighting of snippet. For function
         * calls, should match the name of the function
         */
        name: string;
        /**
         * Snippet of code to insert when dragged into editor
         */
        snippet: string;
        /**
         * Group label used to categorize block.  Blocks are arranged with other
         * blocks that share the same group.
         */
        group?: string;
        /**
         * Description of code to appear in the hover text
         */
        jsDoc?: string;
        /**
         * Display just the snippet and nothing else. Should be set to true for
         * language constructs (eg. for-loops) and to false for function
         * calls (eg. Math.random())
         */
        snippetOnly?: boolean;
        /**
         * Indicates an advanced API. Advanced APIs appear after basic ones in the
         * toolbox
         */
        advanced?: boolean;
        /**
         * The weight for the block. Blocks are arranged in order of they appear in the category
         * definition's array but the weight can be specified in the case that other APIs are
         * dynamically added to the category (eg. loops.forever())
         */
        weight?: number;
    }
    let initExtensionsAsync: (opts: ExtensionOptions) => Promise<ExtensionResult>;
}
declare namespace pxt.editor {
    interface EditorMessage {
        /**
         * Constant identifier
         */
        type: "pxteditor" | "pxthost";
        /**
         * Original request id
         */
        id?: string;
        /**
         * flag to request response
         */
        response?: boolean;
    }
    interface EditorMessageResponse extends EditorMessage {
        /**
         * Additional response payload provided by the command
         */
        resp?: any;
        /**
         * indicate if operation started or completed successfully
         */
        success: boolean;
        /**
         * Error object if any
         */
        error?: any;
    }
    interface EditorMessageRequest extends EditorMessage {
        /**
         * Request action
         */
        action: "switchblocks" | "switchjavascript" | "startsimulator" | "restartsimulator" | "stopsimulator" | "hidesimulator" | "showsimulator" | "newproject" | "importproject" | "proxytosim" | "undo" | "redo" | "renderblocks" | "toggletrace" | "workspacesync" | "workspacereset" | "workspacesave" | "event" | "simevent";
    }
    /**
     * Request sent by the editor when a tick/error/expection is registered
     */
    interface EditorMessageEventRequest extends EditorMessageRequest {
        action: "event";
        tick: string;
        category?: string;
        message?: string;
        data?: Map<string | number>;
    }
    interface EditorMessageStopRequest extends EditorMessageRequest {
        action: "stopsimulator";
        /**
         * Indicates if simulator iframes should be unloaded or kept hot.
         */
        unload?: boolean;
    }
    interface EditorMessageNewProjectRequest extends EditorMessageRequest {
        action: "newproject";
        /**
         * Additional optional to create new project
         */
        options?: ProjectCreationOptions;
    }
    interface EditorMessageSimulatorMessageProxyRequest extends EditorMessageRequest {
        action: "proxytosim";
        /**
         * Content to send to the simulator
         */
        content: any;
    }
    interface EditorWorkspaceSyncRequest extends EditorMessageRequest {
        /**
         * Synching projects from host into
         */
        action: "workspacesync" | "workspacereset";
    }
    interface EditorSyncState {
        filters?: pxt.editor.ProjectFilters;
    }
    interface EditorWorkspaceSyncResponse extends EditorMessageResponse {
        projects: pxt.workspace.Project[];
        editor?: EditorSyncState;
    }
    interface EditorWorkspaceSaveRequest extends EditorMessageRequest {
        action: "workspacesave";
        project: pxt.workspace.Project;
    }
    interface EditorMessageImportProjectRequest extends EditorMessageRequest {
        action: "importproject";
        project: pxt.workspace.Project;
        filters?: pxt.editor.ProjectFilters;
    }
    interface EditorMessageRenderBlocksRequest extends EditorMessageRequest {
        action: "renderblocks";
        ts: string;
    }
    interface EditorMessageRenderBlocksResponse {
        mime: "application/svg+xml";
        data: string;
    }
    interface EditorSimulatorEvent extends EditorMessageRequest {
        action: "simevent";
        subtype: "toplevelfinished" | "started" | "stopped" | "resumed";
    }
    interface EditorSimulatorStoppedEvent extends EditorSimulatorEvent {
        subtype: "stopped";
        exception?: string;
    }
    interface EditorMessageToggleTraceRequest extends EditorMessageRequest {
        action: "toggletrace";
        intervalSpeed?: number;
    }
    /**
     * Binds incoming window messages to the project view.
     * Requires the "allowParentController" flag in the pxtarget.json/appTheme object.
     *
     * When the project view receives a request (EditorMessageRequest),
     * it starts the command and returns the result upon completion.
     * The response (EditorMessageResponse) contains the request id and result.
     * Some commands may be async, use the ``id`` field to correlate to the original request.
     */
    function bindEditorMessages(projectView: IProjectView): void;
    /**
     * Sends analytics messages upstream to container if any
     */
    function enableControllerAnalytics(): void;
    /**
     * Posts a message from the editor to the host
     */
    function postHostMessageAsync(msg: EditorMessageRequest): Promise<EditorMessageResponse>;
}
declare namespace pxt.storage {
    function storageId(): string;
    function setLocal(key: string, value: string): void;
    function getLocal(key: string): string;
    function removeLocal(key: string): void;
    function clearLocal(): void;
}
declare namespace pxt.vs {
    interface BlockDefiniton {
        commentAttr: pxtc.CommentAttrs;
        fns?: Map<string>;
    }
    interface MethodDef {
        sig: string;
        snippet: string;
        comment?: string;
        metaData?: pxtc.CommentAttrs;
        snippetOnly?: boolean;
    }
    interface NameDefiniton {
        fns: {
            [fn: string]: MethodDef;
        };
        vars?: {
            [index: string]: string;
        };
        metaData?: pxtc.CommentAttrs;
        builtin?: boolean;
    }
    type DefinitionMap = {
        [ns: string]: NameDefiniton;
    };
    function syncModels(mainPkg: MainPackage, libs: {
        [path: string]: monaco.IDisposable;
    }, currFile: string, readOnly: boolean): void;
    function initMonacoAsync(element: HTMLElement): Promise<monaco.editor.IStandaloneCodeEditor>;
    function createEditor(element: HTMLElement): monaco.editor.IStandaloneCodeEditor;
}
declare namespace pxt.shell {
    enum EditorLayoutType {
        IDE = 0,
        Sandbox = 1,
        Widget = 2,
    }
    function layoutTypeClass(): string;
    function isSandboxMode(): boolean;
    function isReadOnly(): boolean;
}
declare namespace pxt.workspace {
    interface InstallHeader {
        name: string;
        meta: pxt.Cloud.JsonScriptMeta;
        editor: string;
        temporary?: boolean;
        target: string;
        pubId: string;
        pubCurrent: boolean;
    }
    interface Header extends InstallHeader {
        _rev: string;
        id: string;
        recentUse: number;
        modificationTime: number;
        blobId: string;
        blobCurrent: boolean;
        isDeleted: boolean;
        saveId?: any;
        icon?: string;
    }
    type ScriptText = pxt.Map<string>;
    interface Project {
        header?: Header;
        text?: ScriptText;
    }
    interface WorkspaceProvider {
        getHeaders(): Header[];
        getHeader(id: string): Header;
        getTextAsync(id: string): Promise<ScriptText>;
        initAsync(target: string): Promise<void>;
        saveAsync(h: Header, text?: ScriptText): Promise<void>;
        installAsync(h0: InstallHeader, text: ScriptText): Promise<Header>;
        saveToCloudAsync(h: Header): Promise<void>;
        syncAsync(): Promise<pxt.editor.EditorSyncState>;
        resetAsync(): Promise<void>;
        saveScreenshotAsync?: (h: Header, screenshot: string, icon: string) => Promise<void>;
        importLegacyScriptsAsync?: () => Promise<void>;
    }
}
