/// <reference path="../typings/globals/node/index.d.ts" />
/// <reference path="pxtlib.d.ts" />
/// <reference path="pxtcompiler.d.ts" />
/// <reference path="pxtsim.d.ts" />
import Map = pxt.Map;
import * as server from './server';
import * as commandParser from './commandparser';
export interface UserConfig {
    localToken?: string;
    noAutoBuild?: boolean;
    noAutoStart?: boolean;
    localBuild?: boolean;
}
export declare let globalConfig: UserConfig;
export declare function loginAsync(parsed: commandParser.ParsedCommand): Promise<any>;
export declare function logoutAsync(): Promise<void>;
export declare function pokeRepoAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function execCrowdinAsync(cmd: string, ...args: string[]): Promise<void>;
export declare function apiAsync(path: string, postArguments?: string): Promise<void>;
export declare function queryAsync(msg: string, defl: string): Promise<string>;
export declare function yesNoAsync(msg: string): Promise<boolean>;
export declare function uploadTargetAsync(label: string): Promise<void>;
export declare function ghpPushAsync(builtPackaged: string, minify?: boolean): Promise<void>;
export declare function buildTargetAsync(): Promise<void>;
export declare function serveAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function installAsync(parsed?: commandParser.ParsedCommand): Promise<void>;
export declare function addAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function initAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function serviceAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function augmnetDocsAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function timeAsync(): Promise<void>;
export declare function formatAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function uploadTargetTranslationsAsync(parsed?: commandParser.ParsedCommand): Promise<void>;
export declare function downloadTargetTranslationsAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function staticpkgAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function cleanAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function buildAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function gendocsAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function buildTargetDocsAsync(docs: boolean, locs: boolean, fileFilter?: string, createOnly?: boolean): Promise<void>;
export declare function deployAsync(parsed?: commandParser.ParsedCommand): Promise<void>;
export declare function runAsync(): Promise<void>;
export declare function testAsync(): Promise<void>;
export declare function serialAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export interface SavedProject {
    name: string;
    files: Map<string>;
}
export declare function extractAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export declare function hexdumpAsync(c: commandParser.ParsedCommand): Promise<void>;
export declare function hex2uf2Async(c: commandParser.ParsedCommand): Promise<void>;
export declare function publishGistAsync(parsed: commandParser.ParsedCommand): Promise<void>;
export interface SnippetInfo {
    type: string;
    code: string;
    ignore: boolean;
    index: number;
}
export declare function getSnippets(source: string): SnippetInfo[];
export interface CodeSnippet {
    name: string;
    code: string;
    type: string;
    packages: pxt.Map<string>;
}
export declare function getCodeSnippets(fileName: string, md: string): CodeSnippet[];
export declare function mainCli(targetDir: string, args?: string[], handlers?: pxt.Map<server.ElectronHandler>): Promise<void>;
export declare function sendElectronMessage(message: server.ElectronMessage): void;
