/// <reference path="../localtypings/blockly.d.ts" />
/// <reference path="pxtlib.d.ts" />
/// <reference path="../typings/globals/jquery/index.d.ts" />
import B = Blockly;
declare let iface: pxt.worker.Iface;
declare namespace pxt.blocks {
    function initWorker(): void;
    function workerOpAsync(op: string, arg: pxtc.service.OpArg): Promise<any>;
    class Point {
        link: Point;
        type: string;
        parentType: Point;
        childType: Point;
        constructor(link: Point, type: string, parentType?: Point, childType?: Point);
    }
    function compileExpression(e: Environment, b: B.Block, comments: string[]): JsNode;
    interface Environment {
        workspace: Blockly.Workspace;
        bindings: Binding[];
        stdCallTable: pxt.Map<StdFunc>;
        errors: B.Block[];
        renames: RenameMap;
        stats: pxt.Map<number>;
    }
    interface RenameMap {
        oldToNew: Map<string>;
        takenNames: Map<boolean>;
    }
    enum VarUsage {
        Unknown = 0,
        Read = 1,
        Assign = 2,
    }
    interface Binding {
        name: string;
        type: Point;
        declaredInLocalScope: number;
        assigned?: VarUsage;
        mustBeGlobal?: boolean;
    }
    function escapeVarName(name: string, e: Environment): string;
    interface StdArg {
        field?: string;
        literal?: string | number;
    }
    interface StdFunc {
        f: string;
        args: StdArg[];
        attrs: ts.pxtc.CommentAttrs;
        isExtensionMethod?: boolean;
        isExpression?: boolean;
        imageLiteral?: number;
        hasHandler?: boolean;
        property?: boolean;
        namespace?: string;
        isIdentity?: boolean;
    }
    function mkEnv(w: B.Workspace, blockInfo?: pxtc.BlocksInfo, skipVariables?: boolean): Environment;
    function compileBlockAsync(b: B.Block, blockInfo: pxtc.BlocksInfo): Promise<BlockCompilationResult>;
    function callKey(e: Environment, b: B.Block): string;
    interface BlockCompilationResult {
        source: string;
        sourceMap: SourceInterval[];
        stats: pxt.Map<number>;
    }
    function findBlockId(sourceMap: SourceInterval[], loc: {
        start: number;
        length: number;
    }): string;
    function compileAsync(b: B.Workspace, blockInfo: pxtc.BlocksInfo): Promise<BlockCompilationResult>;
}
declare namespace pxt.blocks {
    function initFieldEditors(): void;
    function registerFieldEditor(selector: string, field: Blockly.FieldCustomConstructor, validator?: any): void;
    function createFieldEditor(selector: string, text: string, params: any): Blockly.FieldCustom;
}
declare namespace pxt.blocks {
    function saveWorkspaceXml(ws: Blockly.Workspace): string;
    function getDirectChildren(parent: Element, tag: string): Element[];
    function getBlocksWithType(parent: Document | Element, type: string): Element[];
    function getChildrenWithAttr(parent: Document | Element, tag: string, attr: string, value: string): Element[];
    function getFirstChildWithAttr(parent: Document | Element, tag: string, attr: string, value: string): Element;
    /**
     * Loads the xml into a off-screen workspace (not suitable for size computations)
     */
    function loadWorkspaceXml(xml: string, skipReport?: boolean): B.Workspace;
    function importXml(xml: string, info: pxtc.BlocksInfo, skipReport?: boolean): string;
    /**
     * Convert blockly hue to rgb
     */
    function convertColour(colour: string): string;
}
declare namespace pxt.blocks.layout {
    interface FlowOptions {
        ratio?: number;
        useViewWidth?: boolean;
    }
    function patchBlocksFromOldWorkspace(blockInfo: ts.pxtc.BlocksInfo, oldWs: B.Workspace, newXml: string): string;
    function verticalAlign(ws: B.Workspace, emPixels: number): void;
    function shuffle(ws: B.Workspace, ratio?: number): void;
    function flow(ws: B.Workspace, opts?: FlowOptions): void;
    function screenshotEnabled(): boolean;
    function screenshotAsync(ws: B.Workspace): Promise<string>;
    function toPngAsync(ws: B.Workspace): Promise<string>;
    function svgToPngAsync(svg: SVGElement, x: number, y: number, width: number, height: number, pixelDensity: number): Promise<string>;
    function toSvgAsync(ws: B.Workspace): Promise<{
        width: number;
        height: number;
        xml: string;
    }>;
    function blocklyToSvgAsync(sg: SVGElement, x: number, y: number, width: number, height: number): Promise<{
        width: number;
        height: number;
        xml: string;
    }>;
    function documentToSvg(xsg: Node): string;
}
import Util = pxt.Util;
declare let lf: typeof pxtc.U.lf;
declare namespace pxt.blocks {
    const blockColors: Map<number | string>;
    enum CategoryMode {
        All = 0,
        None = 1,
        Basic = 2,
    }
    const buildinBlockStatements: Map<boolean>;
    function blockSymbol(type: string): pxtc.SymbolInfo;
    function appendToolboxIconCss(className: string, i: string): void;
    function injectToolboxIconCss(): void;
    function appendNamespaceCss(namespace: string, color: string): void;
    function hasArrowFunction(fn: pxtc.SymbolInfo): boolean;
    interface BlockFilters {
        namespaces?: {
            [index: string]: FilterState;
        };
        blocks?: {
            [index: string]: FilterState;
        };
        defaultState?: FilterState;
    }
    enum FilterState {
        Hidden = 0,
        Visible = 1,
        Disabled = 2,
    }
    function createToolbox(blockInfo: pxtc.BlocksInfo, toolbox?: Element, showCategories?: CategoryMode, filters?: BlockFilters): Element;
    function initBlocks(blockInfo: pxtc.BlocksInfo, toolbox?: Element, showCategories?: CategoryMode, filters?: BlockFilters): Element;
    let cachedSearchTb: Element;
    let cachedSearchTbAll: Element;
    function initSearch(workspace: Blockly.Workspace, tb: Element, tbAll: Element, searchAsync: (searchFor: pxtc.service.SearchOptions) => Promise<pxtc.service.SearchInfo[]>, updateToolbox: (tb: Element) => void): void;
    function cleanBlocks(): void;
    let openHelpUrl: (url: string) => void;
    var onShowContextMenu: (workspace: Blockly.Workspace, items: Blockly.ContextMenu.MenuItem[]) => void;
    function getNamespaceColor(ns: string): string;
    function initFlyouts(workspace: Blockly.Workspace): void;
}
declare namespace pxt.blocks {
    /**
     * This interface defines the optionally defined functions for mutations that Blockly
     * will call if they exist.
     */
    interface MutatingBlock extends Blockly.Block {
        mutation: Mutation;
        mutationToDom(): Element;
        domToMutation(xmlElement: Element): void;
        compose(topBlock: Blockly.Block): void;
        decompose(workspace: Blockly.Workspace): Blockly.Block;
    }
    /**
     * Represents a mutation of a block
     */
    interface Mutation {
        /**
         * Get the unique identifier for this type of mutation
         */
        getMutationType(): string;
        /**
         * Compile the mutation of the block into a node representation
         */
        compileMutation(e: Environment, comments: string[]): JsNode;
        /**
         * Get a mapping of variables that were declared by this mutation and their types.
         */
        getDeclaredVariables(): pxt.Map<string>;
        /**
         * Returns true if a variable with the given name was declared in the mutation's compiled node
         */
        isDeclaredByMutation(varName: string): boolean;
    }
    namespace MutatorTypes {
        const ObjectDestructuringMutator: string;
        const RestParameterMutator: string;
        const DefaultInstanceMutator: string;
    }
    function addMutation(b: MutatingBlock, info: pxtc.SymbolInfo, mutationType: string): void;
    function mutateToolboxBlock(block: Node, mutationType: string, mutation: string): void;
}
declare namespace pxt.blocks {
    enum BlockLayout {
        Align = 1,
        Shuffle = 2,
        Clean = 3,
        Flow = 4,
    }
    interface BlocksRenderOptions {
        emPixels?: number;
        layout?: BlockLayout;
        clean?: boolean;
        aspectRatio?: number;
        package?: string;
        snippetMode?: boolean;
        useViewWidth?: boolean;
    }
    function render(blocksXml: string, options?: BlocksRenderOptions): SVGSVGElement;
    function blocksMetrics(ws: Blockly.Workspace): {
        width: number;
        height: number;
    };
}
declare namespace pxt.docs.codeCard {
    interface CodeCardRenderOptions {
        hideHeader?: boolean;
        shortName?: boolean;
    }
    function render(card: pxt.CodeCard, options?: CodeCardRenderOptions): HTMLElement;
}
declare namespace pxtblockly {
    interface FieldGridPickerToolTipConfig {
        yOffset?: number;
        xOffset?: number;
    }
    interface FieldGridPickerOptions extends Blockly.FieldCustomDropdownOptions {
        columns?: string;
        maxRows?: string;
        width?: string;
        itemColour?: string;
        tooltips?: string;
        tooltipsXOffset?: string;
        tooltipsYOffset?: string;
        hasSearchBar?: boolean;
    }
    class FieldGridPicker extends Blockly.FieldDropdown implements Blockly.FieldCustom {
        isFieldCustom_: boolean;
        private width_;
        private columns_;
        private maxRows_;
        private backgroundColour_;
        private itemColour_;
        private borderColour_;
        private tooltipConfig_;
        private tooltips_;
        private hasSearchBar_;
        constructor(text: string, options: FieldGridPickerOptions, validator?: Function);
        /**
         * When disposing the grid picker, make sure the tooltips are disposed too.
         * @public
         */
        dispose(): void;
        /**
         * Create blocklyGridPickerRows and add them to table container
         * @param options
         * @param tableContainer
         */
        private populateTableContainer(options, tableContainer);
        /**
         * Add the tooltips and style the items
         * @param options
         * @param tableContainer
         */
        private createTooltips(options, tableContainer);
        /**
         * Create a dropdown menu under the text.
         * @private
         */
        showEditor_(): void;
        private createRow(row, options);
        /**
         * Disposes the tooltip DOM elements.
         * @private
         */
        private disposeTooltips();
    }
}
declare namespace pxtblockly {
    class FieldNote extends Blockly.FieldNumber implements Blockly.FieldCustom {
        isFieldCustom_: boolean;
        private note_;
        private colour_;
        /**
         * default number of piano keys
         * @type {number}
         * @private
         */
        private nKeys_;
        /**
         * Absolute error for note frequency identification (Hz)
         * @type {number}
         */
        eps: number;
        /**
         * array of notes frequency
         * @type {Array.<number>}
         * @private
         */
        private noteFreq_;
        /**
         * array of notes names
         * @type {Array.<string>}
         * @private
         */
        private noteName_;
        constructor(text: string, options: Blockly.FieldCustomOptions, validator?: Function);
        /**
         * Ensure that only a non negative number may be entered.
         * @param {string} text The user's text.
         * @return {?string} A string representing a valid positive number, or null if invalid.
         */
        classValidator(text: string): string;
        /**
         * Install this field on a block.
         */
        init(): void;
        /**
         * Return the current note frequency.
         * @return {string} Current note in string format.
         */
        getValue(): string;
        /**
         * Set the note.
         * @param {string} note The new note in string format.
         */
        setValue(note: string): void;
        /**
         * Get the text from this field.  Used when the block is collapsed.
         * @return {string} Current text.
         */
        getText(): string;
        /**
         * Set the text in this field and NOT fire a change event.
         * @param {*} newText New text.
         */
        setText(newText: string): void;
        /**
        * get the note name to be displayed in the field
        * @return {string} note name
        * @private
        */
        private getNoteName_();
        /**
         * Set a custom number of keys for this field.
         * @param {number} nkeys Number of keys for this block,
         *     or 26 to use default.
         * @return {!Blockly.FieldNote} Returns itself (for method chaining).
         */
        setNumberOfKeys(size: number): FieldNote;
        /**
         * Create a piano under the note field.
         */
        showEditor_(opt_quietInput?: boolean): void;
        /**
         * Close the note picker if this input is being deleted.
         */
        dispose(): void;
    }
}
declare namespace pxtblockly {
    class FieldProcedure extends Blockly.FieldDropdown {
        constructor(funcname: string, opt_validator?: Function);
        getOptions(): string[][];
        init(): void;
        setSourceBlock(block: Blockly.Block): void;
        getValue(): string;
        setValue(newValue: string): void;
        /**
         * Return a sorted list of variable names for procedure dropdown menus.
         * Include a special option at the end for creating a new function name.
         * @return {!Array.<string>} Array of procedure names.
         * @this {pxtblockly.FieldProcedure}
         */
        dropdownCreate(): string[][];
        onItemSelected(menu: any, menuItem: any): void;
    }
}
declare namespace pxtblockly {
    function parseColour(colour: string | number): string;
    namespace AudioContextManager {
        function mute(mute: boolean): void;
        function stop(): void;
        function frequency(): number;
        function tone(frequency: number): void;
    }
}
