/// <reference path="../libs/core/enums.d.ts" />
/// <reference path="../node_modules/pxt-core/typings/globals/bluebird/index.d.ts" />
/// <reference path="../node_modules/pxt-core/built/pxtsim.d.ts" />
declare namespace pxsim.loops {
    /**
     * Pause for the specified time in milliseconds
     * @param ms how long to pause for, eg: 100, 200, 500, 1000, 2000
     */
    function pauseAsync(ms: number): Promise<void>;
}
declare namespace pxsim.LRFEyeMessages {
    /** Blinks the plugged in pattern on the robot's eyes. */
    function blinkPattern(pattern: LRFPattern): void;
    /** Blinks the plugged in array of patterns on the robot's eyes. */
    function blinkPatterns(patterns: LRFPattern[]): void;
    /** Changes the color of the eyes using a boomerang, zigzag, flat, flip, or random pattern. */
    function pattern(startColor: LRFColour, endColor: LRFColour, boomerang: boolean, zigzag: boolean, flat: boolean, flip: boolean, random: boolean, duration: LRFDuration): LRFPattern;
    /** Changes the eyes color from start to end using a fade pattern. */
    function basicPattern(startColor: LRFColour, endColor: LRFColour, duration?: LRFDuration): LRFPattern;
    /**
     * Sets the color of both your LRF's eyes.
     */
    function setEyeColorBoth(color: LRFColour): void;
    /**
     * Sets the colors for your LRF's eyes
     * @param left
     * @param right
     */
    function setEyeColors(left: LRFColour, right: LRFColour): void;
    /**
     */
    function color(color: LRFColour): LRFColour;
    /**
     * Sets the color of both eyes using an 'rgb color' value
     * @param rgb
     */
    function setEyesRbg(rgb?: LRFRgbColour): void;
    /**
     * Sets the color of your LRF's eyes using 'rgb color' values
     * @param left
     * @param right
     */
    function setEyeRGB(left?: LRFRgbColour, right?: LRFRgbColour): void;
    /**
     * Defines an RGB color. Use "red", "green", and "blue" to define how much of each color you want to mix. Each color can be between 0 and 255
     * @param red [0-255]; eg: 255, 100, 0
     * @param green [0-255]; eg: 255, 100, 0
     * @param blue [0-255]; eg: 255, 100, 0
     */
    function rgbColor(red: number, green: number, blue: number): LRFRgbColour;
    /**
     * Sets both eye colors to none.
     */
    function turnEyesOff(): void;
}
declare namespace pxsim.LRFSoundMessages {
    /**
     * Say a sound
     * @param sound
     */
    function saySound(sound: LRFSound): void;
    /**
     * Say a set of sounds in order. Create a variable and set it to an array of sounds.
     * @param sounds
     */
    function saySounds(sounds: LRFSound[]): void;
    /**
     * Describes a sound object. Define the note, its octave, intonation, duration, and the pause after it.
     * @param note
     * @param octave
     * @param intonation
     * @param duration
     * @param pause
     */
    function sound(note: LRFNote, octave: LRFOctave, intonation: LRFIntonation, duration: LRFDuration, pause: LRFDuration): LRFSound;
    /**
     * Sounds a frequency on the speaker in Hertz (Hz).
     * @param freq the frequency to play; eg: 440
     */
    function setSpeakerToFrequency(freq: number): void;
    /**
     * Sets the speaker frequency to 0.
     */
    function turnOffSpeaker(): void;
}
declare namespace pxsim.LRFExpressions {
    /** Play one of the built-in hello expressions */
    function doHello(expression: LRFHelloExpression): void;
    /** Play one of the built-in mood expressions */
    function doMood(expression: LRFMoodExpression): void;
    /** Play one of the built-in test expressions */
    function doTest(expression: LRFMoodExpression): void;
    /** Play one of the built-in laugh expressions */
    function doLaugh(expression: LRFLaughExpression): void;
    /** Play one of the built-in cry expressions */
    function doCry(expression: LRFCryExpression): void;
    /** Play one of the built-in scared expressions */
    function doScared(expression: LRFScaredExpression): void;
    /** Play one of the built-in sleepy expressions */
    function doSleepy(expression: LRFSleepyExpression): void;
    /** Play one of the built-in system expressions */
    function doSystem(expression: LRFSystemExpression): void;
    /** Play one of the built-in whoa expressions */
    function doWhoa(expression: LRFMiscExpression): void;
    /** Plays the plugged in custom expression on the robot */
    function blinkAndSayExpression(expression: SoundCollection): void;
    /** A custom expression made of up to 4 sounds and a pattern. */
    function expression(pattern: LRFPattern, sound1: LRFSound, sound2?: LRFSound, sound3?: LRFSound, sound4?: LRFSound): SoundCollection;
}
declare namespace pxsim.LRFInputEvents {
    /** Code inside this block will run when the robot's hair is tapped, touched, or tickled. Choose which one in the dropdown */
    function onHairTouchedEvent(type: LRFTouchEventType, body: RefAction): void;
    /** Code inside this block will run when the robot's left hand is tapped, touched, or tickled. Choose which one in the dropdown */
    function onHandTouchedLeft(type: LRFTouchEventType, body: RefAction): void;
    /** Code inside this block will run when the robot's right hand is tapped, touched, or tickled. Choose which one in the dropdown */
    function onHandTouchedRight(type: LRFTouchEventType, body: RefAction): void;
    /** Code inside this block will run when the robot hears a normal or loud sound. Choose the type in the dropdown. */
    function onSoundDetected(type: LRFSoundSensorEventType, body: RefAction): void;
    /** Code inside this block will run when the robot detects a level of light. Choose which kind of light to detect in the dropdown */
    function onLightType(type: LRFLightSensorEventType, body: RefAction): void;
    /** Code inside this block will run when the robot detects some motion. Choose which type of motion in the dropdown */
    function onMotion(type: LRFMotionSensorEventType, body: RefAction): void;
    /**
     * ADD DESCRIPTION PLZ
     */
    function touchRead(channel: LRFTouchSensorChannel): number;
    /**
     * ADD DESCRIPTION PLZ
     */
    function hearingRead(): number;
    /**
     * ADD DESCRIPTION PLZ
     */
    function sightRead(): number;
    /**
     * ADD DESCRIPTION PLZ
     */
    function motionRead(channel: LRFMotionSensorChannel): number;
}
declare function logMsg(m: string): void;
declare namespace pxsim.console {
    /**
     * Print out message
     */
    function log(msg: string): void;
}
declare namespace pxsim {
    class LRFRgbColour {
        red: number;
        green: number;
        blue: number;
        constructor(r?: number, g?: number, b?: number);
        styleString(): string;
    }
    class LRFSound {
        note: LRFNote;
        octave: LRFOctave;
        intonation: LRFIntonation;
        duration: LRFDuration;
        pause: LRFDuration;
        constructor(note?: LRFNote, octave?: LRFOctave, intonation?: LRFIntonation, duration?: LRFDuration, pause?: LRFDuration);
        getRaw(): number;
        unpackRaw(raw: any): void;
    }
    class LRFPattern {
        rightLed: LRFColour;
        leftLed: LRFColour;
        boomerang: number;
        zigzag: number;
        flat: number;
        flip: number;
        random: number;
        duration: LRFDuration;
        constructor(rightLed: LRFColour, leftLed: LRFColour, boomerang: boolean, zigzag: boolean, flat: boolean, flip: boolean, random: boolean, duration?: LRFDuration);
        getRaw(): number;
        unpackRaw(raw: any): void;
    }
    class SoundCollection {
        sounds: LRFSound[];
        pattern: LRFPattern;
        uname: string;
        constructor(sounds: LRFSound[], pattern: LRFPattern);
        isEqual(soundCollection: any, isStrictComparison?: boolean): boolean;
    }
}
/** A reference object to the LRFWebcore object loaded into the window by ptx */
declare const core: any;
declare const LRFEvents: any;
declare namespace LRFSerial {
    const connection: any;
    const isConnected: any;
    function setReceiveCallback(callback: (receivedBuffer) => any): void;
}
/**
 * A namespace to export LRFComm from lrf-webcore
 */
declare namespace LRFComm {
    const EVENT: any;
    const unpack: (buffer: any) => any;
    const send: (lrfmessagebuffer: any, requiresDelay?: any) => any;
    const sendAwaitingResponse: (lrfmessagebuffer: any) => any;
    const getCharacterName: () => any;
    const eventsGetMap: (actionIndexRange: any) => any;
    const getCustomPresetExpression: (customExpressionIndex: any) => any;
    const getPresetExpressions: (startIndex: any, endIndex: any) => any;
    const touchRead: () => any;
}
/**
 * A namespace to expose LRFMessages from lrf-webcore
 */
declare namespace LRFMessages {
    const lrfMessageCode: any;
    const LRFPATTERN_SIZE: any;
    const LRFSOUND_SIZE: any;
    const LRFEXPRESSION_SIZE: any;
    const LRFMEMORYINDEX_SIZE: any;
    const headerLength: any;
    const footerLength: any;
    const minBodyLength: any;
    const startByte: any;
    const endByte: any;
    const minMessageLength: any;
    const getCRC: (message: any) => any;
    const getRobotInfo: () => ArrayBuffer;
    const getCharacterName: () => ArrayBuffer;
    const setCharacterName: (newName: string) => ArrayBuffer;
    const eventsSetMap: (actionIndex: any, expressionIndex: any) => ArrayBuffer;
    const eventsGetMap: (actionRange: any) => ArrayBuffer;
    const eyesSet: (leftRedVal: number, leftGreenVal: number, leftBlueVal: number, rightRedVal: number, rightGreenVal: number, rightBlueVal: number) => ArrayBuffer;
    const eyesSetColors: (lrfColor_left: any, lrfColor_right: any) => ArrayBuffer;
    const eyesBlinkPatterns: (lrfPatterns: any, prefersBlocking?: boolean) => ArrayBuffer;
    const speechSet: (freq: any) => ArrayBuffer;
    const speechSaySounds: (lrfSounds: any, prefersBlocking?: boolean) => ArrayBuffer;
    const blinkAndSayPreset: (expressionLabel: any, prefersBlocking?: boolean) => ArrayBuffer;
    const blinkAndSayPresetWithIndex: (expressionLabel: any, prefersBlocking?: boolean) => ArrayBuffer;
    const blinkAndSay: (expression: any, prefersBlocking?: boolean) => ArrayBuffer;
    const getPresetExpressions: (startIndex: any, endIndex: any) => ArrayBuffer;
    const getCustomPresetExpression: (lrfMemoryIndex: any) => ArrayBuffer;
    const setCustomPresetExpression: (lrfMemoryIndex: any, expressionData: any, expressionName: any) => ArrayBuffer;
    const chatter: () => ArrayBuffer;
    const singSong: (lrfSong: any) => ArrayBuffer;
    const setPresetSong: (lrfMemoryIndex: any, lrfSong: any) => ArrayBuffer;
    const getPresetSong: (lrfMemoryIndex: any) => ArrayBuffer;
}
/**
 * A namespace to expose LRFTypes from lrf-webcore.
 */
declare namespace LRFTypes {
    const LRFOctave: any;
    const LRFNote: any;
    const LRFIntonation: any;
    const LRFDuration: any;
    const LRFColor: any;
    const LRFPersonalityTraits: any;
    const LRFTransform: any;
    const LRFAction: any;
    const actionRange: any;
    const sensorMap: any;
    const LRFExpression: any;
    const LRFSound: any;
    const LRFPattern: any;
    const SoundCollection: any;
    const RobotType: any;
    const typeTable: any;
    const CONSTANTS: any;
    const robotTypeLookup: any;
}
declare namespace LRFRobotModel {
    const senses: any;
}
declare namespace pxsim.pxtcore {
    function registerWithBoard(id: number, eventId: number | string, eventHander: RefAction): void;
}
declare namespace pxsim {
    /**
     * Gets the current 'board', eg. program state.
     */
    function board(): LRFBoard;
    abstract class LRFBoard extends pxsim.CoreBoard {
        constructor();
        abstract changeEyeRgb(left: LRFRgbColour, right: LRFRgbColour): any;
        abstract changeEyeAlpha(left: number, right: number): any;
        abstract changeEyeColours(left: LRFColour, right: LRFColour): any;
        abstract playSound(sound: LRFSound, callback?: () => void): any;
        abstract playSoundSet(sounds: any, i?: number, callback?: () => any): any;
        abstract speechSet(frequency: number): any;
        abstract chatter(): any;
        abstract postMessage(msg: string): any;
        abstract doExpression(expression: LRFHelloExpression | LRFMoodExpression | LRFLaughExpression | LRFCryExpression | LRFScaredExpression | LRFSleepyExpression | LRFSystemExpression | LRFMiscExpression): any;
        abstract blinkPattern(pattern: LRFPattern): any;
        abstract blinkPatterns(patterns: LRFPattern[]): any;
        abstract blinkAndSay(expression: SoundCollection): any;
        abstract touchRead(channel: LRFTouchSensorChannel, callback?: () => any): any;
        abstract hearingRead(callback?: () => any): any;
        abstract sightRead(callback?: () => any): any;
        abstract motionRead(channel: LRFMotionSensorChannel, callback?: () => any): any;
    }
    /**
    * A board to use if there is no LRF connected. Controls the simulator.
    *
    * Represents the entire state of the executing program.
    * Do not store state anywhere else!
    */
    class LRFSoftBoard extends LRFBoard {
        speechSet(frequency: number): void;
        blinkAndSay(expression: SoundCollection): void;
        blinkPattern(pattern: any): void;
        blinkPatterns(patterns: any): void;
        touchRead(channel: LRFTouchSensorChannel, callback?: () => any): void;
        hearingRead(callback?: () => any): void;
        sightRead(callback?: () => any): void;
        motionRead(channel: LRFMotionSensorChannel, callback?: () => any): void;
        canvas: SVGSVGElement;
        eyeLeft: SVGCircleElement;
        eyeRight: SVGCircleElement;
        hair: SVGPathElement;
        handLeft: SVGPathElement;
        handRight: SVGPathElement;
        soundSensor: SVGEllipseElement;
        lightSensor: SVGPathElement;
        speaker: SVGEllipseElement;
        button: SVGCircleElement;
        tooDarkLong: HTMLImageElement;
        tooDark: HTMLImageElement;
        lightNormal: HTMLImageElement;
        tooBright: HTMLImageElement;
        toobrightlong: HTMLImageElement;
        layLeft: HTMLImageElement;
        layRight: HTMLImageElement;
        shake: HTMLImageElement;
        tiltLeft: HTMLImageElement;
        tiltRight: HTMLImageElement;
        loud: HTMLImageElement;
        soundNormal: HTMLImageElement;
        colour: string;
        constructor();
        private soundTimeout;
        setSimulatorToDefaultState(): void;
        private onStateChanged;
        initAsync(msg: pxsim.SimulatorRunMessage): Promise<void>;
        setInputEvents(): void;
        updateView(): void;
        postMessage(msg: string): void;
        changeEyeRgb(left: LRFRgbColour, right: LRFRgbColour): void;
        changeEyeAlpha(left: number, right: number): void;
        changeEyeColours(left: LRFColour, right: LRFColour): void;
        playSound(sound: LRFSound, callback?: () => void): void;
        private getTimeForDuration(duration);
        private getFreqForNote(note);
        playSoundSet(sounds: any, i?: number, callback?: () => any): void;
        chatter(): void;
        doExpression(expression: LRFHelloExpression | LRFMoodExpression | LRFLaughExpression | LRFCryExpression | LRFScaredExpression | LRFSleepyExpression | LRFSystemExpression | LRFMiscExpression): void;
        private doChatter(sounds, i?, callback?);
        private getColourForValue(val);
    }
    class LRFHardBoard extends LRFBoard {
        private touchyState;
        private lastLeftRgb;
        private lastRightRgb;
        private lastLeftColour;
        private lastRightColour;
        constructor();
        triggerInputAction: (action: number) => void;
        changeEyeRgb(left: LRFRgbColour, right: LRFRgbColour): void;
        changeEyeAlpha(left: number, right: number): void;
        changeEyeColours(left: LRFColour, right: LRFColour): void;
        playSound(sound: LRFSound, callback?: () => void): void;
        playSoundSet(sounds: any, i?: number, callback?: () => any): void;
        speechSet(frequency: number): void;
        chatter(): void;
        doExpression(expression: LRFHelloExpression | LRFMoodExpression | LRFLaughExpression | LRFCryExpression | LRFScaredExpression | LRFSleepyExpression | LRFSystemExpression | LRFMiscExpression): void;
        blinkPattern(pattern: LRFPattern): void;
        blinkPatterns(patterns: LRFPattern[]): void;
        blinkAndSay(expression: SoundCollection): void;
        postMessage(msg: string): void;
        touchRead(channel: LRFTouchSensorChannel, callback?: () => any): any;
        hearingRead(callback?: () => any): any;
        sightRead(callback?: () => any): any;
        motionRead(channel: LRFMotionSensorChannel, callback?: () => any): any;
    }
}
declare namespace LRFUtils {
    /**
     * Manages single, double, and long clicks/taps and attaches events to the provided object.
     */
    class LRFTouchClickManager {
        private touchObject;
        private touchDownTime;
        private touchUpTime;
        private tapTimer;
        private didFirstClick;
        /**
         * Duration of a long touch/click
         */
        longTouchTime: number;
        /**
         * Amount of time to listen for a second tap/click (doube tap/click)
         */
        listenForDoubleTapTime: number;
        constructor(object: HTMLElement | SVGElement, singleTapEvent?: () => void, doubleTapEvent?: () => void, longTapEvent?: () => void);
        private startTouchClick();
        private endTouchClick();
        private finishTouchEvent();
        /**
         * Event to fire on a single tap/click
         */
        onSingleTap: () => void;
        /**
         * Event to fire on a double tap/click
         */
        onDoubleTap: () => void;
        /**
         * Event to fire on a long tap/click
         */
        onLongTap: () => void;
    }
}
