var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/// <reference path="../libs/core/enums.d.ts"/>
var pxsim;
(function (pxsim) {
    var loops;
    (function (loops) {
        // /**
        //  * Repeats the code forever in the background. On each iteration, allows other code to run.
        //  * @param body the code to repeat
        //  */
        // //% help=functions/forever weight=55 blockGap=8
        // //% blockId=device_forever block="forever"
        // export function forever(body: RefAction): void {
        //     thread.forever(body)
        // }
        /**
         * Pause for the specified time in milliseconds
         * @param ms how long to pause for, eg: 100, 200, 500, 1000, 2000
         */
        //% help=functions/pause weight=54
        //% block="pause (ms) %pause" blockId=device_pause
        function pauseAsync(ms) {
            return Promise.delay(ms);
        }
        loops.pauseAsync = pauseAsync;
    })(loops = pxsim.loops || (pxsim.loops = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    var LRFEyeMessages;
    (function (LRFEyeMessages) {
        /** Changes the color of the eyes using a boomerang, zigzag, flat, flip, or random pattern. */
        //% blockId=LRFEyeMessages_pattern
        //% block="pattern with start %startColor | end %endColor | boomerang %boomerang | zigzag %zigzag | flat %flat | flip %flip | random %random | duration %duration"
        //% weight=200
        function pattern(startColor, endColor, boomerang, zigzag, flat, flip, random, duration) {
            return new pxsim.LRFPattern(endColor, startColor, boomerang, zigzag, flat, flip, random, duration);
        }
        LRFEyeMessages.pattern = pattern;
        /** Changes the eyes color from start to end using a fade pattern. */
        //% blockId=basic_pattern
        //% block="pattern with start %startColor | end %endColor | duration %duration"
        //% weight=190
        function basicPattern(startColor, endColor, duration) {
            if (duration === void 0) { duration = 3 /* medium */; }
            return new pxsim.LRFPattern(endColor, startColor, false, false, false, false, false, duration);
        }
        LRFEyeMessages.basicPattern = basicPattern;
        /**
         * Defines an RGB color. Use "red", "green", and "blue" to define how much of each color you want to mix. Each color can be between 0 and 255
         * @param red [0-255]; eg: 255, 100, 0
         * @param green [0-255]; eg: 255, 100, 0
         * @param blue [0-255]; eg: 255, 100, 0
         */
        //% blockId=rgb_color
        //% block="rgb color with red %red | green %green | blue %blue"
        //% blockExternalInputs=true
        //% weight=180
        function rgbColor(red, green, blue) {
            return new pxsim.LRFRgbColour(red, green, blue);
        }
        LRFEyeMessages.rgbColor = rgbColor;
        /** Blinks the plugged in pattern on the robot's eyes. */
        //% blockId=blink_pattern
        //% block="blink pattern %pattern"
        //% weight=170
        function blinkPattern(pattern) {
            pxsim.board().blinkPattern(pattern);
        }
        LRFEyeMessages.blinkPattern = blinkPattern;
        /**
         * Sets the color of both your LRF's eyes.
         */
        //% blockId=set_eye_color_both
        //% block="set eyes to color %color"
        //% weight=160
        function setEyeColorBoth(color) {
            pxsim.board().changeEyeColours(color, color);
        }
        LRFEyeMessages.setEyeColorBoth = setEyeColorBoth;
        /**
         * Sets the colors for your LRF's eyes
         * @param left
         * @param right
         */
        //% block
        //% weight=150
        function setEyeColors(left, right) {
            pxsim.board().changeEyeColours(left, right);
        }
        LRFEyeMessages.setEyeColors = setEyeColors;
        /**
         * Sets the color of both eyes using an 'rgb color' value
         * @param rgb
         */
        //% blockId=set_eye_rgb_left
        //% block="set eyes to rgb %rgb"
        //% weight=140
        function setEyesRbg(rgb) {
            if (rgb === void 0) { rgb = new pxsim.LRFRgbColour(0, 0, 0); }
            pxsim.board().changeEyeRgb(rgb, rgb);
        }
        LRFEyeMessages.setEyesRbg = setEyesRbg;
        /**
         * Sets the color of your LRF's eyes using 'rgb color' values
         * @param left
         * @param right
         */
        //% blockId=set_eyes_rgb
        //% block="set 'rgb color' for left eye %left | and right eye %right"
        //% blockExternalInputs=true
        //% weight=130
        function setEyeRGB(left, right) {
            if (left === void 0) { left = new pxsim.LRFRgbColour(0, 0, 0); }
            if (right === void 0) { right = new pxsim.LRFRgbColour(0, 0, 0); }
            pxsim.board().changeEyeRgb(left, right);
        }
        LRFEyeMessages.setEyeRGB = setEyeRGB;
        /**
         * Sets both eye colors to none.
         */
        //% block
        //% weight=120
        function turnEyesOff() {
            pxsim.board().changeEyeColours(0 /* none */, 0 /* none */);
        }
        LRFEyeMessages.turnEyesOff = turnEyesOff;
    })(LRFEyeMessages = pxsim.LRFEyeMessages || (pxsim.LRFEyeMessages = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    var LRFSoundMessages;
    (function (LRFSoundMessages) {
        /**
         * Describes a sound object. Define the note, its octave, intonation, duration, and the pause after it.
         * @param note
         * @param octave
         * @param intonation
         * @param duration
         * @param pause
         */
        //% blockId="sound"
        //% block="sound with note %note|octave %octave|intonation %intonation|duration %duration|pause %pause"
        //% weight=200
        function sound(note, octave, intonation, duration, pause) {
            return new pxsim.LRFSound(note, octave, intonation, duration, pause);
        }
        LRFSoundMessages.sound = sound;
        //% blockId="basic_sound"
        //% block="sound with note %note|duration %duration|pause %pause"
        //% weight=190
        function basicSound(note, duration, pause) {
            return new pxsim.LRFSound(note, 3 /* mid */, 0 /* flat */, duration, pause);
        }
        LRFSoundMessages.basicSound = basicSound;
        /**
         * Say a sound
         * @param sound
         */
        //% blockId="say_single_sound"
        //% block="say a sound %sound"
        //% weight=180
        function saySound(sound) {
            // console.log(JSON.stringify(sound));
            pxsim.board().playSound(sound);
        }
        LRFSoundMessages.saySound = saySound;
        /**
         * Say a set of sounds in order. Create a variable and set it to an array of sounds.
         * @param sounds
         */
        //% blockId="say_multi_sounds"
        //% block="say some sounds %sounds"
        //% weight=170
        function saySounds(sounds) {
            pxsim.board().playSoundSet(sounds);
        }
        LRFSoundMessages.saySounds = saySounds;
        /**
         * Sounds a frequency on the speaker in Hertz (Hz).
         * @param freq the frequency to play; eg: 440
         */
        //% blockId="sound_freq"
        //% block="set speaker to frequency %freq"
        //% weight=160
        function setSpeakerToFrequency(freq) {
            pxsim.board().speechSet(freq);
        }
        LRFSoundMessages.setSpeakerToFrequency = setSpeakerToFrequency;
        /**
         * Sets the speaker frequency to 0.
         */
        //% block
        //% weight=150
        function turnOffSpeaker() {
            pxsim.board().speechSet(0);
        }
        LRFSoundMessages.turnOffSpeaker = turnOffSpeaker;
    })(LRFSoundMessages = pxsim.LRFSoundMessages || (pxsim.LRFSoundMessages = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    var LRFExpressions;
    (function (LRFExpressions) {
        /** A custom expression made of up to 4 sounds and a pattern. */
        //% blockId=LRFExpressions_expression
        //% block="expression with pattern %pattern|sound 1 %sound1|sound 2 %sound2|sound 3 %sound3|sound 4 %sound4"
        //% weight=200
        function expression(pattern, sound1, sound2, sound3, sound4) {
            // debugger;
            if (sound2 === void 0) { sound2 = null; }
            if (sound3 === void 0) { sound3 = null; }
            if (sound4 === void 0) { sound4 = null; }
            var snd = [];
            if (sound1)
                snd.push(sound1);
            if (sound2)
                snd.push(sound2);
            if (sound3)
                snd.push(sound3);
            if (sound4)
                snd.push(sound4);
            return new pxsim.SoundCollection(snd, pattern);
        }
        LRFExpressions.expression = expression;
        /** Plays the plugged in custom expression on the robot */
        //% blockId=LRFExpressions_blinkAndSayExpression
        //% block="blink & say expression %expression"
        //% weight=190
        function blinkAndSayExpression(expression) {
            pxsim.board().blinkAndSay(expression);
        }
        LRFExpressions.blinkAndSayExpression = blinkAndSayExpression;
        /** Play one of the built-in hello expressions */
        //% blockId=LRFExpressions_doHello
        //% block="do hello expression %expression"
        //% weight=180
        function doHello(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doHello = doHello;
        /** Play one of the built-in mood expressions */
        //% blockId=LRFExpressions_doMood
        //% block="do mood expression %expression"
        //% weight=170
        function doMood(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doMood = doMood;
        /** Play one of the built-in laugh expressions */
        //% blockId=LRFExpressions_doLaugh
        //% block="do laugh expression %expression"
        //% weight=160
        function doLaugh(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doLaugh = doLaugh;
        /** Play one of the built-in cry expressions */
        //% blockId=LRFExpressions_doCry
        //% block="do cry expression %expression"
        //% weight=150
        function doCry(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doCry = doCry;
        /** Play one of the built-in scared expressions */
        //% blockId=LRFExpressions_doScared
        //% block="do scared expression %expression"
        //% weight=140
        function doScared(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doScared = doScared;
        /** Play one of the built-in sleepy expressions */
        //% blockId=LRFExpressions_doSleepy
        //% block="do sleepy expression %expression"
        //% weight=130
        function doSleepy(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doSleepy = doSleepy;
        /** Play one of the built-in system expressions */
        //% blockId=LRFExpressions_doSystem
        //% block="do system expression %expression"
        //% weight=120
        function doSystem(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doSystem = doSystem;
        /** Play one of the built-in whoa expressions */
        //% blockId=LRFExpressions_doWhoa
        //% block="do whoa expression %expression"
        //% weight=110
        function doWhoa(expression) {
            pxsim.board().doExpression(expression);
        }
        LRFExpressions.doWhoa = doWhoa;
    })(LRFExpressions = pxsim.LRFExpressions || (pxsim.LRFExpressions = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    var LRFInputEvents;
    (function (LRFInputEvents) {
        /** Code inside this block will run when the robot's hair is tapped, touched, or tickled. Choose which one in the dropdown */
        //% blockId=on_hair_touched
        //% block="on hair %type"
        //% weight=205
        function onHairTouchedEvent(type, body) {
            pxsim.pxtcore.registerWithBoard(0 /* hair */, type, body);
        }
        LRFInputEvents.onHairTouchedEvent = onHairTouchedEvent;
        /** Code inside this block will run when the robot's left hand is tapped, touched, or tickled. Choose which one in the dropdown */
        //% blockId=on_hand_touched_left
        //% block="on left hand %type"
        //% weight=204
        function onHandTouchedLeft(type, body) {
            pxsim.pxtcore.registerWithBoard(1 /* leftHand */, type, body);
        }
        LRFInputEvents.onHandTouchedLeft = onHandTouchedLeft;
        /** Code inside this block will run when the robot's right hand is tapped, touched, or tickled. Choose which one in the dropdown */
        //% blockId=on_hand_touched_right
        //% block="on right hand %type"
        //% weight=203
        function onHandTouchedRight(type, body) {
            pxsim.pxtcore.registerWithBoard(2 /* rightHand */, type, body);
        }
        LRFInputEvents.onHandTouchedRight = onHandTouchedRight;
        /** Code inside this block will run when the robot hears a normal or loud sound. Choose the type in the dropdown. */
        //% blockId=on_sound_detected
        //% block="on sound %type"
        //% weight=202
        function onSoundDetected(type, body) {
            pxsim.pxtcore.registerWithBoard(3 /* soundSensor */, type, body);
        }
        LRFInputEvents.onSoundDetected = onSoundDetected;
        /** Code inside this block will run when the robot detects a level of light. Choose which kind of light to detect in the dropdown */
        //% blockId=on_light_detected
        //% block="on light %type"
        //% weight=201
        function onLightType(type, body) {
            pxsim.pxtcore.registerWithBoard(4 /* lightSensor */, type, body);
        }
        LRFInputEvents.onLightType = onLightType;
        /** Code inside this block will run when the robot detects some motion. Choose which type of motion in the dropdown */
        //% blockId=on_motion
        //% block="on motion %type"
        //% weight=200
        function onMotion(type, body) {
            pxsim.pxtcore.registerWithBoard(5 /* motionSensor */, type, body);
        }
        LRFInputEvents.onMotion = onMotion;
        /**
         * ADD DESCRIPTION PLZ
         */
        //% blockId=touch_read
        //% block="read touch sensor %channel"
        //% weight=300
        function touchRead(channel) {
            var value = pxsim.board().touchRead(channel);
            pxsim.console.log("[API] touchRead: " + channel + " " + value);
            return value;
        }
        LRFInputEvents.touchRead = touchRead;
        /**
         * ADD DESCRIPTION PLZ
         */
        //% blockId=hearing_read
        //% block="read microphone"
        //% weight=290
        function hearingRead() {
            var value = pxsim.board().hearingRead();
            pxsim.console.log("[API] hearingRead: " + value);
            return value;
        }
        LRFInputEvents.hearingRead = hearingRead;
        /**
         * ADD DESCRIPTION PLZ
         */
        //% blockId=sight_read
        //% block="read photocell"
        //% weight=280
        function sightRead() {
            var value = pxsim.board().sightRead();
            pxsim.console.log("[API] sightRead: " + value);
            return value;
        }
        LRFInputEvents.sightRead = sightRead;
        /**
         * ADD DESCRIPTION PLZ
         */
        //% blockId=motion_read
        //% block="read accelerometer %channel"
        //% weight=270
        function motionRead(channel) {
            var value = pxsim.board().motionRead(channel);
            pxsim.console.log("[API] motionRead: " + channel + " " + value);
            return value;
        }
        LRFInputEvents.motionRead = motionRead;
    })(LRFInputEvents = pxsim.LRFInputEvents || (pxsim.LRFInputEvents = {}));
})(pxsim || (pxsim = {}));
function logMsg(m) { console.log(m); }
var pxsim;
(function (pxsim) {
    var console;
    (function (console) {
        /**
         * Print out message
         */
        //%
        function log(msg) {
            logMsg("CONSOLE: " + msg);
            // why doesn't that work?
            // board().writeSerial(msg + "\n")
        }
        console.log = log;
    })(console = pxsim.console || (pxsim.console = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    //%
    var LRFRgbColour = (function () {
        function LRFRgbColour(r, g, b) {
            if (r === void 0) { r = 0; }
            if (g === void 0) { g = 0; }
            if (b === void 0) { b = 0; }
            this.red = r;
            this.green = g;
            this.blue = b;
        }
        LRFRgbColour.prototype.styleString = function () {
            return 'rgb(' + this.red + "," + this.green + "," + this.blue + ")";
        };
        return LRFRgbColour;
    }());
    pxsim.LRFRgbColour = LRFRgbColour;
    //%
    var LRFSound = (function () {
        function LRFSound(note, octave, intonation, duration, pause) {
            if (note === void 0) { note = 6 /* ds */; }
            if (octave === void 0) { octave = 4 /* midhigh */; }
            if (intonation === void 0) { intonation = 0 /* flat */; }
            if (duration === void 0) { duration = 5 /* long */; }
            if (pause === void 0) { pause = 1 /* short */; }
            this.note = note;
            this.octave = octave;
            this.intonation = intonation;
            this.duration = duration;
            this.pause = pause;
        }
        LRFSound.prototype.getRaw = function () {
            var rawValue = (this.note << 0) |
                (this.octave << 4) |
                (this.intonation << 7) |
                (this.duration << 10) |
                (this.pause << 13);
            var swap = (rawValue << 8) | (rawValue >> 8);
            // console.log("swap is: " + swap);
            //Returns 16 bit packed integer
            return swap; //rawValue;
        };
        LRFSound.prototype.unpackRaw = function (raw) {
            var swap = (raw << 8) | (raw >> 8);
            this.note = swap & 0xf;
            this.octave = (swap >> 4) & 0x7;
            this.intonation = (swap >> 7) & 0x7;
            this.duration = (swap >> 10) & 0x7;
            this.pause = (swap >> 13) & 0x7;
        };
        return LRFSound;
    }());
    pxsim.LRFSound = LRFSound;
    //%
    var LRFPattern = (function () {
        function LRFPattern(rightLed, leftLed, boomerang, zigzag, flat, flip, random, duration) {
            if (duration === void 0) { duration = 5 /* long */; }
            this.rightLed = rightLed;
            this.leftLed = leftLed;
            this.boomerang = boomerang ? 1 : 0;
            this.zigzag = zigzag ? 1 : 0;
            this.flat = flat ? 1 : 0;
            this.flip = flip ? 1 : 0;
            this.random = random ? 1 : 0;
            this.duration = duration;
        }
        LRFPattern.prototype.getRaw = function () {
            var rawValue = (this.leftLed << 8) |
                (this.rightLed << 12) |
                //bit shifting booleans works, but is this language spec, good part spec?
                (this.boomerang << 0) |
                (this.zigzag << 1) |
                (this.flat << 2) |
                (this.flip << 3) |
                (this.random << 4) |
                (this.duration << 5);
            //returns 16 bit packed integer value
            return rawValue;
        };
        //Raw: Uint16
        LRFPattern.prototype.unpackRaw = function (raw) {
            this.leftLed = (raw >> 8) & 0xf;
            this.rightLed = (raw >> 12) & 0xf;
            this.boomerang = (raw >> 0) & 0x1;
            this.zigzag = (raw >> 1) & 0x1;
            this.flat = (raw >> 2) & 0x1;
            this.flip = (raw >> 3) & 0x1;
            this.random = (raw >> 4) & 0x1;
            this.duration = (raw >> 5) & 0x7;
        };
        return LRFPattern;
    }());
    pxsim.LRFPattern = LRFPattern;
    //%
    var SoundCollection = (function () {
        function SoundCollection(sounds, pattern) {
            this.sounds = [];
            this.uname = 'custom_expression';
            this.sounds = sounds;
            this.pattern = pattern;
        }
        // assign(properties) {
        //     Object.assign(this.pattern, properties.pattern);
        //     let sc = this;
        //     properties.sounds.forEach((sourceSound, index) => {
        //         if (typeof sc.sounds[index] === 'undefined') {
        //             sc.sounds.push(new LRFSound());
        //         }
        //         Object.assign(sc.sounds[index], sourceSound);
        //     });
        //     if (properties.uname) this.uname = properties.uname;
        // }
        //[isStrictComparison] will also compare the uname of both expressions. Defalts to false
        SoundCollection.prototype.isEqual = function (soundCollection, isStrictComparison) {
            if (isStrictComparison === void 0) { isStrictComparison = false; }
            //if strict comparison check unames
            if (isStrictComparison && this.uname !== soundCollection.uname)
                return false;
            //False if different lengths
            if (this.sounds.length !== soundCollection.sounds.length)
                return false;
            //False if different patterns
            if (this.pattern.getRaw() !== soundCollection.pattern.getRaw())
                return false;
            var numSounds = this.sounds.length;
            for (var i = 0; i < numSounds; i++) {
                if (this.sounds[i].getRaw() !== soundCollection.sounds[i].getRaw())
                    return false;
            }
            return true;
        };
        return SoundCollection;
    }());
    pxsim.SoundCollection = SoundCollection;
})(pxsim || (pxsim = {}));
/** A reference object to the LRFWebcore object loaded into the window by ptx */
var core = window.parent["LRFWebcore"];
var LRFEvents = core.events;
// namespace LRFEvents{
//     const r = core.events;
//     // export const on = r.on;
//     export function on(event, fn, context?){
//         r.on(event, fn, context);
//     }
// }
var LRFSerial;
(function (LRFSerial) {
    var s = core.serial;
    LRFSerial.connection = s.connection;
    LRFSerial.isConnected = s.isConnected;
    function setReceiveCallback(callback) {
        s.setReceiveCallback(callback);
    }
    LRFSerial.setReceiveCallback = setReceiveCallback;
})(LRFSerial || (LRFSerial = {}));
/**
 * A namespace to export LRFComm from lrf-webcore
 */
var LRFComm;
(function (LRFComm) {
    var c = core.comm;
    LRFComm.EVENT = c.EVENT;
    LRFComm.unpack = c.unpack;
    LRFComm.send = c.send;
    LRFComm.sendAwaitingResponse = c.sendAwaitingResponse;
    LRFComm.getCharacterName = c.getCharacterName;
    LRFComm.eventsGetMap = c.eventsGetMap;
    LRFComm.getCustomPresetExpression = c.getCustomPresetExpression;
    LRFComm.getPresetExpressions = c.getPresetExpressions;
    LRFComm.touchRead = c.touchRead;
})(LRFComm || (LRFComm = {}));
/**
 * A namespace to expose LRFMessages from lrf-webcore
 */
var LRFMessages;
(function (LRFMessages) {
    var m = core.messages;
    LRFMessages.lrfMessageCode = m.lrfMessageCode;
    LRFMessages.LRFPATTERN_SIZE = m.LRFPATTERN_SIZE;
    LRFMessages.LRFSOUND_SIZE = m.LRFSOUND_SIZE;
    LRFMessages.LRFEXPRESSION_SIZE = m.LRFEXPRESSION_SIZE;
    LRFMessages.LRFMEMORYINDEX_SIZE = m.LRFMEMORYINDEX_SIZE;
    LRFMessages.headerLength = m.headerLength;
    LRFMessages.footerLength = m.footerLength;
    LRFMessages.minBodyLength = m.minBodyLength;
    LRFMessages.startByte = m.startByte;
    LRFMessages.endByte = m.endByte;
    LRFMessages.minMessageLength = m.minMessageLength;
    LRFMessages.getCRC = m.getCRC;
    LRFMessages.getRobotInfo = m.getRobotInfo;
    LRFMessages.getCharacterName = m.getCharacterName;
    LRFMessages.setCharacterName = m.setCharacterName;
    LRFMessages.eventsSetMap = m.eventsSetMap;
    LRFMessages.eventsGetMap = m.eventsGetMap;
    LRFMessages.eyesSet = m.eyesSet;
    LRFMessages.eyesSetColors = m.eyesSetColors;
    LRFMessages.eyesBlinkPatterns = m.eyesBlinkPatterns;
    LRFMessages.speechSet = m.speechSet;
    LRFMessages.speechSaySounds = m.speechSaySounds;
    LRFMessages.blinkAndSayPreset = m.blinkAndSayPreset;
    LRFMessages.blinkAndSayPresetWithIndex = m.blinkAndSayPresetWithIndex;
    LRFMessages.blinkAndSay = m.blinkAndSay;
    LRFMessages.getPresetExpressions = m.getPresetExpressions;
    LRFMessages.getCustomPresetExpression = m.getCustomPresetExpression;
    LRFMessages.setCustomPresetExpression = m.setCustomPresetExpression;
    LRFMessages.chatter = m.chatter;
    LRFMessages.singSong = m.singSong;
    LRFMessages.setPresetSong = m.setPresetSong;
    LRFMessages.getPresetSong = m.getPresetSong;
})(LRFMessages || (LRFMessages = {}));
/**
 * A namespace to expose LRFTypes from lrf-webcore.
 */
var LRFTypes;
(function (LRFTypes) {
    var t = core.types;
    LRFTypes.LRFOctave = t.LRFOctave;
    LRFTypes.LRFNote = t.LRFNote;
    LRFTypes.LRFIntonation = t.LRFIntonation;
    LRFTypes.LRFDuration = t.LRFDuration;
    LRFTypes.LRFColor = t.LRFColor;
    LRFTypes.LRFPersonalityTraits = t.LRFPersonalityTraits;
    LRFTypes.LRFTransform = t.LRFTransform;
    LRFTypes.LRFAction = t.LRFAction;
    LRFTypes.actionRange = t.actionRange;
    LRFTypes.sensorMap = t.sensorMap;
    LRFTypes.LRFExpression = t.LRFExpression;
    LRFTypes.LRFSound = t.LRFSound;
    LRFTypes.LRFPattern = t.LRFPattern;
    LRFTypes.SoundCollection = t.SoundCollection;
    LRFTypes.RobotType = t.RobotType;
    LRFTypes.typeTable = t.typeTable;
    LRFTypes.CONSTANTS = t.CONSTANTS;
    LRFTypes.robotTypeLookup = t.robotTypeLookup;
})(LRFTypes || (LRFTypes = {}));
var LRFRobotModel;
(function (LRFRobotModel) {
    var rm = core.model;
    LRFRobotModel.senses = rm.senses;
})(LRFRobotModel || (LRFRobotModel = {}));
/// <reference path="../node_modules/pxt-core/typings/globals/bluebird/index.d.ts"/>
/// <reference path="../node_modules/pxt-core/built/pxtsim.d.ts"/>
var pxsim;
(function (pxsim) {
    var pxtcore;
    (function (pxtcore) {
        function registerWithBoard(id, eventId, eventHander) {
            pxsim.board().bus.listen(id, eventId, eventHander);
        }
        pxtcore.registerWithBoard = registerWithBoard;
    })(pxtcore = pxsim.pxtcore || (pxsim.pxtcore = {}));
})(pxsim || (pxsim = {}));
var pxsim;
(function (pxsim) {
    /**
     * This function gets called each time the program restarts
     */
    pxsim.initCurrentRuntime = function () {
        pxsim.runtime.board = getBoard();
    };
    /**
     * Gets the current 'board', eg. program state.
     */
    function board() {
        return pxsim.runtime.board;
    }
    pxsim.board = board;
    var currentBoard;
    function getBoard() {
        if (LRFSerial.isConnected()) {
            pxsim.console.log("Robot connected, loading hard board...");
            document.getElementById("plugged-in").style.visibility = "visible";
            document.getElementById("btn-div").style.visibility = "hidden";
            document.getElementById("svgcanvas").style.visibility = "hidden";
            var simframe = window.parent.document.getElementsByClassName("simframe")[0];
            window.console.log(simframe);
            simframe.style.paddingBottom = "81.96%";
            LRFEvents.removeAllListeners(LRFComm.EVENT.EVENT_RECEIVED);
            currentBoard = new LRFHardBoard();
            LRFEvents.on(LRFComm.EVENT.EVENT_RECEIVED, currentBoard.triggerInputAction);
            return currentBoard;
        }
        else {
            pxsim.console.log("No robot connected, loading soft board...");
            document.getElementById("svgcanvas").style.visibility = "visible";
            document.getElementById("btn-div").style.visibility = "visible";
            document.getElementById("plugged-in").style.visibility = "hidden";
            var simframe = window.parent.document.getElementsByClassName("simframe")[0];
            window.console.log(simframe);
            simframe.style.paddingBottom = "180%";
            return new LRFSoftBoard();
        }
    }
    var LRFBoard = (function (_super) {
        __extends(LRFBoard, _super);
        function LRFBoard() {
            _super.call(this);
        }
        return LRFBoard;
    }(pxsim.CoreBoard));
    pxsim.LRFBoard = LRFBoard;
    /**
    * A board to use if there is no LRF connected. Controls the simulator.
    *
    * Represents the entire state of the executing program.
    * Do not store state anywhere else!
    */
    var LRFSoftBoard = (function (_super) {
        __extends(LRFSoftBoard, _super);
        function LRFSoftBoard() {
            var _this = this;
            _super.call(this);
            this.colour = 'white';
            this.onStateChanged = function () {
                if (!pxsim.runtime.running) {
                    pxsim.AudioContextManager.stop();
                    if (_this.soundTimeout)
                        clearTimeout(_this.soundTimeout);
                    _this.soundTimeout = null;
                    _this.setSimulatorToDefaultState();
                }
            };
            this.canvas = document.getElementById('svgcanvas');
            // OUTPUTS
            this.eyeLeft = this.canvas.getElementById('eyeleft');
            this.eyeRight = this.canvas.getElementById('eyeright');
            this.speaker = this.canvas.getElementById('speaker');
            // INPUTS
            this.hair = this.canvas.getElementById("hair");
            this.handLeft = this.canvas.getElementById("left-hand");
            this.handRight = this.canvas.getElementById("right-hand");
            this.soundSensor = this.canvas.getElementById('sound-sensor');
            this.lightSensor = this.canvas.getElementById('light-sensor');
            // EVENT BUTTONS
            this.tooDarkLong = document.getElementById("action-btn-toodarklong");
            this.tooDark = document.getElementById("action-btn-toodark");
            this.lightNormal = document.getElementById("action-btn-lightnormal");
            this.tooBright = document.getElementById("action-btn-toobright");
            this.toobrightlong = document.getElementById("action-btn-toobrightlong");
            this.layLeft = document.getElementById("action-btn-layleft");
            this.layRight = document.getElementById("action-btn-layright");
            this.shake = document.getElementById("action-btn-shake");
            this.tiltLeft = document.getElementById("action-btn-tiltleft");
            this.tiltRight = document.getElementById("action-btn-tiltright");
            this.loud = document.getElementById("action-btn-loud");
            this.soundNormal = document.getElementById("action-btn-soundnormal");
        }
        LRFSoftBoard.prototype.speechSet = function (frequency) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.blinkAndSay = function (expression) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.blinkPattern = function (pattern) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.blinkPatterns = function (patterns) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.touchRead = function (channel, callback) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.hearingRead = function (callback) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.sightRead = function (callback) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.motionRead = function (channel, callback) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.setSimulatorToDefaultState = function () {
            this.eyeLeft.style.fill = 'white';
            this.eyeRight.style.fill = 'white';
            this.eyeRight.style.fillOpacity = '1';
            this.eyeLeft.style.fillOpacity = '1';
            this.speaker.style.fill = "#e5e6e6";
        };
        LRFSoftBoard.prototype.initAsync = function (msg) {
            // document.body.innerHTML = ''; // clear children
            // document.body.appendChild(this.canvas);
            this.setSimulatorToDefaultState();
            pxsim.runtime.stateChanged = this.onStateChanged;
            this.setInputEvents();
            return Promise.resolve();
        };
        LRFSoftBoard.prototype.setInputEvents = function () {
            var _this = this;
            var hairTouchManager = new LRFUtils.LRFTouchClickManager(this.hair, function () {
                _this.bus.queue(0 /* hair */, 0 /* tapped */);
            }, function () {
                _this.bus.queue(0 /* hair */, 1 /* tickled */);
            }, function () {
                _this.bus.queue(0 /* hair */, 2 /* holdHug */);
            });
            var leftHandTouchManager = new LRFUtils.LRFTouchClickManager(this.handLeft, function () {
                _this.bus.queue(1 /* leftHand */, 0 /* tapped */);
            }, function () {
                _this.bus.queue(1 /* leftHand */, 1 /* tickled */);
            }, function () {
                _this.bus.queue(1 /* leftHand */, 2 /* holdHug */);
            });
            var rightHandTouchManager = new LRFUtils.LRFTouchClickManager(this.handRight, function () {
                _this.bus.queue(2 /* rightHand */, 0 /* tapped */);
            }, function () {
                _this.bus.queue(2 /* rightHand */, 1 /* tickled */);
            }, function () {
                _this.bus.queue(2 /* rightHand */, 2 /* holdHug */);
            });
            this.tooDarkLong.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(4 /* lightSensor */, 0 /* tooDarkLong */);
            });
            this.tooDark.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(4 /* lightSensor */, 1 /* dark */);
            });
            this.lightNormal.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(4 /* lightSensor */, 2 /* normal */);
            });
            this.tooBright.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(4 /* lightSensor */, 3 /* bright */);
            });
            this.toobrightlong.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(4 /* lightSensor */, 4 /* tooBrightLong */);
            });
            this.layLeft.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(5 /* motionSensor */, 2 /* layLeft */);
            });
            this.layRight.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(5 /* motionSensor */, 3 /* layRight */);
            });
            this.shake.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(5 /* motionSensor */, 4 /* shake */);
            });
            this.tiltLeft.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(5 /* motionSensor */, 0 /* tiltLeft */);
            });
            this.tiltRight.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(5 /* motionSensor */, 1 /* tiltRight */);
            });
            this.loud.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(3 /* soundSensor */, 1 /* loud */);
            });
            this.soundNormal.addEventListener(pxsim.pointerEvents.up, function (ev) {
                _this.bus.queue(3 /* soundSensor */, 0 /* normal */);
            });
        };
        LRFSoftBoard.prototype.updateView = function () {
            // this.eyeLeft.style.fill = this.colour;
            // this.eyeRight.style.fill = this.colour;
        };
        LRFSoftBoard.prototype.postMessage = function (msg) {
            pxsim.console.log(msg);
        };
        LRFSoftBoard.prototype.changeEyeRgb = function (left, right) {
            this.eyeLeft.style.fill = left ? left.styleString() : this.eyeLeft.style.fill;
            this.eyeRight.style.fill = right ? right.styleString() : this.eyeRight.style.fill;
        };
        LRFSoftBoard.prototype.changeEyeAlpha = function (left, right) {
            if (left < 0) {
                left = parseFloat(this.eyeLeft.style.fillOpacity);
            }
            if (right < 0) {
                right = parseFloat(this.eyeRight.style.fillOpacity);
            }
            left /= 10;
            right /= 10;
            this.eyeLeft.style.fillOpacity = left.toString();
            this.eyeRight.style.fillOpacity = right.toString();
        };
        LRFSoftBoard.prototype.changeEyeColours = function (left, right) {
            this.eyeLeft.style.fill = left ? this.getColourForValue(left) : this.eyeLeft.style.fill;
            this.eyeRight.style.fill = right ? this.getColourForValue(right) : this.eyeRight.style.fill;
        };
        LRFSoftBoard.prototype.playSound = function (sound, callback) {
            var _this = this;
            if (callback === void 0) { callback = function () { }; }
            this.speaker.style.fill = "grey";
            var frequency = this.getFreqForNote(sound.note);
            var octave = sound.octave + 4;
            frequency *= octave;
            pxsim.AudioContextManager.tone(frequency, 1);
            this.soundTimeout = setTimeout(function () {
                _this.speaker.style.fill = "#e5e6e6";
                pxsim.AudioContextManager.stop();
                setTimeout(function () {
                    callback();
                }, _this.getTimeForDuration(sound.pause));
                // callback();
            }, this.getTimeForDuration(sound.duration) + 10);
        };
        LRFSoftBoard.prototype.getTimeForDuration = function (duration) {
            var t = 0;
            switch (duration) {
                case 0 /* none */:
                    t = 0;
                    break;
                case 1 /* short */:
                    t = 50; //1 block
                    break;
                case 2 /* doubleShort */:
                    t = 100; //2 blocks
                    break;
                case 3 /* medium */:
                    t = 200; //4 blocks
                    break;
                case 4 /* doubleMedium */:
                    t = 400; //8 blocks
                    break;
                case 5 /* long */:
                    t = 800; //16 blocks
                    break;
                case 6 /* doubleLong */:
                    t = 1600;
                    break;
                case 7 /* veryLong */:
                    t = 3200;
                    break;
            }
            return t;
        };
        LRFSoftBoard.prototype.getFreqForNote = function (note) {
            var f = 0;
            switch (note) {
                case 0 /* a */:
                    f = 55;
                    break;
                case 1 /* as */:
                    f = 58;
                    break;
                case 2 /* b */:
                    f = 62;
                    break;
                case 3 /* c */:
                    f = 65;
                    break;
                case 4 /* cs */:
                    f = 69;
                    break;
                case 5 /* d */:
                    f = 73;
                    break;
                case 6 /* ds */:
                    f = 78;
                    break;
                case 7 /* e */:
                    f = 82;
                    break;
                case 8 /* f */:
                    f = 87;
                    break;
                case 9 /* fs */:
                    f = 92;
                    break;
                case 10 /* g */:
                    f = 98;
                    break;
                case 11 /* gs */:
                    f = 10;
                    break;
                case 12 /* mute */:
                    f = -1;
                    break;
                default:
                    f = 0;
                    break;
            }
            return f;
        };
        LRFSoftBoard.prototype.playSoundSet = function (sounds, i, callback) {
            var _this = this;
            if (i === void 0) { i = 0; }
            if (callback === void 0) { callback = function () { }; }
            if (pxsim.runtime.running) {
                this.playSound(sounds.getAt(i), function () {
                    var next = i + 1;
                    if (next < sounds.getLength()) {
                        _this.playSoundSet(sounds, next, callback);
                    }
                    else if (next == sounds.getLength()) {
                        callback();
                    }
                });
            }
        };
        LRFSoftBoard.prototype.chatter = function () {
            var rand = Math.floor(Math.random() * 100) + 1;
            var sounds = new pxsim.RefCollection();
            for (var i = 0; i < rand; i++) {
                var randNoteIndex = Math.floor(Math.random() * 12) + 1;
                var note = 0 /* a */;
                switch (randNoteIndex) {
                    case 1:
                        note = 0 /* a */;
                        break;
                    case 2:
                        note = 1 /* as */;
                        break;
                    case 3:
                        note = 2 /* b */;
                        break;
                    case 4:
                        note = 3 /* c */;
                        break;
                    case 5:
                        note = 4 /* cs */;
                        break;
                    case 6:
                        note = 5 /* d */;
                        break;
                    case 7:
                        note = 6 /* ds */;
                        break;
                    case 8:
                        note = 7 /* e */;
                        break;
                    case 9:
                        note = 8 /* f */;
                        break;
                    case 10:
                        note = 9 /* fs */;
                        break;
                    case 11:
                        note = 10 /* g */;
                        break;
                    case 12:
                        note = 11 /* gs */;
                        break;
                }
                var octave = Math.floor(Math.random() * 7);
                var randDurationIndex = Math.floor(Math.random() * 5);
                var duration = 1 /* short */;
                switch (randDurationIndex) {
                    case 1:
                        duration = 1 /* short */;
                        break;
                    case 2:
                        duration = 2 /* doubleShort */;
                        break;
                    case 3:
                        duration = 3 /* medium */;
                        break;
                    case 4:
                        duration = 4 /* doubleMedium */;
                        break;
                    case 5:
                        duration = 5 /* long */;
                        break;
                    case 6:
                        duration = 6 /* doubleLong */;
                        break;
                    case 7:
                        duration = 7 /* veryLong */;
                        break;
                }
                sounds.push(new pxsim.LRFSound(note, octave, 0 /* flat */, duration, 0 /* none */));
            }
            this.doChatter(sounds, 0, function () {
            });
        };
        LRFSoftBoard.prototype.doExpression = function (expression) {
            throw new Error("Method not implemented.");
        };
        LRFSoftBoard.prototype.doChatter = function (sounds, i, callback) {
            var _this = this;
            if (i === void 0) { i = 0; }
            if (callback === void 0) { callback = function () { }; }
            if (pxsim.runtime.running) {
                var left = new pxsim.LRFRgbColour(Math.floor(Math.random() * 255), Math.floor(Math.random() * 255), Math.floor(Math.random() * 255));
                var right = new pxsim.LRFRgbColour(Math.floor(Math.random() * 255), Math.floor(Math.random() * 255), Math.floor(Math.random() * 255));
                this.changeEyeRgb(left, right);
                this.playSound(sounds.getAt(i), function () {
                    var next = i + 1;
                    if (next < sounds.getLength() && pxsim.runtime.running) {
                        _this.doChatter(sounds, next, callback);
                    }
                    else if (next == sounds.getLength() && pxsim.runtime.running) {
                        callback();
                    }
                });
            }
        };
        LRFSoftBoard.prototype.getColourForValue = function (val) {
            var colour = "none";
            switch (val) {
                case 0 /* none */:
                    colour = "none";
                    break;
                case 1 /* red */:
                    colour = "red";
                    break;
                case 2 /* green */:
                    colour = "green";
                    break;
                case 3 /* blue */:
                    colour = "blue";
                    break;
                case 4 /* orange */:
                    colour = "orange";
                    break;
                case 5 /* cyan */:
                    colour = "cyan";
                    break;
                case 6 /* purple */:
                    colour = "purple";
                    break;
                case 7 /* yellow */:
                    colour = "yellow";
                    break;
                case 8 /* pink */:
                    colour = "pink";
                    break;
                case 15 /* white */:
                    colour = "white";
                    break;
                default:
                    colour = "none";
                    break;
            }
            return colour;
        };
        return LRFSoftBoard;
    }(LRFBoard));
    pxsim.LRFSoftBoard = LRFSoftBoard;
    var LRFHardBoard = (function (_super) {
        __extends(LRFHardBoard, _super);
        function LRFHardBoard() {
            var _this = this;
            _super.call(this);
            this.touchyState = 0;
            this.lastLeftRgb = new pxsim.LRFRgbColour();
            this.lastRightRgb = new pxsim.LRFRgbColour();
            this.lastLeftColour = LRFTypes.LRFColor.none;
            this.lastRightColour = LRFTypes.LRFColor.none;
            this.triggerInputAction = function (action) {
                var actions = LRFTypes.LRFAction;
                switch (action) {
                    case actions['tap']:
                        pxsim.console.log("tapped");
                        _this.bus.queue(0 /* hair */, 0 /* tapped */);
                        break;
                    case actions['tickle']:
                        pxsim.console.log("tickled");
                        _this.bus.queue(0 /* hair */, 1 /* tickled */);
                        break;
                    case actions['hug']:
                        pxsim.console.log("hugged");
                        _this.bus.queue(0 /* hair */, 2 /* holdHug */);
                        break;
                    case actions['tap-left']:
                        pxsim.console.log("tapped left");
                        _this.bus.queue(1 /* leftHand */, 0 /* tapped */);
                        break;
                    case actions['tickle-left']:
                        pxsim.console.log("tickled left");
                        _this.bus.queue(1 /* leftHand */, 1 /* tickled */);
                        break;
                    case actions['hug-left']:
                        pxsim.console.log("hugged left");
                        _this.bus.queue(1 /* leftHand */, 2 /* holdHug */);
                        break;
                    case actions['tap-right']:
                        pxsim.console.log("tapped right");
                        _this.bus.queue(2 /* rightHand */, 0 /* tapped */);
                        break;
                    case actions['tickle-right']:
                        pxsim.console.log("tickled right");
                        _this.bus.queue(2 /* rightHand */, 1 /* tickled */);
                        break;
                    case actions['hug-right']:
                        pxsim.console.log("hugged right");
                        _this.bus.queue(2 /* rightHand */, 2 /* holdHug */);
                        break;
                    case actions['tilt-left']:
                        pxsim.console.log("tilt-left");
                        _this.bus.queue(5 /* motionSensor */, 0 /* tiltLeft */);
                        break;
                    case actions['tilt-right']:
                        pxsim.console.log("tilt-right");
                        _this.bus.queue(5 /* motionSensor */, 1 /* tiltRight */);
                        break;
                    case actions['tilt-forward']:
                        pxsim.console.log("tilt-forward");
                        break;
                    case actions['tilt-back']:
                        pxsim.console.log("tilt-back");
                        break;
                    case actions['lay-left']:
                        pxsim.console.log("lay-left");
                        _this.bus.queue(5 /* motionSensor */, 2 /* layLeft */);
                        break;
                    case actions['lay-right']:
                        pxsim.console.log("lay-right");
                        _this.bus.queue(5 /* motionSensor */, 3 /* layRight */);
                        break;
                    case actions['lay-forward']:
                        pxsim.console.log("lay-forward");
                        break;
                    case actions['lay-back']:
                        pxsim.console.log("lay-back");
                        break;
                    case actions['shake']:
                        pxsim.console.log("shake");
                        _this.bus.queue(5 /* motionSensor */, 4 /* shake */);
                        break;
                    // Light Events (0x30 - 0x3F)
                    case actions['light-normal']:
                        pxsim.console.log('light-normal');
                        _this.bus.queue(4 /* lightSensor */, 2 /* normal */);
                        break;
                    case actions['light-too-dark']:
                        pxsim.console.log('light-too-dark');
                        _this.bus.queue(4 /* lightSensor */, 1 /* dark */);
                        break;
                    case actions['light-too-bright']:
                        pxsim.console.log('light-too-bright');
                        _this.bus.queue(4 /* lightSensor */, 3 /* bright */);
                        break;
                    case actions['light-too-dark-too-long']:
                        pxsim.console.log('light-too-dark-too-long');
                        _this.bus.queue(4 /* lightSensor */, 0 /* tooDarkLong */);
                        break;
                    case actions['light-too-bright-too-long']:
                        pxsim.console.log('light-too-bright-too-long');
                        _this.bus.queue(4 /* lightSensor */, 4 /* tooBrightLong */);
                        break;
                    // Sound Events (0x40 - 0x4F)
                    case actions['sound-normal']:
                        pxsim.console.log('sound-normal');
                        _this.bus.queue(3 /* soundSensor */, 0 /* normal */);
                        break;
                    case actions['sound-too-loud']:
                        pxsim.console.log('sound-too-loud');
                        _this.bus.queue(3 /* soundSensor */, 1 /* loud */);
                        break;
                    case actions['sound-like-talking']:
                        pxsim.console.log('sound-like-talking');
                        break;
                    case actions['sound-like-no-talking']:
                        pxsim.console.log('sound-like-no-talking');
                        break;
                }
            };
        }
        LRFHardBoard.prototype.changeEyeRgb = function (left, right) {
            // throw new Error("Method not implemented.");
            if (!right) {
                right = this.lastRightRgb;
            }
            if (!left) {
                left = this.lastLeftRgb;
            }
            var msg = LRFMessages.eyesSet(left.red, left.green, left.blue, right.red, right.green, right.blue);
            LRFComm.send(msg);
            this.lastLeftRgb = left;
            this.lastRightRgb = right;
        };
        LRFHardBoard.prototype.changeEyeAlpha = function (left, right) {
        };
        LRFHardBoard.prototype.changeEyeColours = function (left, right) {
            if (left === undefined) {
                left = this.lastLeftColour;
            }
            if (right === undefined) {
                right = this.lastRightColour;
            }
            var msg = LRFMessages.eyesSetColors(left, right);
            LRFComm.send(msg);
            this.lastLeftColour = left;
            this.lastRightColour = right;
        };
        LRFHardBoard.prototype.playSound = function (sound, callback) {
            var s = new LRFTypes.LRFSound();
            s.note = sound.note;
            s.octave = sound.octave;
            s.intonation = sound.intonation;
            s.duration = sound.duration;
            s.pause = sound.pause;
            var msg = LRFMessages.speechSaySounds(s, true);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.playSoundSet = function (sounds, i, callback) {
            var s = [];
            pxsim.console.log(JSON.stringify(s));
            for (var i_1 = 0; i_1 < sounds.getLength(); i_1++) {
                var snd = new LRFTypes.LRFSound();
                snd.note = sounds.getAt(i_1).note;
                snd.octave = sounds.getAt(i_1).octave;
                snd.intonation = sounds.getAt(i_1).intonation;
                snd.duration = sounds.getAt(i_1).duration;
                snd.pause = sounds.getAt(i_1).pause;
                pxsim.console.log(JSON.stringify(sounds[i_1]));
                s.push(snd);
            }
            var msg = LRFMessages.speechSaySounds(s, true);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.speechSet = function (frequency) {
            var msg = LRFMessages.speechSet(frequency);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.chatter = function () {
            // throw new Error("Method not implemented.");
            var msg = LRFMessages.chatter();
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.doExpression = function (expression) {
            pxsim.console.log("Do expression......");
            pxsim.console.log(expression.toString());
            var msg = LRFMessages.blinkAndSayPresetWithIndex(expression, true);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.blinkPattern = function (pattern) {
            // throw new Error("Method not implemented.");
            pxsim.console.log("[SIM] blinkPattern:" + pattern);
            var msg = LRFMessages.eyesBlinkPatterns(pattern, true);
            window.console.log("BLINK PATTERN");
            window.console.log(msg);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.blinkPatterns = function (patterns) {
            // throw new Error("Method not implemented.");
            pxsim.console.log("[SIM] blinkPatterns:" + patterns);
            var msg = LRFMessages.eyesBlinkPatterns(patterns, true);
            window.console.log("BLINK PATTERNS");
            window.console.log(msg);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.blinkAndSay = function (expression) {
            // throw new Error("Method not implemented.");
            var msg = LRFMessages.blinkAndSay(expression, true);
            LRFComm.send(msg);
        };
        LRFHardBoard.prototype.postMessage = function (msg) {
            throw new Error("Method not implemented.");
        };
        // Sense Read Implementation
        // ---------------------------------------------------------
        LRFHardBoard.prototype.touchRead = function (channel, callback) {
            pxsim.console.log('[SIM] touchRead');
            var values = LRFRobotModel.senses.touch;
            pxsim.console.log("[SIM] touchRead hair:" + values.hair + " left:" + values.left + " right:" + values.right);
            var value = values.hair;
            if (channel == 1 /* left */) {
                value = values.left;
            }
            else if (channel == 2 /* right */) {
                value = values.right;
            }
            return value;
        };
        LRFHardBoard.prototype.hearingRead = function (callback) {
            pxsim.console.log('[SIM] hearingRead');
            var values = LRFRobotModel.senses.hearing;
            pxsim.console.log("[SIM] hearingRead values:" + values);
            var value = values.level;
            return value;
        };
        LRFHardBoard.prototype.sightRead = function (callback) {
            pxsim.console.log('[SIM] sightRead');
            var values = LRFRobotModel.senses.sight;
            pxsim.console.log("[SIM] sightRead values:" + values);
            var value = values.level;
            return value;
        };
        LRFHardBoard.prototype.motionRead = function (channel, callback) {
            pxsim.console.log('[SIM] motionRead');
            var values = LRFRobotModel.senses.motion;
            pxsim.console.log("[SIM] motionRead x:" + values.x + " y:" + values.y + " z:" + values.z);
            var value = values.x;
            if (channel == 1 /* y */) {
                value = values.y;
            }
            else if (channel == 2 /* z */) {
                value = values.z;
            }
            return value;
        };
        return LRFHardBoard;
    }(LRFBoard));
    pxsim.LRFHardBoard = LRFHardBoard;
})(pxsim || (pxsim = {}));
var LRFUtils;
(function (LRFUtils) {
    /**
     * Manages single, double, and long clicks/taps and attaches events to the provided object.
     */
    var LRFTouchClickManager = (function () {
        function LRFTouchClickManager(object, singleTapEvent, doubleTapEvent, longTapEvent) {
            var _this = this;
            if (singleTapEvent === void 0) { singleTapEvent = function () { }; }
            if (doubleTapEvent === void 0) { doubleTapEvent = function () { }; }
            if (longTapEvent === void 0) { longTapEvent = function () { }; }
            this.tapTimer = -1;
            this.didFirstClick = false;
            /**
             * Duration of a long touch/click
             */
            this.longTouchTime = 750;
            /**
             * Amount of time to listen for a second tap/click (doube tap/click)
             */
            this.listenForDoubleTapTime = 250;
            /**
             * Event to fire on a single tap/click
             */
            this.onSingleTap = function () { };
            /**
             * Event to fire on a double tap/click
             */
            this.onDoubleTap = function () { };
            /**
             * Event to fire on a long tap/click
             */
            this.onLongTap = function () { };
            this.touchObject = object;
            this.onSingleTap = singleTapEvent;
            this.onDoubleTap = doubleTapEvent;
            this.onLongTap = longTapEvent;
            this.touchObject.ontouchstart = function () {
                _this.startTouchClick();
            };
            this.touchObject.ontouchend = function () {
                _this.endTouchClick();
            };
            this.touchObject.onmousedown = function () {
                _this.startTouchClick();
            };
            this.touchObject.onmouseup = function () {
                _this.endTouchClick();
            };
            this.touchObject.onclick = function () {
                if (_this.touchUpTime - _this.touchDownTime >= _this.longTouchTime) {
                    _this.onLongTap();
                }
                else if (_this.tapTimer == -1) {
                    _this.tapTimer = setTimeout(function () {
                        _this.onSingleTap();
                        _this.tapTimer = -1;
                    }, _this.listenForDoubleTapTime);
                }
            };
            this.touchObject.ondblclick = function () {
                if (_this.tapTimer != -1)
                    clearTimeout(_this.tapTimer);
                _this.onDoubleTap();
                _this.tapTimer = -1;
            };
        }
        LRFTouchClickManager.prototype.startTouchClick = function () {
            this.touchDownTime = Date.now();
        };
        LRFTouchClickManager.prototype.endTouchClick = function () {
            this.touchUpTime = Date.now();
        };
        LRFTouchClickManager.prototype.finishTouchEvent = function () {
            var _this = this;
            setTimeout(function () {
                _this.touchDownTime = 0;
                _this.touchUpTime = 0;
            }, 200);
        };
        return LRFTouchClickManager;
    }());
    LRFUtils.LRFTouchClickManager = LRFTouchClickManager;
})(LRFUtils || (LRFUtils = {}));
