#ifndef __LRF_TRICKS_H
#define __LRF_TRICKS_H

#include "../system/types/lrf_types.h"
#include "../lrf_constants.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  LRFTrick_Character = -1,
  LRFTrick_Candle = 0, // character trick - defaults to candle...
  LRFTrick_FortuneTeller = 1
  // LRFTrick_BirthdayCandle = 1,
  // LRFTrick_ColorMixer = 2,
} LRFTrick_t;

typedef struct {
  LRFFunctionPtr  setup;
  LRFFunctionPtr  loop;
  LRFFunctionPtr  cleanup;
} LRFTrickSketch_t;

typedef struct {
	bool enabled;
  LRFTrick_t activeTrick;
} LRFTricks_t;
extern LRFTricks_t lrf_tricks;

// trick lifecycle
bool lrf_tricks_setup(void);
bool lrf_tricks_loop(void);
bool lrf_tricks_cleanup(void);

// run a trick with this
void lrf_tricks_run(LRFTrick_t trick);

// default event handler for quitting tricks
void lrf_tricks_exit(void);
void lrf_tricks_exitEvent(LRFEvent event);

#ifdef __cplusplus
}
#endif

#endif
