
#ifndef __LRF_EVENT_H
#define __LRF_EVENT_H

#ifdef __cplusplus
extern "C" {
#endif

//! \enum	LRFEvent
//! \brief	Constants for different interaction and system events
//! \ingroup events
/*! The LRF current features 16 unique events broken down into interaction and system events. Interaction events include things like touch events, light sensor events, mic events and IR events. System events include things like sleep, wake, powerup and boredom. */


typedef enum
{
	LRFEvent_None = 0xff,

	// 'Robot' (System) Events (0x00 - 0x1F)
	LRFEvent_RobotPowerUp = 0x00,
	LRFEvent_RobotIsHungry = 0x01,
	LRFEvent_RobotIsBored = 0x02,
	LRFEvent_RobotIsSleeping = 0x03,
	LRFEvent_RobotIsAwake = 0x04,

	LRFEvent_RobotGotMessage = 0x10,

	// Tap Events (0x20 - 0x2F)
	LRFEvent_Tap = 0x20,
	LRFEvent_Tickle = 0x21,
	LRFEvent_Hug = 0x22,

	LRFEvent_TapLeft = 0x23,
	LRFEvent_TickleLeft = 0x24,
	LRFEvent_HugLeft = 0x25,

	LRFEvent_TapRight = 0x26,
	LRFEvent_TickleRight = 0x27,
	LRFEvent_HugRight = 0x28,

	LRFEvent_SuperSqueeze = 0x29,
	LRFEvent_LongSuperSqueeze = 0x2a,		
	LRFEvent_LongHug = 0x2b,
	LRFEvent_LongHugLeft = 0x2c,
	LRFEvent_LongHugRight = 0x2d,

	LRFEvent_Squeeze = 0x2e,
	LRFEvent_LongSqueeze = 0x2f,

	// Light Events (0x30 - 0x3F)
	LRFEvent_LightNormal = 0x30,
	LRFEvent_LightTooDark = 0x31,
	LRFEvent_LightTooBright = 0x32,
	LRFEvent_LightTooDarkTooLong = 0x33,
	LRFEvent_LightTooBrightTooLong = 0x34,

	// Sound Events (0x40 - 0x4F)
	LRFEvent_SoundNormal = 0x40,
	LRFEvent_SoundTooLoud = 0x41,
	LRFEvent_SoundLikeTalking = 0x42,
	LRFEvent_SoundLikeNoTalking = 0x43,

	// Motion Events (0x50 - 0x5F)
	LRFEvent_TiltNone = 0x50,
	LRFEvent_TiltLeft = 0x51,
	LRFEvent_TiltRight = 0x52,
	LRFEvent_TiltForward = 0x53,
	LRFEvent_TiltBack = 0x54,
	LRFEvent_LayLeft = 0x55,
	LRFEvent_LayRight = 0x56,
	LRFEvent_LayForward = 0x57,
	LRFEvent_LayBack = 0x58,
	LRFEvent_Shake = 0x59,

	// Reserved (0x60 - 0x6f)

} LRFEvent;


//! \typedef	LRFEventHandler
//! \brief		Function pointer with no parameters and no return value
//! \ingroup	events
//! \see		LittleRobotFriend::setEventHandler(LRFEvent event, LRFEventHandler handler)
/*! This function pointer type is compatible with how the LRF handling events. Used in conjunction with a setEventHandler function, this allows you to create a custom handler for events.

 Usage:

	void myEventHandler(void){
 lrf.doSomething(); // do something
	}

	lrf.setEventHandler(LRFEvent_Tickle, &myEventHandler);
 */
typedef void (*LRFEventHandler)(LRFEvent event);


#ifdef __cplusplus
}
#endif

#endif
