/*

  eyesSetColors (green/blue)      3C 02 00 51 03 02 A8 0A

*/

#ifndef __LRF_MESSAGING_HANDLERS_H
#define __LRF_MESSAGING_HANDLERS_H

#include "../lrf_constants.h"
#include "types/lrf_message.h"

// handler prototypes
bool lrf_messaging_handler_getRobotInfo(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_getCharacterName(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_setCharacterName(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_setControlMode(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_sensorUpdate(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_setRobotType(LRFMessage *in, LRFMessage *out);

bool lrf_messaging_handler_eventsDidFire(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eventsGetMap(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eventsSetMap(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eventsFire(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eventsClear(LRFMessage *in, LRFMessage *out);

bool lrf_messaging_handler_eyesSet(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eyesSetColors(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_eyesBlinkPatterns(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_speechSet(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_speechSaySounds(LRFMessage *in, LRFMessage *out);

bool lrf_messaging_handler_blinkAndSay(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_blinkAndSayPreset(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_getPresetExpressions(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_getCustomPresetExpression(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_setCustomPresetExpression(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_chatter(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_singSong(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_getPresetSong(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_setPresetSong(LRFMessage *in, LRFMessage *out);

bool lrf_messaging_handler_sensesGetEnabled(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_sensesSetEnabled(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_touchGetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_touchSetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_touchRead(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_sightGetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_sightSetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_sightRead(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_hearingGetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_hearingSetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_hearingRead(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_motionGetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_motionSetConfig(LRFMessage *in, LRFMessage *out);
bool lrf_messaging_handler_motionRead(LRFMessage *in, LRFMessage *out);

#endif
