
#ifndef __LRF_MESSAGING_H
#define __LRF_MESSAGING_H

#include "../lrf_constants.h"
#include "types/lrf_message.h"

typedef struct
{
  bool                enabled;
  LRFMessage          in;
  LRFMessage          out;
  LRFMessageHandler   customHandler;
  LRFMessageHandler   systemHandlers[LRF_MESSAGE_CMD_SYSTEM_COUNT];
} lrf_messaging_t;

extern lrf_messaging_t lrf_messaging;

void lrf_messaging_init(void);
void lrf_messaging_process(void);

bool lrf_messaging_systemHandler(LRFMessage *in, LRFMessage *out);
void lrf_messaging_setSystemHandler(LRFMessageCmd cmd, LRFMessageHandler handler);
void lrf_messaging_setCustomHandler(LRFMessageHandler handler);

unsigned char lrf_messaging_writeMessage(LRFMessage *message);

#endif
