#ifndef _LRF_MIC_H
#define _LRF_MIC_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"
#include "lrf_device_pins.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFMicLoudLevel_Low	= (LRF_MIC_LOUD_VALUE - 500),
	LRFMicLoudLevel_Normal = LRF_MIC_LOUD_VALUE,
	LRFMicLoudLevel_High	= (LRF_MIC_LOUD_VALUE + 500),
} LRFMicLoudLevel;

typedef struct __attribute__((__packed__))
{
	LRFDebugLevel debugLevel;
	uint16_t value;
	LRFMicLoudLevel loudLevel;
	bool windowEnabled;
	bool windowFlag;
} LRFMic_t;

extern LRFMic_t lrf_mic;


void lrf_mic_init(bool windowMode=false);
void lrf_mic_read(void);

#if LRF_DEVICE_TEST
void lrf_mic_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
