#ifndef __LRF_LEDS_H
#define __LRF_LEDS_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"
#include "lrf_device_pins.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_LED_PWM_HIGH		100
#define LRF_LED_PWM_LOW		0
#define LRF_LED_PWM_COUNT		6

// Map of LED channels to PWM pins
typedef enum
{
	LRFLedsChannel_LR = LRF_PINS_RGBL_R,
	LRFLedsChannel_LG = LRF_PINS_RGBL_G,
	LRFLedsChannel_LB = LRF_PINS_RGBL_B,
	LRFLedsChannel_RR = LRF_PINS_RGBR_R,
	LRFLedsChannel_RG = LRF_PINS_RGBR_G,
	LRFLedsChannel_RB = LRF_PINS_RGBR_B
} LRFLedsChannel;

typedef enum
{
	LRFLedLevel_Low = 0,		// enabled in low-power mode
	LRFLedLevel_Normal = 1,	// default
	LRFLedLevel_High = 2		// enabled in code
} LRFLedLevel;

typedef struct __attribute__((__packed__))
{
	LRFDebugLevel debugLevel;
	LRFLedLevel	level;
} LRFLeds_t;

extern LRFLeds_t lrf_leds;


void lrf_leds_init(void);
void lrf_leds_set(LRFLedsChannel channel, unsigned char value);

void lrf_leds_setStatus(bool state);
void lrf_leds_flashStatus(uint8_t times, uint16_t duration);

#if LRF_DEVICE_TEST
void lrf_leds_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
