
#include <LittleRobotFriends.h>

/*
 * Sounds are best when combined in arrays.
 * Then you can begin to make songs or expressions!
 *
 * Let's check out the different intonations with an
 * array of sounds!
 */

LRFSound mySounds[5] = {
{ LRFNote_C, LRFOctave_3, LRFIntonation_Flat, LRFDuration_DoubleLong, LRFDuration_Medium },
{ LRFNote_C, LRFOctave_3, LRFIntonation_Rising, LRFDuration_DoubleLong, LRFDuration_Medium },
{ LRFNote_C, LRFOctave_3, LRFIntonation_Falling, LRFDuration_DoubleLong, LRFDuration_Medium },
{ LRFNote_C, LRFOctave_3, LRFIntonation_Peaking, LRFDuration_DoubleLong, LRFDuration_Medium },
{ LRFNote_C, LRFOctave_3, LRFIntonation_Dipping, LRFDuration_DoubleLong, LRFDuration_Medium }
};


// ------------------------------
// Setup & Loop
// ------------------------------

void setup()
{
  // turn things on/off before we set-up
  lrf.motion.disable();
  lrf.hearing.disable();
  lrf.touch.disable();
  lrf.sight.disable();

  // set up our library
  lrf.setup();
}

void loop()
{
  // run our library loop
  lrf.loop();

  // say our sounds
  lrf.speech.saySounds(mySounds, 5, true);

  // short delay
  delay(1000);
}
