
#ifndef __LRF_SENSOR_H
#define __LRF_SENSOR_H

#include <stdint.h>
#include <stdbool.h>

// Sensor
#define LRF_SENSORS_DEBUG				0
#define LRF_SENSOR_SAMPLE_COUNT		8
#define LRF_SENSOR_HISTORY_COUNT		8
#define LRF_SMOOTHING_BUFFER_COUNT		8

#ifdef __cplusplus
extern "C" {
#endif

// SMOOTHING is going to move to the device side of things. Let's assume samples are pre-smoothed
typedef struct
{
	uint8_t		ready:1;
	uint8_t		idx:7;
	int16_t		buffer[LRF_SMOOTHING_BUFFER_COUNT];
} __attribute__ ((packed)) LRFSensorBuffer;

typedef struct
{
	int16_t			value;
	uint16_t		timestamp;				// middle two bytes of millis()
} __attribute__ ((packed)) LRFSensorSample;

typedef struct
{
	uint8_t				idx;				// index of our current sample
	int16_t				value;				// storage of our current sample
	int16_t				mean;				//
	int16_t				max;				//
	int16_t				min;				//
	uint16_t			timestamp;			// middle two bytes of millis()
	LRFSensorSample	*last;				// pointer to our last sample
	LRFSensorSample	samples[LRF_SENSOR_SAMPLE_COUNT];	// buffer of samples
	bool				evaluate;			// flag to see if we should evaluate samples
	bool				ready;				// flag to see if our buffer is ready for evaluation

	// maybe move these to other structure?
	bool				calibrated;			// flag to see if we are calibrated
	uint32_t			nextReadTime;		// next time to read (in milliseconds)

	uint8_t				state;				// sensor state (for pattern detection?)
	bool				changed;			// did our state change?
	uint32_t			changedTime;		// time since last state change
} __attribute__ ((packed)) LRFSensor;

typedef void(*LRFSensorFunctionPtr)(LRFSensor *sensor);

// Helper functions
void lrf_sensor_reset(LRFSensor *sensor);
void lrf_sensor_process(int16_t newValue, LRFSensor *sensor, LRFSensorFunctionPtr analyze);
void lrf_sensor_setState(LRFSensor *sensor, uint8_t state);
void lrf_sensor_clearState(LRFSensor *sensor);

#ifdef __cplusplus
}
#endif

#endif
