
#ifndef __LRF_MESSAGE_H
#define __LRF_MESSAGE_H

/*

	Currently...
	[START_TOKEN] [MSG_CODE] [MSG_LENGTH] [MSG_CRC] [MSG_DATA] [END_TOKEN]

	Should it be...
	[START_TOKEN] [MSG_INFO] [MSG_LENGTH] [MSG_CMD] [MSG_DATA] [MSG_CRC] [END_TOKEN] ??

	Custom commands can be any value from LRF_MESSAGE_CMD_CUSTOM_IDX_START to LRF_MESSAGE_CMD_CUSTOM_IDX_END.

	System commands are from LRF_MESSAGE_CMD_SYSTEM_IDX_START to LRF_MESSAGE_CMD_SYSTEM_IDX_END.


*/

#include <stdbool.h>
#include <stdint.h>
//#include <Arduino.h>
//#include <variant.h>

#include <WVariant.h>
#include <SERCOM.h>
#include <Uart.h>
#include <USB/USBAPI.h>

// #ifdef __cplusplus
// extern "C" {
// #endif

#define LRF_MESSAGE_START_TOKEN							'<'
#define LRF_MESSAGE_END_TOKEN								0x0A
#define LRF_MESSAGE_TOKEN_SIZE							2		// size of token bytes

#define LRF_MESSAGE_HEADER_SIZE							4		// length, info, command, crc
#define LRF_MESSAGE_LENGTH_IDX							0

#define LRF_MESSAGE_DATA_MIN_SIZE						0
#define LRF_MESSAGE_DATA_MAX_SIZE						64

#define LRF_MESSAGE_MIN_SIZE								LRF_MESSAGE_DATA_MIN_SIZE + LRF_MESSAGE_HEADER_SIZE
#define LRF_MESSAGE_MAX_SIZE								LRF_MESSAGE_DATA_MAX_SIZE + LRF_MESSAGE_HEADER_SIZE

#define LRF_MESSAGE_CMD_SYSTEM_IDX_START		0x40	// hex 0x40 - 0x7f
#define LRF_MESSAGE_CMD_SYSTEM_IDX_END			0x7F
#define LRF_MESSAGE_CMD_SYSTEM_COUNT				1+(LRF_MESSAGE_CMD_SYSTEM_IDX_END - LRF_MESSAGE_CMD_SYSTEM_IDX_START)

#define LRF_MESSAGE_CMD_CUSTOM_IDX_START		0x00		// hex 0x00 - 0x39
#define LRF_MESSAGE_CMD_CUSTOM_IDX_END			0x3F
#define LRF_MESSAGE_CMD_CUSTOM_COUNT				1+(LRF_MESSAGE_CMD_CUSTOM_IDX_END - LRF_MESSAGE_CMD_CUSTOM_IDX_START)

typedef enum
{
	// system commands  0x40 -> 0x4F
	LRFMessageCmd_GetRobotInfo 						=0x40,	// 64
	LRFMessageCmd_GetCharacterName 				=0x41,	// 65
	LRFMessageCmd_SetCharacterName 				=0x42,	// 66
	LRFMessageCmd_SetControlMode	 				=0x43,	// 67
	LRFMessageCmd_SensorUpdate						=0x44,	// 68 - get/send the current state of sensors
	LRFMessageCmd_SetRobotType						=0x45,	// 69
	// event mapping 0x4a-0x4f
	LRFMessageCmd_EventsDidFire       		=0x4a,	// 74
	LRFMessageCmd_EventsGetMap       			=0x4b,	// 75
	LRFMessageCmd_EventsSetMap       			=0x4c,	// 76
	LRFMessageCmd_EventsFire       				=0x4d,	// 77
	LRFMessageCmd_EventsClear       			=0x4e,	// 78
	// eyes & speech commands 0x50 -> 0x5F
	LRFMessageCmd_EyesSet 								=0x50,	// 80
	LRFMessageCmd_EyesSetColors 					=0x51,	// 81
	LRFMessageCmd_EyesBlinkPatterns 			=0x52,	// 82
	LRFMessageCmd_SpeechSet								=0x53,	// 83
	LRFMessageCmd_SpeechSaySounds					=0x54,	// 84
	LRFMessageCmd_BlinkAndSay		 					=0x57,	// 87
	LRFMessageCmd_BlinkAndSayPreset 			=0x58,	// 88
	LRFMessageCmd_GetPresetExpressions 		=0x59,	// 89
	LRFMessageCmd_GetCustomPresetExpression		=0x5a,	// 90
	LRFMessageCmd_setCustomPresetExpression		=0x5b,	// 91
	LRFMessageCmd_Chatter 								=0x5c, 	// 92
	LRFMessageCmd_SingSong 								=0x5d,	// 93
	LRFMessageCmd_GetPresetSong 					=0x5e,	// 94
	LRFMessageCmd_SetPresetSong 					=0x5f,	// 95
	// sensor commands 0x60 -> 0x6F
	LRFMessageCmd_SensesGetEnabled				=0x60,	// 96
	LRFMessageCmd_SensesSetEnabled				=0x61,	// 97
	LRFMessageCmd_TouchGetConfig					=0x62,	// 98
	LRFMessageCmd_TouchSetConfig					=0x63,	// 99
	LRFMessageCmd_TouchRead								=0x64,	// 100
	LRFMessageCmd_HearingGetConfig				=0x65,	// 101
	LRFMessageCmd_HearingSetConfig				=0x66,	// 102
	LRFMessageCmd_HearingRead							=0x67,	// 103
	LRFMessageCmd_SightGetConfig					=0x68,	// 104
	LRFMessageCmd_SightSetConfig					=0x69,	// 105
	LRFMessageCmd_SightRead								=0x6a,	// 106
	LRFMessageCmd_MotionGetConfig					=0x6b,	// 107
	LRFMessageCmd_MotionSetConfig					=0x6c,	// 108
	LRFMessageCmd_MotionRead							=0x6d,	// 109
	// comm commands 0x70 -> 0x7f
} LRFMessageCmd;

typedef enum
{
	LRFMessageInterface_Code 					=0,
	LRFMessageInterface_Usb 					=1,
	LRFMessageInterface_IrDA 					=2,
	LRFMessageInterface_Ext 					=3
} LRFMessageInterface;

typedef struct
{
	uint8_t requiresResponse:1;	// does this message need response
	uint8_t version:3;					// message version
	uint8_t interface:2;				// interface (set by receiver)
	uint8_t prefersBlocking:1;
	uint8_t reserved:1;					// future storage for additional length bits
} LRFMessageInfo;

typedef struct __attribute__((__packed__))
{
	uint8_t length;		// length of message data
	uint8_t info;			// message meta information (2 bits might be used for additional length)
	uint8_t cmd;			// message command
	uint8_t data[LRF_MESSAGE_DATA_MAX_SIZE];
	uint8_t crc;			// crc value
} LRFMessage;
#define LRFMessage_Blank					(LRFMessage){ .length=0, .info=0, .cmd=0 }

typedef bool (*LRFMessageHandler)(LRFMessage *msgIn, LRFMessage *msgOut);
#define LRFMessageHandler_Null		(LRFMessageHandler)(NULL)

uint8_t lrf_message_crc_make(LRFMessage *in);
bool lrf_message_crc_check(LRFMessage *in);

//template <typename T> bool lrf_message_read(T *s, LRFMessage *in);
bool lrf_message_read_uart(Uart *s, LRFMessage *in);
bool lrf_message_read_serial(Serial_ *s, LRFMessage *in);

// #ifdef __cplusplus
// }
// #endif

#endif
