
#ifndef __LRF_TOUCH_H
#define __LRF_TOUCH_H

#include "../../lrf_constants.h"
#include "../types/lrf_sensor.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFTouchSensitivity_Low 		= 40, // less sensitive
	LRFTouchSensitivity_Normal 	= 30,
	LRFTouchSensitivity_High 		= 20, // more sensitive
} LRFTouchSensitivity;


// some states
typedef enum
{
	LRFTouchState_Tap = 1,
	LRFTouchState_Tickle = 2,
	LRFTouchState_Hug = 3,
	LRFTouchState_LongHug = 4
} LRFTouchState;

// define our library object
typedef struct
{
	bool		enabled;
	uint8_t tapCount;
	uint32_t	nextReadTime;									// timestamp for next reading
	LRFTouchSensitivity	hairSensitivity;		// sensitivity for hair sensor
	LRFTouchSensitivity	leftSensitivity;
	LRFTouchSensitivity	rightSensitivity;
	LRFSensor	hair;													// hair sensor
	LRFSensor	left;													// left hand sensor
	LRFSensor	right;												// right hand sensor

} LRFTouch_t;

// create an external reference for that object
extern LRFTouch_t lrf_touch;

// public functions
void lrf_touch_init(void);		// initialize the sensors
void lrf_touch_update(void);	// update our sensor data

void lrf_touch_setHairSensitivity(LRFTouchSensitivity level);
void lrf_touch_setLeftSensitivity(LRFTouchSensitivity level);
void lrf_touch_setRightSensitivity(LRFTouchSensitivity level);

// private functions
void lrf_touch_analyze(LRFSensor *sensor);

// library test
#if LRF_SYSTEM_TEST
void lrf_touch_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
