
#ifndef __LRF_SIGHT_H
#define __LRF_SIGHT_H

#include "../../lrf_constants.h"
#include "../types/lrf_sensor.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LRF_SIGHT_VALUE_MARGIN         	50        // margin around offsets for hysteresis
#define LRF_SIGHT_DARK_OFFSET				   	(-1000)   // offset from normal for darkness
#define LRF_SIGHT_BRIGHT_OFFSET				 	(1200)    // offset from normal for brightness
#define LRF_SIGHT_READ_PERIOD				   	10        // frequency of reading (in ms?)
#define LRF_SIGHT_TOO_LONG_PERIOD			 	5000	     // # of ms until reading is considered 'tooLong'
#define LRF_SIGHT_VALUE_NORMAL_MARGIN		500
#define LRF_SIGHT_DARK_LIMIT						500
#define LRF_SIGHT_BRIGHT_LIMIT					3800

typedef enum
{
	LRFSightBrightSensitivity_Low 		= (LRF_SIGHT_BRIGHT_OFFSET + 200), // less sensitive
	LRFSightBrightSensitivity_Normal 	= (LRF_SIGHT_BRIGHT_OFFSET),
	LRFSightBrightSensitivity_High 		= (LRF_SIGHT_BRIGHT_OFFSET - 200), // more sensitive
} LRFSightBrightSensitivity;

typedef enum
{
	LRFSightDarkSensitivity_Low 		= (LRF_SIGHT_DARK_OFFSET - 200), // less sensitive
	LRFSightDarkSensitivity_Normal 	= (LRF_SIGHT_DARK_OFFSET),
	LRFSightDarkSensitivity_High 		= (LRF_SIGHT_DARK_OFFSET + 200), // more sensitive
} LRFSightDarkSensitivity;

// the states of our sensor
typedef enum
{
	LRFSightState_Idle 								= 0,
	LRFSightState_TooDark 						= 1,
	LRFSightState_TooBright 					= 2,
	LRFSightState_Normal 							= 3,
	LRFSightState_DarkerThanNormal 		= 4,
	LRFSightState_BrighterThanNormal 	= 5
} LRFSightState;

// define our library object
typedef struct
{
	bool									enabled;
	bool									debug;
	uint32_t							nextReadTime;	// timestamp for next reading
	bool									tooLongFlag;
	uint16_t							tooLongTime;
	LRFSightDarkSensitivity			darkSensitivity;
	LRFSightBrightSensitivity		brightSensitivity;
	int16_t 							darkThreshold;
	int16_t								brightThreshold;
	int16_t								normalLevel;
	int16_t 							normalMax;
	int16_t 							normalMin;
	LRFSensor							level;			// light level
} LRFSight_t;

// an external ref for our object
extern LRFSight_t lrf_sight;

// public functions
void lrf_sight_init(void);
void lrf_sight_update(void);
void lrf_sight_recalibrate(void);

void lrf_sight_setDarkSensitivity(LRFSightDarkSensitivity value);
void lrf_sight_setBrightSensitivity(LRFSightBrightSensitivity value);

// private
void lrf_sight_debug(void);

// library test
#if LRF_SYSTEM_TEST
void lrf_sight_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
