
#ifndef __LRF_MOTION_H
#define __LRF_MOTION_H

#include "../../lrf_constants.h"
#include "../types/lrf_sensor.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFMotionState_TiltNone = 1,
	LRFMotionState_TiltUp = 2,
	LRFMotionState_TiltDown = 3,
	LRFMotionState_LayUp = 4,
	LRFMotionState_LayDown = 5,
} LRFMotionState;

typedef enum
{
	LRFMotionShakeState_On = 1,
	LRFMotionShakeState_Off = 2
} LRFMotionShakeState;

typedef enum
{
	LRFTiltAxis_X = 0,
	LRFTiltAxis_Y = 1,
	LRFTiltAxis_Z = 2
} LRFTiltAxis;

typedef struct
{
	bool				enabled;
	bool				debug;
	uint32_t		nextReadTime;
	LRFTiltAxis	tiltAxis;

	int16_t			tiltValue;
	int16_t			layValue;

	bool				xTooLongFlag;
	bool				yTooLongFlag;
	bool				shakeTooLongFlag;
	uint16_t		tooLongTime;

	LRFSensor		x;
	LRFSensor		y;
	LRFSensor		z;
	LRFSensor		shake;
} LRFMotion_t;

extern LRFMotion_t lrf_motion;

// Public
void lrf_motion_init(void);
void lrf_motion_update(void);
void lrf_motion_debug(LRFSensor *sensor, const char *s);
void lrf_motion_debugShake(LRFSensor *sensor);

// Private
void lrf_motion_analyze(LRFSensor *sensor);
void lrf_motion_analyzeShake(LRFSensor *sensor);

#if LRF_SYSTEM_TEST
void lrf_motion_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
