
#ifndef __LRF_INFRARED_H
#define __LRF_INFRARED_H

#include "../lrf_constants.h"
#include "types/lrf_message.h"

#define LRF_INFRARED_DEBUG_VERBOSE      false

typedef struct
{
  bool                enabled;
  LRFMessageHandler   handler;
  LRFMessage          in;
  LRFMessage          out;
} lrf_infrared_t;

extern lrf_infrared_t lrf_infrared;

void lrf_infrared_init(void);
void lrf_infrared_process(void);

bool lrf_infrared_defaultMessageHandler(LRFMessage *in, LRFMessage *out);
void lrf_infrared_setMessageHandler(LRFMessageHandler handler);

void lrf_infrared_writeMessage(LRFMessage *message);

#endif
