
#ifndef __LRF_EVENTS_H
#define __LRF_EVENTS_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"
#include "data/lrf_expression_data.h"
#include "types/lrf_types.h"

#define LRF_EVENTS_DEBUG										true
#define LRF_EVENTS_DEBUG_VERBOSE						false

#define LRF_EVENTS_HISTORY_SIZE							4
#define LRF_EVENTS_QUEUE_SIZE								4

#define LRF_EVENT_HANDLER_COUNT							128

#define LRF_EVENTS_SYSTEM_START_IDX					0x00
#define LRF_EVENTS_SYSTEM_END_IDX						0x1f
#define LRF_EVENTS_INTERACTION_START_IDX		0x20
#define LRF_EVENTS_INTERACTION_END_IDX			0x5f
#define LRF_EVENTS_COMMUNICATION_START_IDX	0x60
#define LRF_EVENTS_COMMUNICATION_END_IDX		0x7f

#define LRF_EVENTS_FEW_IN_A_ROW							3
#define LRF_EVENTS_COUPLE_IN_A_ROW					2

#define LRF_EVENTS_BOREDOM_ENABLED					true
//#define LRF_EVENTS_BOREDOM_TIMEOUT					(5000)
#define LRF_EVENTS_BOREDOM_TIMEOUT					(60000)
#define LRF_EVENTS_BOREDOM_TO_SLEEP_MAX			(3)

#define LRF_EVENT_IS_SYSTEM_EVENT(event) 		(event >= LRF_EVENTS_SYSTEM_START_IDX && event <= LRF_EVENTS_SYSTEM_END_IDX)
#define LRF_EVENT_IS_WAKE_EVENT(event) 			(event == LRFEvent_TiltNone || event == LRFEvent_Tickle || event == LRFEvent_TickleLeft || event == LRFEvent_TickleRight)


#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	LRFDebugLevel		debugLevel;
	bool						enabled;
	bool						expressionsEnabled;
	bool						sleepEnabled;
	bool						sleeping;
	bool						sleepy;
	LRFEvent				eventHistory[LRF_EVENTS_HISTORY_SIZE];
	LRFEvent				eventQueue[LRF_EVENTS_QUEUE_SIZE];
	unsigned char		eventQueueCount;
	unsigned long		lastInteractionTime;
	unsigned long		boredTimeout;
	unsigned char		boredCount;
	unsigned long		boredTimeoutReload;
	unsigned char		boredCountReload;
	LRFEventHandler	eventHandlers[LRF_EVENT_HANDLER_COUNT];
	//LRFExpressionName	expressionMap[LRF_EVENT_HANDLER_COUNT];
} LRFEvents_t;

extern LRFEvents_t lrf_events;

void lrf_events_init(void);
void lrf_events_process(void);

void lrf_events_enable(void);
void lrf_events_disable(void);

void lrf_events_setBoredomTimer(unsigned int seconds);

void lrf_events_enableExpressions(void);
void lrf_events_disableExpressions(void);

void lrf_events_update_interaction(void);

void lrf_events_set(LRFEvent event, LRFEventHandler eventHandler);
void lrf_events_unset(LRFEvent event);
void lrf_events_reset(void);
void lrf_events_clear(void);

LRFEvent lrf_events_next(void);

void lrf_events_system_handler(LRFEvent *event);
void lrf_events_default_handler(LRFEvent event);

void lrf_events_add(LRFEvent event);

void lrf_events_handleSystemEvent(LRFEvent event);
void lrf_events_handleEvent(LRFEvent event);

void lrf_events_fire(LRFEvent event);

void lrf_events_loadExpressionMapFromMemories(void);
void lrf_events_loadExpressionMapToMemories(void);

unsigned char lrf_events_history_count(LRFEvent event);
unsigned char lrf_events_history_continuous(LRFEvent event);

#ifdef __cplusplus
}
#endif

#endif
