#ifndef __LRF_SPEAKER_H
#define __LRF_SPEAKER_H

#include "../lrf_constants.h"
#include "../lrf_debug.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  LRFDebugLevel debugLevel;
} lrf_speaker_t;

extern lrf_speaker_t lrf_speaker;

void lrf_speaker_init(void);
void lrf_speaker_on(void);
void lrf_speaker_off(void);
void lrf_speaker_set_frequency(unsigned int freq);
unsigned int lrf_speaker_get_frequency(void);
void lrf_speaker_set_duty(unsigned int duty);

#if LRF_DEVICE_TEST
void lrf_speaker_test(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
