#ifndef __LRFINFRARED_H
#define __LRFINFRARED_H

#include "LRFConfig.h"

class LRFInfrared
{
public:
  void enable(void);
  void disable(void);

  // writing
  void writeMessage(LRFMessage *msg);
  void writeBytes(unsigned char *bytes, unsigned char length);
  void writeByte(unsigned char byte);

  // reading
  bool readMessage(LRFMessage *msg, unsigned int timeout=1000);
  unsigned char readBytes(unsigned char *bytes, unsigned char length, unsigned int timeout=1000);
  bool readByte(unsigned char *byte, unsigned int timeout=1000);

  // using message handlers
  void setMessageHandler(LRFMessageHandler handler);

private:

};

#endif
