
#ifndef __LRF_PATTERN_H
#define __LRF_PATTERN_H

#include <stdint.h>
#include "lrf_color.h"
#include "lrf_duration.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef enum
{
	LRFTransform_None		= 0b00000000,
	LRFTransform_Boomerang	= 0b00000001,
	LRFTransform_ZigZag	= 0b00000010,
	LRFTransform_Flat		= 0b00000100,
	LRFTransform_Flip		= 0b00001000,
	LRFTransform_Random	= 0b00010000,
} LRFTransform;

typedef struct __attribute__((__packed__))
{
	uint8_t					boomerang:1;
	uint8_t					zigzag:1;		// will the values 'boomerang' (return to initial value before finishing?)
	uint8_t					flat:1;			// should we disable fading?
	uint8_t					flip:1;			// will the values flip at the end?
	uint8_t					random:1;
	uint8_t					reserved:3;
} LRFTransformOptions;


#define LRF_PATTERN_BLANK		{ LRFColor_Clear, LRFColor_Clear, LRFTransform_None, LRFDuration_None }
#define LRF_PATTERN_SIZE		2

typedef struct __attribute__((__packed__))
{
	LRFColor				colorA:4;		//!< Starting color
	LRFColor				colorB:4;		//!< Target color
	LRFTransform			transform:5;
	LRFDuration			duration:3;
} LRFPattern;

typedef union
{
	LRFPattern		pattern;
	uint8_t			bytes[LRF_PATTERN_SIZE];
	uint16_t		word;
} LRFPatternUnion;

// Macros
//#define LRF_PATTERN_PACK(start, target, flip, zigzag, flat, random)  (start&0xf) | ((target&0xf)<<4) | (flip<<8) | (zigzag<<9) | (flat<<10) | (random<<11)

// Functions
//uint16_t lrf_pattern_pack(LRFColor start, LRFColor target, bool flip, bool zigzag, bool flat, bool random);
//LRFPatternStruct lrf_pattern_unpack(uint16_t patternData);


//LRFPattern lrf_make_pattern(LRFColor start, LRFColor target, boolean flip, boolean zigzag, boolean flat);


#ifdef __cplusplus
}
#endif

#endif
