
#ifndef __LRF_DURATION_H
#define __LRF_DURATION_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFDuration_None = 0,		//!< No duration (0 ms)
	LRFDuration_Short,			//!< Base * 1 (1/16 note)
	LRFDuration_DoubleShort,	//!< Base * 2 (1/8 note)
	LRFDuration_Medium,		//!< Base * 4 (1/4 note)
	LRFDuration_DoubleMedium,	//!< Base * 8 (1/2 note)
	LRFDuration_Long,			//!< Base * 16 (whole note)
	LRFDuration_DoubleLong,	//!< Base * 32 (double whole note)
	LRFDuration_VeryLong		//!< Base * 64 (quad whole note)
} LRFDuration;

unsigned int lrf_duration_lookup(LRFDuration duration);

#ifdef __cplusplus
}
#endif

#endif

