
#ifndef __LRF_COLOR_H
#define __LRF_COLOR_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	LRFColor_Clear = 0,		//!< LEDs off (no color)
	LRFColor_Red = 1,				//!< Red
	LRFColor_Green = 2,			//!< Green
	LRFColor_Blue = 3,				//!< Blue
	LRFColor_Orange = 4,			//!< Orange
	LRFColor_Cyan = 5,				//!< Cyan
	LRFColor_Purple = 6,			//!< Purple
	LRFColor_Yellow = 7,			//!< Yellow
	LRFColor_Pink = 8,				//!< Pink
	LRFColor_LightOrange = 9,
	LRFColor_LightCyan = 10,
	LRFColor_LightPurple = 11,
	LRFColor_LightYellow = 12,
	LRFColor_LightPink = 13,
	LRFColor_LightGreen = 14,
	LRFColor_White = 15		//!< White
} LRFColor;

typedef struct
{
	unsigned char red;			//!< Red value (8-bits)
	unsigned char green;		//!< Green value (8-bits)
	unsigned char blue;			//!< Blue value (8-bits)
} LRFColorValue;

void lrf_color_lookup(LRFColor color, LRFColorValue *value);
void lrf_color_random(LRFColorValue *value);

#ifdef __cplusplus
}
#endif

#endif
