
#ifndef __LRF_SYSTEM_H
#define __LRF_SYSTEM_H

#include "lrf_time.h"
#include "lrf_eyes.h"
#include "lrf_speech.h"
#include "lrf_expressions.h"
#include "lrf_events.h"
#include "lrf_infrared.h"
#include "lrf_messaging.h"
#include "../character/lrf_character.h"

#include "types/lrf_types.h"
#include "senses/lrf_senses.h"
//#include "messages/lrf_messages.h"


#ifdef __cplusplus
extern "C" {
#endif


typedef enum {
  LRFRunMode_Boot = 0,      // default run mode on power-up
  LRFRunMode_Normal = 1,    // normal, untethered run mode
  LRFRunMode_Remote = 2,    // system is being remote controlled!
  LRFRunMode_Sleep = 3,     // device is sleeping!
  LRFRunMode_Trick = 4      // perform a trick!
} LRFRunMode_t;

typedef struct {
  LRFRunMode_t  runMode;
} LRFSystem_t;

extern LRFSystem_t lrf_system;


void lrf_system_init(void);
void lrf_system_process(void);

void lrf_system_setRunMode(LRFRunMode_t mode, uint8_t options=0);


#ifdef __cplusplus
}
#endif

#endif
